/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.idrepo;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AttributeValues;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.idrepo.IdentityCommand;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;

public class DeleteIdentities
extends IdentityCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String realm = this.getStringOptionValue("realm");
        String type = this.getStringOptionValue("idtype");
        ArrayList idNames = rc.getOption("idnames");
        String file = this.getStringOptionValue("file");
        if (idNames == null) {
            idNames = new ArrayList();
        }
        if (file != null) {
            idNames.addAll(AttributeValues.parseValues(file));
        }
        if (idNames.isEmpty()) {
            throw new CLIException(this.getResourceString("missing-identity-names"), 127);
        }
        String displayableIdNames = this.tokenize(idNames);
        String[] params = new String[]{realm, type, displayableIdNames};
        this.writeLog(0, Level.INFO, "ATTEMPT_DELETE_IDENTITY", params);
        try {
            new OrganizationConfigManager(adminSSOToken, realm);
        }
        catch (SMSException e) {
            String[] args = new String[]{realm, type, displayableIdNames, e.getMessage()};
            this.debugError("DeleteIdentities.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_DELETE_IDENTITY", args);
            Object[] msgArg = new Object[]{realm};
            throw new CLIException(MessageFormat.format(this.getResourceString("realm-does-not-exist"), msgArg), 127);
        }
        try {
            AMIdentityRepository amir = new AMIdentityRepository(adminSSOToken, realm);
            IdType idType = this.convert2IdType(type);
            HashSet<AMIdentity> setDelete = new HashSet<AMIdentity>();
            for (String idName : idNames) {
                AMIdentity amid = new AMIdentity(adminSSOToken, idName, idType, realm, null);
                boolean exist = false;
                try {
                    exist = amid.isExists();
                }
                catch (IdRepoException e) {
                    // empty catch block
                }
                if (!exist) {
                    String[] args = new String[]{realm, type, displayableIdNames, "user " + idName + " does not exist"};
                    this.writeLog(1, Level.INFO, "FAILED_DELETE_IDENTITY", args);
                    Object[] msgArg = new Object[]{idName};
                    throw new CLIException(MessageFormat.format(this.getResourceString("identity-does-not-exist"), msgArg), 127);
                }
                setDelete.add(amid);
            }
            amir.deleteIdentities(setDelete);
            IOutput outputWriter = this.getOutputWriter();
            Object[] objects = new Object[]{realm, type};
            if (idNames.size() > 1) {
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("delete-identities-succeed"), objects));
            } else {
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("delete-identity-succeed"), objects));
            }
            Iterator i = idNames.iterator();
            while (i.hasNext()) {
                outputWriter.printlnMessage("    " + (String)i.next());
            }
            this.writeLog(0, Level.INFO, "SUCCEED_DELETE_IDENTITY", params);
        }
        catch (IdRepoException e) {
            String[] args = new String[]{realm, type, displayableIdNames, e.getMessage()};
            this.debugError("DeleteIdentities.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_DELETE_IDENTITY", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, type, displayableIdNames, e.getMessage()};
            this.debugError("DeleteIdentities.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_DELETE_IDENTITY", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

