/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.authentication;

import com.iplanet.jato.NavigationException;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.authentication.AuthPropertiesViewBean;
import com.sun.identity.console.authentication.model.AuthProfileModelImpl;
import com.sun.identity.console.authentication.model.AuthPropertiesModel;
import com.sun.identity.console.authentication.model.AuthPropertiesModelImpl;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.AMServiceProfileViewBeanBase;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class EditAuthTypeViewBean
extends AMServiceProfileViewBeanBase {
    public static final String DEFAULT_DISPLAY_URL = "/console/authentication/EditAuthType.jsp";
    public static final String SERVICE_TYPE = "authServiceType";
    private AuthPropertiesModel authModel = null;

    public EditAuthTypeViewBean() {
        super("EditAuthType", DEFAULT_DISPLAY_URL, null);
        String type = (String)this.getPageSessionAttribute(SERVICE_TYPE);
        if (type != null) {
            String name = this.getServiceName(type);
            if (name == null) {
                name = "iPlanetAMAuthService";
                debug.warning("EditAuthTypeViewBean() The auth instance could not be found. The instance name has been reset to " + name);
            }
            this.initialize(name);
        }
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        String instance = (String)this.getPageSessionAttribute(SERVICE_TYPE);
        AuthPropertiesModel model = this.getAuthModel();
        if (model != null) {
            AMPropertySheet ps = (AMPropertySheet)this.getChild("propertyAttributes");
            Map map = model.getInstanceValues(instance);
            ps.setAttributeValues(map, model);
        }
    }

    public void forwardTo(RequestContext reqContext) throws NavigationException {
        String name = this.getServiceName((String)this.getPageSessionAttribute(SERVICE_TYPE));
        this.initialize(name);
        super.forwardTo(reqContext);
    }

    protected String getBackButtonLabel() {
        return this.getBackButtonLabel("config.auth.label");
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        String instance = (String)this.getPageSessionAttribute(SERVICE_TYPE);
        AuthPropertiesModel model = this.getAuthModel();
        if (this.getServiceName(instance) == null) {
            this.returnToAuthProperties(model.getLocalizedString("no.module.instance"));
        } else {
            if (model != null) {
                try {
                    Map values = this.getValues();
                    model.setInstanceValues(instance, values);
                    this.setInlineAlertMessage("info", "message.information", "message.updated");
                }
                catch (AMConsoleException e) {
                    this.setInlineAlertMessage("error", "message.error", e.getMessage());
                }
            }
            this.forwardTo();
        }
    }

    public void handleButton2Request(RequestInvocationEvent event) throws ModelControlException {
        String instance = (String)this.getPageSessionAttribute(SERVICE_TYPE);
        if (this.getServiceName(instance) == null) {
            debug.warning("EditAuthTypeViewBean.handleButton2Request() The instance " + instance + " could not be found");
            AuthPropertiesModel model = this.getAuthModel();
            this.returnToAuthProperties(model.getLocalizedString("no.module.instance"));
        } else {
            super.handleButton2Request(event);
        }
    }

    public void handleButton3Request(RequestInvocationEvent event) {
        this.returnToAuthProperties(null);
    }

    private void returnToAuthProperties(String message) {
        this.backTrail();
        AuthPropertiesViewBean vb = (AuthPropertiesViewBean)this.getViewBean(AuthPropertiesViewBean.class);
        if (message != null) {
            vb.setPageSessionAttribute("missingInstanceMessage", (Serializable)((Object)message));
        }
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    protected Map getValues() throws ModelControlException, AMConsoleException {
        Map values = null;
        String instance = (String)this.getPageSessionAttribute(SERVICE_TYPE);
        AuthPropertiesModel model = this.getAuthModel();
        if (model != null) {
            AMPropertySheet ps = (AMPropertySheet)this.getChild("propertyAttributes");
            values = ps.getAttributeValues(model.getInstanceValues(instance), model);
        }
        return values;
    }

    private String getServiceName(String type) {
        AuthPropertiesModel m = this.getAuthModel();
        return m.getServiceName(type);
    }

    private AuthPropertiesModel getAuthModel() {
        if (this.authModel == null) {
            RequestContext rc = RequestManager.getRequestContext();
            this.authModel = new AuthPropertiesModelImpl(rc.getRequest(), this.getPageSessionAttributes());
        }
        return this.authModel;
    }

    protected String getBreadCrumbDisplayName() {
        String instance = (String)this.getPageSessionAttribute(SERVICE_TYPE);
        String[] arg = new String[]{instance};
        AuthPropertiesModel model = this.getAuthModel();
        return MessageFormat.format(model.getLocalizedString("breadcrumbs.auth.editInstance"), arg);
    }

    protected boolean startPageTrail() {
        return false;
    }

    protected AMModel getModelInternal() {
        HttpServletRequest req = RequestManager.getRequestContext().getRequest();
        try {
            return new AuthProfileModelImpl(req, this.serviceName, this.getPageSessionAttributes());
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
            return null;
        }
    }
}

