/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.secure;

import com.iplanet.am.util.JSSInit;
import com.sun.identity.log.secure.SecureLogHelper;
import com.sun.identity.log.spi.Debug;
import com.sun.identity.security.keystore.AMPassword;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BMPString;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkcs12.AuthenticatedSafes;
import org.mozilla.jss.pkcs12.PFX;
import org.mozilla.jss.pkcs12.SafeBag;
import org.mozilla.jss.pkix.primitive.Attribute;
import org.mozilla.jss.util.Password;

public class SecureLogHelperJSSImpl
extends SecureLogHelper {
    private static CryptoManager cryptoMgr = null;

    void initializeKeyStoreManager(AMPassword password) throws Exception {
        String method = "SecureLogHelperJSSImpl.initializeKeyStoreManager ";
        try {
            cryptoMgr = CryptoManager.getInstance();
        }
        catch (CryptoManager.NotInitializedException ex) {
            if (Debug.messageEnabled()) {
                Debug.message(method + "CryptoManager.NotInitializedException : ", ex);
            }
            JSSInit.initialize();
        }
    }

    public byte[] signMAC(byte[] mac) throws Exception {
        try {
            org.mozilla.jss.crypto.PrivateKey loggerPrivKey = null;
            X509Certificate cert = null;
            try {
                cert = cryptoMgr.findCertByNickname(loggerKey);
            }
            catch (Exception e) {
                Debug.error("SecureLogHelper.signMAC() :  Exception : ", e);
            }
            try {
                loggerPrivKey = cryptoMgr.findPrivKeyByCert(cert);
            }
            catch (Exception e) {
                Debug.error("SecureLogHelper.signMAC() :  Exception : ", e);
            }
            Signature loggerSign = Signature.getInstance(signingAlgorithm);
            loggerSign.initSign((PrivateKey)loggerPrivKey);
            loggerSign.update(mac);
            byte[] signedBytes = loggerSign.sign();
            this.writeToSecretStore(signedBytes, this.logFileName, this.loggerPass, "CurrentSignature");
            return signedBytes;
        }
        catch (Exception e) {
            Debug.error("SecureLogHelper.signMAC() :  Exception : ", e);
            throw new Exception(e.getMessage());
        }
    }

    public boolean verifySignature(byte[] signedObject, byte[] mac) throws Exception {
        try {
            PublicKey loggerPubKey = null;
            X509Certificate cert = cryptoMgr.findCertByNickname(loggerKey);
            loggerPubKey = cert.getPublicKey();
            Signature verifySign = Signature.getInstance(signingAlgorithm);
            verifySign.initVerify(loggerPubKey);
            verifySign.update(mac);
            return verifySign.verify(signedObject);
        }
        catch (Exception e) {
            Debug.error("SecureLogHelper.verifySignature() :  Exception : ", e);
            throw new Exception(e.getMessage());
        }
    }

    private byte[] createLocalKeyId(byte[] encodedBytes) throws Exception {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(encodedBytes);
            return md.digest();
        }
        catch (Exception e) {
            Debug.error("SecureLogHelper.createLocalKeyId() :  Exception : ", e);
            throw new Exception("Failed to create Key ID - " + e.toString());
        }
    }

    private SET createBagAttrs(String nickName, byte[] localKeyId) throws Exception {
        try {
            SET attrs = new SET();
            SEQUENCE nickNameAttr = new SEQUENCE();
            nickNameAttr.addElement((ASN1Value)SafeBag.FRIENDLY_NAME);
            SET nickNameSet = new SET();
            nickNameSet.addElement((ASN1Value)new BMPString(nickName));
            nickNameAttr.addElement((ASN1Value)nickNameSet);
            attrs.addElement((ASN1Value)nickNameAttr);
            SEQUENCE localKeyAttr = new SEQUENCE();
            localKeyAttr.addElement((ASN1Value)SafeBag.LOCAL_KEY_ID);
            SET localKeySet = new SET();
            localKeySet.addElement((ASN1Value)new OCTET_STRING(localKeyId));
            localKeyAttr.addElement((ASN1Value)localKeySet);
            attrs.addElement((ASN1Value)localKeyAttr);
            return attrs;
        }
        catch (Exception e) {
            Debug.error("SecureLogHelper.createBagAttrs() :  Exception : ", e);
            throw new Exception("Failed to create Key Bag - " + e.toString());
        }
    }

    byte[] readFromSecretStore(String filename, String dataType, AMPassword password) throws Exception {
        FileInputStream infile = null;
        infile = new FileInputStream(filename);
        PFX.Template pfxt = new PFX.Template();
        PFX pfx = (PFX)pfxt.decode((InputStream)new BufferedInputStream(infile, 2048));
        StringBuffer reason = new StringBuffer();
        MessageDigest md = MessageDigest.getInstance("SHA");
        Password jssPasswd = new Password(new String(md.digest(password.getByteCopy()), "UTF-8").toCharArray());
        md.reset();
        if (!pfx.verifyAuthSafes(jssPasswd, reason)) {
            throw new Exception("AuthSafes failed to verify because: " + reason.toString());
        }
        AuthenticatedSafes authSafes = pfx.getAuthSafes();
        SEQUENCE safeContentsSequence = authSafes.getSequence();
        byte[] cryptoData = null;
        for (int i = 0; i < safeContentsSequence.size(); ++i) {
            SEQUENCE safeContents = authSafes.getSafeContentsAt(jssPasswd, i);
            SafeBag safeBag = null;
            ASN1Value val = null;
            block1: for (int j = 0; j < safeContents.size(); ++j) {
                safeBag = (SafeBag)safeContents.elementAt(j);
                SET attribs = safeBag.getBagAttributes();
                if (attribs == null) {
                    Debug.error("Bag has no attributes");
                    continue;
                }
                for (int b = 0; b < attribs.size(); ++b) {
                    BMPString bs;
                    Attribute a = (Attribute)attribs.elementAt(b);
                    if (!a.getType().equals((Object)SafeBag.FRIENDLY_NAME) || !dataType.equals((bs = (BMPString)((ANY)a.getValues().elementAt(0)).decodeWith((ASN1Template)BMPString.getTemplate())).toString())) continue;
                    val = safeBag.getInterpretedBagContent();
                    continue block1;
                }
            }
            if (!(val instanceof ANY)) continue;
            cryptoData = ((ANY)val).getContents();
        }
        infile.close();
        return cryptoData;
    }

    void writeToSecretStore(byte[] cryptoMaterial, String filename, AMPassword password, String dataType) throws Exception {
        SEQUENCE initialKeySafeContents;
        byte[] key;
        byte[] oldDataFromSecretStorage = null;
        String oldDataType = null;
        MessageDigest md = MessageDigest.getInstance("SHA");
        Password jssPasswd = new Password(new String(md.digest(password.getByteCopy()), "UTF-8").toCharArray());
        md.reset();
        if (filename.equals(this.logFileName) && this.loggerInitialized) {
            if (dataType.equals("CurrentSignature")) {
                oldDataFromSecretStorage = this.readFromSecretStore(this.logFileName, "CurrentKey", password);
                oldDataType = "CurrentKey";
            } else if (dataType.equals("CurrentKey")) {
                oldDataFromSecretStorage = this.readFromSecretStore(this.logFileName, "CurrentSignature", password);
                oldDataType = "CurrentSignature";
            }
        }
        AuthenticatedSafes newAuthSafes = new AuthenticatedSafes();
        if (oldDataFromSecretStorage != null) {
            SEQUENCE oldSafeContents = this.AddToSecretStore(oldDataFromSecretStorage, oldDataType);
            newAuthSafes.addEncryptedSafeContents(PBEAlgorithm.PBE_SHA1_DES3_CBC, jssPasswd, null, 1, oldSafeContents);
        }
        if (filename.equals(this.logFileName) && !dataType.equals("InitialKey") && this.loggerInitialized && (key = this.readFromSecretStore(filename, "InitialKey", password)) != null) {
            initialKeySafeContents = this.AddToSecretStore(key, "InitialKey");
            newAuthSafes.addEncryptedSafeContents(PBEAlgorithm.PBE_SHA1_DES3_CBC, jssPasswd, null, 1, initialKeySafeContents);
        }
        if (filename.equals(this.verifierFileName) && !dataType.equals("InitialKey") && this.verifierInitialized && (key = this.readFromSecretStore(filename, "InitialKey", password)) != null) {
            initialKeySafeContents = this.AddToSecretStore(key, "InitialKey");
            newAuthSafes.addEncryptedSafeContents(PBEAlgorithm.PBE_SHA1_DES3_CBC, jssPasswd, null, 1, initialKeySafeContents);
        }
        SEQUENCE encSafeContents = this.AddToSecretStore(cryptoMaterial, dataType);
        newAuthSafes.addEncryptedSafeContents(PBEAlgorithm.PBE_SHA1_DES3_CBC, jssPasswd, null, 1, encSafeContents);
        PFX newpfx = new PFX(newAuthSafes);
        newpfx.computeMacData(jssPasswd, null, 5);
        FileOutputStream fos = new FileOutputStream(filename);
        newpfx.encode((OutputStream)fos);
        fos.close();
    }

    private SEQUENCE AddToSecretStore(byte[] cryptoMaterial, String DataType) throws Exception {
        SEQUENCE encSafeContents = new SEQUENCE();
        OCTET_STRING data = new OCTET_STRING(cryptoMaterial);
        byte[] localKeyId = this.createLocalKeyId(cryptoMaterial);
        SET keyAttrs = this.createBagAttrs(DataType, localKeyId);
        SafeBag keyBag = new SafeBag(SafeBag.SECRET_BAG, (ASN1Value)data, keyAttrs);
        encSafeContents.addElement((ASN1Value)keyBag);
        return encSafeContents;
    }
}

