/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.ums.validation.BooleanValidator;
import com.iplanet.ums.validation.DNValidator;
import com.iplanet.ums.validation.FloatValidator;
import com.iplanet.ums.validation.MailAddressValidator;
import com.iplanet.ums.validation.NumberValidator;
import com.iplanet.ums.validation.URLValidator;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.AttributeSchemaImpl;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ActionSchema
extends AttributeSchemaImpl {
    protected static final String ACTION_SCHEMA = "AttributeSchema";
    protected static final String ACTION_VALUE = "AttributeValue";
    protected static final String VALUE = "Value";
    protected static final String I18N_KEY = "i18nKey";
    protected static final String RESOURCE_NAME = "ResourceName";
    private Node actionNode = null;
    static final MailAddressValidator mailValidator = new MailAddressValidator();
    static final BooleanValidator boolValidator = new BooleanValidator();
    static final NumberValidator numberValidator = new NumberValidator();
    static final URLValidator urlValidator = new URLValidator();
    static final FloatValidator floatValidator = new FloatValidator();
    static final DNValidator dnValidator = new DNValidator();

    protected ActionSchema(Node node) {
        super(node);
        this.actionNode = node;
    }

    public Set getActionValues() {
        return this.getChoiceValuesSet();
    }

    public String getActionValueI18NKey(String actionValue) {
        return this.getChoiceValueI18NKey(actionValue);
    }

    public boolean requiresResourceName() {
        return this.isResourceNameAllowed();
    }

    public Set getResourceNames(String actionValue) {
        NodeList children = this.actionNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!node.getNodeName().equalsIgnoreCase(ACTION_VALUE)) continue;
            NodeList nl = node.getChildNodes();
            for (int j = 0; j < nl.getLength(); ++j) {
                String value;
                Node n = nl.item(j);
                if (!n.getNodeName().equalsIgnoreCase(VALUE) || !actionValue.equalsIgnoreCase((value = XMLUtils.getValueOfValueNode((Node)n)).toString())) continue;
                HashSet<String> answer = new HashSet<String>();
                NodeList rl = node.getChildNodes();
                for (int k = 0; k < rl.getLength(); ++k) {
                    Node r = rl.item(k);
                    if (!r.getNodeName().equalsIgnoreCase(RESOURCE_NAME)) continue;
                    answer.add(XMLUtils.getValueOfValueNode((Node)r));
                }
                return answer;
            }
        }
        return Collections.EMPTY_SET;
    }

    public String getResourceNameI18NKey(String actionValue) {
        NodeList children = this.actionNode.getChildNodes();
        int numNodes = children.getLength();
        for (int i = 0; i < numNodes; ++i) {
            Node node = children.item(i);
            if (!node.getNodeName().equalsIgnoreCase(ACTION_VALUE)) continue;
            NodeList nl = node.getChildNodes();
            int numOfNodeList = nl.getLength();
            for (int j = 0; j < numOfNodeList; ++j) {
                String value;
                Node n = nl.item(j);
                if (!n.getNodeName().equalsIgnoreCase(VALUE) || !actionValue.equalsIgnoreCase(value = XMLUtils.getValueOfValueNode((Node)n))) continue;
                NodeList rl = node.getChildNodes();
                int rlLength = rl.getLength();
                for (int k = 0; k < rlLength; ++k) {
                    String i18nKey;
                    Node r = rl.item(k);
                    if (!r.getNodeName().equalsIgnoreCase(RESOURCE_NAME) || (i18nKey = XMLUtils.getNodeAttributeValue((Node)r, (String)I18N_KEY)) == null) continue;
                    return i18nKey;
                }
            }
        }
        return null;
    }

    static void validate(ActionSchema as, Set values) throws InvalidNameException {
        if (!ActionSchema.validateType(as, values) || !ActionSchema.validateSyntax(as, values)) {
            PolicyManager.debug.error("In validate action name: invalid values");
            throw new InvalidNameException("amPolicy", "invalid_action_value", null, as.getName(), 1);
        }
    }

    static boolean validateType(ActionSchema as, Set values) {
        if (values == null || values.isEmpty()) {
            return true;
        }
        AttributeSchema.Type type = as.getType();
        boolean checkType = false;
        if (type.equals(AttributeSchema.Type.SINGLE) || type.equals(AttributeSchema.Type.SINGLE_CHOICE)) {
            checkType = true;
            if (values.size() > 1) {
                return false;
            }
        }
        if (type.equals(AttributeSchema.Type.SINGLE_CHOICE) || type.equals(AttributeSchema.Type.MULTIPLE_CHOICE)) {
            checkType = true;
            Set validValues = as.getActionValues();
            Iterator givenValues = values.iterator();
            while (givenValues.hasNext()) {
                if (validValues.contains(givenValues.next())) continue;
                return false;
            }
        }
        return checkType || type.equals(AttributeSchema.Type.LIST);
    }

    static boolean validateSyntax(ActionSchema as, Set values) {
        Iterator it;
        AttributeSchema.Syntax syntax = as.getSyntax();
        boolean answer = false;
        if (syntax.equals(AttributeSchema.Syntax.STRING) || syntax.equals(AttributeSchema.Syntax.PASSWORD)) {
            answer = true;
        }
        if (syntax.equals(AttributeSchema.Syntax.BOOLEAN) && values.size() == 1) {
            for (String test : values) {
                if (!as.getTrueValue().equals(test) && !as.getFalseValue().equals(test)) continue;
                answer = true;
            }
        }
        if (syntax.equals(AttributeSchema.Syntax.EMAIL)) {
            it = values.iterator();
            while (it.hasNext()) {
                answer = true;
                if (mailValidator.validate((String)it.next())) continue;
                answer = false;
                break;
            }
        }
        if (syntax.equals(AttributeSchema.Syntax.URL)) {
            it = values.iterator();
            while (it.hasNext()) {
                answer = true;
                if (urlValidator.validate((String)it.next())) continue;
                answer = false;
                break;
            }
        }
        if (syntax.equals(AttributeSchema.Syntax.NUMERIC) || syntax.equals(AttributeSchema.Syntax.NUMBER)) {
            it = values.iterator();
            while (it.hasNext()) {
                answer = true;
                if (numberValidator.validate((String)it.next())) continue;
                answer = false;
                break;
            }
        }
        if (syntax.equals(AttributeSchema.Syntax.PERCENT) || syntax.equals(AttributeSchema.Syntax.DECIMAL_NUMBER)) {
            it = values.iterator();
            while (it.hasNext()) {
                answer = true;
                if (floatValidator.validate((String)it.next())) continue;
                answer = false;
                break;
            }
        }
        if (syntax.equals(AttributeSchema.Syntax.NUMBER_RANGE)) {
            it = values.iterator();
            while (it.hasNext()) {
                answer = true;
                String s = (String)it.next();
                Integer i = Integer.valueOf(s);
                Integer start = Integer.valueOf(as.getStartRange());
                Integer end = Integer.valueOf(as.getEndRange());
                if (i == null || start == null || end == null) {
                    answer = false;
                    break;
                }
                if (i >= start && i <= end) continue;
                answer = false;
                break;
            }
        }
        if (syntax.equals(AttributeSchema.Syntax.DN)) {
            it = values.iterator();
            while (it.hasNext()) {
                answer = true;
                if (dnValidator.validate((String)it.next())) continue;
                answer = false;
                break;
            }
        }
        return answer;
    }
}

