/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.util.I18n;
import com.iplanet.ums.ConfigManagerException;
import com.iplanet.ums.ConfigManagerUMS;
import com.iplanet.ums.CreationTemplate;
import com.iplanet.ums.DataLayer;
import com.iplanet.ums.Guid;
import com.iplanet.ums.IUMSConstants;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SearchControl;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.UMSObject;
import com.sun.identity.shared.debug.Debug;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;

public class EntityManager
implements IUMSConstants {
    private static final String ENTITY_CHILDNODE = "childNode";
    private static final String ENTITY_FILTER = "filter";
    private static final String ENTITY_PRIORITY = "priority";
    private static final String ENTITY_TEMPLATE = "template";
    private static final String ENTITY_NAME = "name";
    private static final String NAME_TOKEN_DELIM = "=";
    private PersistentObject _pObject;
    private PersistentObject _parentObject;
    private Stack _stack;
    private TemplateManager _templateMgr;
    private Principal _principal;
    private ConfigManagerUMS _configManager;
    private static EntityManager _instance = null;
    private static I18n i18n = I18n.getInstance("amSDK");
    private static Debug debug = Debug.getInstance((String)"amSDK");

    public static synchronized EntityManager getEntityManager() throws UMSException {
        if (_instance == null) {
            _instance = new EntityManager();
        }
        return _instance;
    }

    public void execute(Principal principal, PersistentObject pObject, Guid pGUID) throws UMSException {
        HashMap<String, Guid> hm = null;
        Set set = null;
        Iterator<Object> iter = null;
        Attr attr = null;
        AttrSet attrSet = null;
        if (pObject == null) {
            String msg = i18n.getString("ums-badpersistentobject");
            throw new UMSException(msg);
        }
        this._principal = principal;
        this._pObject = pObject;
        this._stack = new Stack();
        String className = this._pObject.getClass().getName();
        this._parentObject = this._pObject;
        if (debug.messageEnabled()) {
            debug.message("GETTING ENTITY FOR:CLASS:" + className + ",PARENT:" + pGUID.getDn());
        }
        try {
            set = this._configManager.getEntity(pGUID, className);
            if (!set.isEmpty()) {
                if (set.size() > 1) {
                    attrSet = this.findEntity(this._pObject, set);
                } else {
                    Iterator it = set.iterator();
                    if (it.hasNext()) {
                        attrSet = (AttrSet)it.next();
                    }
                }
            } else {
                return;
            }
            if (attrSet == null) {
                Object[] args = new String[]{className};
                String msg = i18n.getString("ums-structuretemplateattrsetnull", args);
                throw new UMSException(msg);
            }
        }
        catch (ConfigManagerException cme) {
            Object[] args = new String[]{cme.getMessage()};
            String msg = i18n.getString("ums-configmanagererror", args);
            throw new UMSException(msg);
        }
        if (debug.messageEnabled()) {
            debug.message("ENTITY ATTRSET:" + attrSet);
        }
        if ((attr = attrSet.getAttribute(ENTITY_CHILDNODE)) == null) {
            return;
        }
        String[] attrValues = attr.getStringValues();
        for (int i = 0; i < attrValues.length; ++i) {
            hm = new HashMap<String, Guid>();
            hm.put(attrValues[i], this._parentObject.getGuid());
            this._stack.push(hm);
        }
        while (!this._stack.empty()) {
            hm = (HashMap<String, Guid>)this._stack.pop();
            set = hm.keySet();
            iter = set.iterator();
            String childNodeName = (String)iter.next();
            Guid parentGuid = (Guid)hm.get(childNodeName);
            try {
                Set childSet = this._configManager.getEntity(pGUID, childNodeName);
                if (!childSet.isEmpty() && (iter = childSet.iterator()).hasNext()) {
                    attrSet = (AttrSet)iter.next();
                }
                if (childSet.isEmpty() | attrSet == null) {
                    return;
                }
            }
            catch (ConfigManagerException cme) {
                Object[] args = new String[]{cme.getMessage()};
                String msg = i18n.getString("ums-configmanagererror", args);
                throw new UMSException(msg);
            }
            PersistentObject pObj = this.createObject(attrSet, parentGuid, pGUID);
            attr = attrSet.getAttribute(ENTITY_CHILDNODE);
            if (attr == null) continue;
            attrValues = attr.getStringValues();
            for (int j = 0; j < attrValues.length; ++j) {
                hm = new HashMap<String, Guid>();
                hm.put(attrValues[j], pObj.getGuid());
                this._stack.push(hm);
            }
        }
    }

    private AttrSet findEntity(PersistentObject pObject, Set set) throws UMSException {
        AttrSet foundAttrSet = null;
        AttrSet attrSet2 = null;
        try {
            for (AttrSet attrSet2 : set) {
                String filter = attrSet2.getAttribute(ENTITY_FILTER).getValue();
                SearchControl sc = new SearchControl();
                sc.setSearchScope(0);
                SearchResults sr = pObject.search(filter, sc);
                if (!sr.hasMoreElements()) continue;
                sr.abandon();
                if (foundAttrSet != null && Integer.parseInt(attrSet2.getAttribute(ENTITY_PRIORITY).getValue()) >= Integer.parseInt(foundAttrSet.getAttribute(ENTITY_PRIORITY).getValue())) continue;
                foundAttrSet = attrSet2;
            }
        }
        catch (NumberFormatException nfe) {
            Object[] args = new String[]{"" + attrSet2, "" + foundAttrSet, nfe.getMessage()};
            String msg = i18n.getString("ums-badstructuretemplatepriority", args);
            throw new UMSException(msg);
        }
        return foundAttrSet;
    }

    private PersistentObject createObject(AttrSet attrSet, Guid parentGuid, Guid searchGuid) throws UMSException {
        DataLayer dataLayer = DataLayer.getInstance();
        Attr tempAttr = attrSet.getAttribute(ENTITY_TEMPLATE);
        Attr attrAttr = attrSet.getAttribute(ENTITY_NAME);
        if (attrAttr == null) {
            String msg = i18n.getString("ums-badnamingattr");
            throw new UMSException(msg);
        }
        String[] attrValues = attrAttr.getStringValues();
        attrSet = new AttrSet();
        for (int k = 0; k < attrValues.length; ++k) {
            String attrName = null;
            String attrValue = null;
            int index = attrValues[k].indexOf(NAME_TOKEN_DELIM);
            if (index < 0) {
                String msg = i18n.getString("ums-badnamingattr");
                throw new UMSException(msg);
            }
            attrName = attrValues[k].substring(0, index);
            attrValue = attrValues[k].substring(index + 1, attrValues[k].length());
            attrSet.add(new Attr(attrName, attrValue));
        }
        String templateName = tempAttr.getValue();
        CreationTemplate ct = this._templateMgr.getCreationTemplate(templateName, searchGuid);
        PersistentObject pObj = new PersistentObject(ct, attrSet);
        String idAttr = pObj.getNamingAttribute();
        String idValue = pObj.getAttribute(idAttr).getValue();
        Guid childGuid = new Guid(idAttr + NAME_TOKEN_DELIM + idValue + "," + parentGuid.getDn());
        String[] attrNames = pObj.getAttributeNames();
        AttrSet atts = pObj.getAttributes(attrNames);
        try {
            dataLayer.addEntry(this._principal, childGuid, atts);
        }
        catch (UMSException umse) {
            throw new UMSException(umse.getMessage());
        }
        UMSObject.getObject(this._principal, childGuid);
        return pObj;
    }

    private EntityManager() throws UMSException {
        try {
            this._configManager = ConfigManagerUMS.getConfigManager();
            this._templateMgr = TemplateManager.getTemplateManager();
        }
        catch (ConfigManagerException cme) {
            throw new UMSException(cme.getMessage());
        }
    }
}

