/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.workflow;

import com.sun.identity.cot.COTException;
import com.sun.identity.cot.CircleOfTrustManager;
import com.sun.identity.saml2.jaxb.entityconfig.EntityConfigElement;
import com.sun.identity.saml2.jaxb.entityconfig.IDPSSOConfigElement;
import com.sun.identity.saml2.jaxb.entityconfig.SPSSOConfigElement;
import com.sun.identity.saml2.jaxb.metadata.EntityDescriptorElement;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.workflow.Task;
import com.sun.identity.workflow.WorkflowException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class GetIDPSPPairingInCOT
extends Task {
    public String execute(Locale locale, Map params) throws WorkflowException {
        String realm = this.getString(params, "realm");
        String cotName = this.getString(params, "cot");
        List hostedIDP = this.getHostedIDP(realm, cotName);
        List hostedIDPMetaAlias = Collections.EMPTY_LIST;
        List remoteSP = this.getRemoteSP(realm, cotName);
        if (hostedIDP.isEmpty() || remoteSP.isEmpty()) {
            remoteSP = Collections.EMPTY_LIST;
        } else {
            hostedIDPMetaAlias = this.getHostedIDPMetaAlias(realm, hostedIDP);
        }
        List remoteIDP = this.getRemoteIDP(realm, cotName);
        List hostedSP = this.getHostedSP(realm, cotName);
        List hostedSPMetaAlias = Collections.EMPTY_LIST;
        if (remoteIDP.isEmpty() || hostedSP.isEmpty()) {
            remoteIDP = Collections.EMPTY_LIST;
        } else {
            hostedSPMetaAlias = this.getHostedSPMetaAlias(realm, hostedSP);
        }
        StringBuffer buff = new StringBuffer();
        buff.append(this.getArrayString("hostedidp", hostedIDPMetaAlias));
        buff.append(this.getArrayString("remoteidp", remoteIDP));
        buff.append(this.getArrayString("hostedsp", hostedSPMetaAlias));
        buff.append(this.getArrayString("remotesp", remoteSP));
        return buff.toString();
    }

    private List getHostedIDPMetaAlias(String realm, List hostedIDP) throws WorkflowException {
        try {
            ArrayList<String> list = new ArrayList<String>();
            SAML2MetaManager mgr = new SAML2MetaManager();
            for (String e : hostedIDP) {
                IDPSSOConfigElement cfg = mgr.getIDPSSOConfig(realm, e);
                list.add(e + "(" + cfg.getMetaAlias() + ")");
            }
            return list;
        }
        catch (SAML2MetaException ex) {
            throw new WorkflowException(ex.getMessage());
        }
    }

    private List getHostedSPMetaAlias(String realm, List hostedSP) throws WorkflowException {
        try {
            ArrayList<String> list = new ArrayList<String>();
            SAML2MetaManager mgr = new SAML2MetaManager();
            for (String e : hostedSP) {
                SPSSOConfigElement cfg = mgr.getSPSSOConfig(realm, e);
                list.add(e + "(" + cfg.getMetaAlias() + ")");
            }
            return list;
        }
        catch (SAML2MetaException ex) {
            throw new WorkflowException(ex.getMessage());
        }
    }

    private String getArrayString(String arrayName, List list) {
        StringBuffer buff = new StringBuffer();
        buff.append("{").append(arrayName).append("=");
        boolean first = true;
        for (String e : list) {
            if (!first) {
                buff.append(",");
            } else {
                first = false;
            }
            try {
                buff.append(URLEncoder.encode(e, "UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                buff.append(e);
            }
        }
        buff.append("}");
        return buff.toString();
    }

    private List getHostedIDP(String realm, String cotName) throws WorkflowException {
        return this.getEntities(realm, cotName, true, true);
    }

    private List getRemoteIDP(String realm, String cotName) throws WorkflowException {
        return this.getEntities(realm, cotName, true, false);
    }

    private List getHostedSP(String realm, String cotName) throws WorkflowException {
        return this.getEntities(realm, cotName, false, true);
    }

    private List getRemoteSP(String realm, String cotName) throws WorkflowException {
        return this.getEntities(realm, cotName, false, false);
    }

    private List getEntities(String realm, String cotName, boolean bIDP, boolean hosted) throws WorkflowException {
        try {
            SAML2MetaManager mgr = new SAML2MetaManager();
            Set entities = this.getEntities(realm, cotName);
            ArrayList<String> results = new ArrayList<String>();
            for (String entityId : entities) {
                EntityConfigElement elm = mgr.getEntityConfig(realm, entityId);
                if (elm.isHosted() != hosted) continue;
                EntityDescriptorElement desc = mgr.getEntityDescriptor(realm, entityId);
                if (bIDP) {
                    if (SAML2MetaUtils.getIDPSSODescriptor((EntityDescriptorElement)desc) == null) continue;
                    results.add(entityId);
                    continue;
                }
                if (SAML2MetaUtils.getSPSSODescriptor((EntityDescriptorElement)desc) == null) continue;
                results.add(entityId);
            }
            return results;
        }
        catch (SAML2MetaException ex) {
            throw new WorkflowException(ex.getMessage());
        }
    }

    private Set getEntities(String realm, String cotName) throws WorkflowException {
        try {
            CircleOfTrustManager mgr = new CircleOfTrustManager();
            return mgr.listCircleOfTrustMember(realm, cotName, "saml2");
        }
        catch (COTException ex) {
            throw new WorkflowException(ex.getMessage());
        }
    }
}

