/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.jdbc;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.jdbc.JDBCConnectionPool;
import com.iplanet.dpro.session.service.AMSessionRepository;
import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.dpro.session.service.SessionService;
import com.sun.identity.common.GeneralTaskRunnable;
import com.sun.identity.common.SystemTimer;
import com.sun.identity.common.TaskRunnable;
import com.sun.identity.session.util.SessionUtils;
import com.sun.identity.shared.debug.Debug;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;

public class JDBCSessionRepository
extends GeneralTaskRunnable
implements AMSessionRepository {
    private static DataSource dataSource = null;
    private static final String table = "sunwam_session";
    private static final String table_ext = "sunwam_session_ext";
    private static final String INSERT_SQL_STMT = "insert into sunwam_session(id,blob_chunk,blob_size,expiration_time,uuid,sessionstate,version) values(?,?,?,?,?,?,?)";
    private static final String UPDATE_SQL_STMT = "update sunwam_session set blob_chunk = ?, blob_size = ? , expiration_time = ? , uuid = ?, sessionstate = ?, version = ?  where id = ? and version = ?";
    private static final String GET_SESSION_COUNT_SQL_STMT = "select * from sunwam_session where uuid = ? and expiration_time > ? and sessionstate = 1";
    private static final String connectionPoolName = SystemProperties.get("com.sun.identity.session.failover.connectionPoolClass", "com.iplanet.dpro.session.jdbc.JDBCConnectionPool");
    private static int BLOB_CHUNK_SIZE = 7800;
    private static boolean isDatabaseUp = true;
    private static long gracePeriod = 300L;
    private static final String CLEANUP_GRACE_PERIOD = "com.sun.identity.session.repository.cleanupGracePeriod";
    private static final String BRIEF_DB_ERROR_MSG = "Session failover service is not functional due to DB unavailability.";
    private static final String DB_ERROR_MSG = "Session database is not available at this moment.Please check with the system administrator for appropriate actions";
    private static long cleanUpPeriod = 60000L;
    private static long cleanUpValue = 0L;
    public static final String CLEANUP_RUN_PERIOD = "com.sun.identity.session.repository.cleanupRunPeriod";
    private static long healthCheckPeriod = 60000L;
    public static final String HEALTH_CHECK_RUN_PERIOD = "com.sun.identity.session.repository.healthCheckRunPeriod";
    private static long runPeriod = 60000L;
    static Debug debug = SessionService.sessionDebug;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection() throws Exception {
        if (dataSource == null) {
            dataSource = (DataSource)Class.forName(connectionPoolName).newInstance();
        }
        Connection conn = null;
        try {
            if (!isDatabaseUp) {
                JDBCSessionRepository jDBCSessionRepository = this;
                synchronized (jDBCSessionRepository) {
                    if (!isDatabaseUp) {
                        ((JDBCConnectionPool)dataSource).reinitializePoolDataSource();
                        isDatabaseUp = true;
                    }
                }
            }
            conn = dataSource.getConnection();
        }
        catch (Exception e) {
            isDatabaseUp = false;
            debug.error(BRIEF_DB_ERROR_MSG, (Throwable)e);
            if (debug.messageEnabled()) {
                debug.message(DB_ERROR_MSG, (Throwable)e);
            }
            throw e;
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDBCSessionRepository() throws Exception {
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            rs = conn.getMetaData().getTables(null, null, table, new String[]{"TABLE"});
            boolean tableExists = rs.next();
            rs.close();
            rs = null;
            if (!tableExists) {
                debug.message("DataBase table does not exist");
            }
        }
        catch (Exception ex) {
            debug.error("JDBCSessionRepository Initialization failed.");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {}
        }
        SystemTimer.getTimer().schedule((TaskRunnable)this, new Date(System.currentTimeMillis() / 1000L * 1000L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalSession retrieve(SessionID sid) throws Exception {
        InternalSession internalSession;
        if (!isDatabaseUp) {
            return null;
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement("select * from sunwam_session where id = ?");
            stmt.setString(1, SessionUtils.getEncryptedStorageKey(sid));
            rs = stmt.executeQuery();
            if (!rs.next()) {
                InternalSession internalSession2 = null;
                return internalSession2;
            }
            byte[] chunk = rs.getBytes("blob_chunk");
            int blobSize = rs.getInt("blob_size");
            long version = rs.getLong("version");
            byte[] blob = chunk;
            if (blobSize != 0 && blobSize > chunk.length) {
                blob = new byte[blobSize];
                System.arraycopy(chunk, 0, blob, 0, chunk.length);
                this.retrieveBlobRemainder(conn, sid, blob);
            }
            InternalSession is = (InternalSession)SessionUtils.decode(blob);
            is.setVersion(version);
            conn.commit();
            internalSession = is;
        }
        catch (Exception ex) {
            try {
                conn.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            InternalSession internalSession3 = null;
            return internalSession3;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {}
        }
        return internalSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(InternalSession is) throws Exception {
        if (!isDatabaseUp) {
            return;
        }
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            InternalSession internalSession = is;
            synchronized (internalSession) {
                SessionID sid = is.getID();
                byte[] blob = SessionUtils.encode(is);
                long version = is.getVersion();
                long expirationTime = is.getExpirationTime() + gracePeriod;
                byte[] firstChunk = blob;
                if (blob.length > BLOB_CHUNK_SIZE) {
                    firstChunk = new byte[BLOB_CHUNK_SIZE];
                    System.arraycopy(blob, 0, firstChunk, 0, firstChunk.length);
                }
                String encryptedStorageKey = SessionUtils.getEncryptedStorageKey(sid);
                String uuid = is.getUUID();
                int sessionState = is.getState();
                if (version == 0L) {
                    this.insertNewSessionEntry(conn, encryptedStorageKey, firstChunk, blob.length, expirationTime, uuid, sessionState, version);
                } else {
                    stmt = conn.prepareStatement(UPDATE_SQL_STMT);
                    stmt.setBytes(1, firstChunk);
                    stmt.setInt(2, blob.length);
                    stmt.setLong(3, expirationTime);
                    stmt.setString(4, uuid);
                    stmt.setInt(5, sessionState);
                    stmt.setLong(6, version + 1L);
                    stmt.setString(7, encryptedStorageKey);
                    stmt.setLong(8, version);
                    int count = stmt.executeUpdate();
                    if (count == 0) {
                        this.insertNewSessionEntry(conn, encryptedStorageKey, firstChunk, blob.length, expirationTime, uuid, sessionState, version);
                    }
                }
                this.saveBlobRemainder(conn, sid, blob, expirationTime);
                conn.commit();
                is.setVersion(version + 1L);
            }
        }
        catch (Exception ex) {
            debug.error("Exception thrown when saving the session into the JDBC repository.", (Throwable)ex);
            try {
                conn.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertNewSessionEntry(Connection conn, String encryptedStorageKey, byte[] firstChunk, int blobLen, long expirationTime, String uuid, int sessionState, long version) throws Exception {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(INSERT_SQL_STMT);
            stmt.setString(1, encryptedStorageKey);
            stmt.setBytes(2, firstChunk);
            stmt.setInt(3, blobLen);
            stmt.setLong(4, expirationTime);
            stmt.setString(5, uuid);
            stmt.setInt(6, sessionState);
            stmt.setLong(7, version + 1L);
            stmt.executeUpdate();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(SessionID sid) throws Exception {
        if (!isDatabaseUp) {
            return;
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement("delete from sunwam_session where id = ?");
            stmt.setString(1, SessionUtils.getEncryptedStorageKey(sid));
            stmt.executeUpdate();
            stmt.close();
            stmt = null;
            stmt = conn.prepareStatement("delete from sunwam_session_ext where id = ?");
            stmt.setString(1, SessionUtils.getEncryptedStorageKey(sid));
            stmt.executeUpdate();
            conn.commit();
        }
        catch (Exception ex) {
            debug.error("Exception thrown when deleting the session from the JDBC repository.", (Throwable)ex);
            try {
                conn.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteExpired() throws Exception {
        if (!isDatabaseUp) {
            return;
        }
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.getConnection();
            long now = System.currentTimeMillis() / 1000L;
            stmt = conn.prepareStatement("delete from sunwam_session where expiration_time < ?");
            stmt.setLong(1, now);
            stmt.executeUpdate();
            stmt.close();
            stmt = null;
            stmt = conn.prepareStatement("delete from sunwam_session_ext where expiration_time < ?");
            stmt.setLong(1, now);
            stmt.executeUpdate();
            conn.commit();
        }
        catch (Exception ex) {
            debug.error("Exception thrown when cleanning up the session from the JDBC repository.", (Throwable)ex);
            try {
                conn.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveBlobRemainder(Connection conn, SessionID sid, byte[] blob, long expirationTime) throws Exception {
        Statement stmt = null;
        try {
            int remaining;
            int chunkNumber = 1;
            stmt = conn.prepareStatement("delete from sunwam_session_ext where id = ?");
            stmt.setString(1, SessionUtils.getEncryptedStorageKey(sid));
            stmt.executeUpdate();
            stmt.close();
            stmt = null;
            if (remaining > 0) {
                byte[] chunk = new byte[BLOB_CHUNK_SIZE];
                stmt = conn.prepareStatement("insert into sunwam_session_ext(id,blob_chunk,blob_chunk_seq,expiration_time)  values(?,?,?,?)");
                for (remaining = blob.length - BLOB_CHUNK_SIZE; remaining > 0; remaining -= BLOB_CHUNK_SIZE) {
                    int len = Math.min(remaining, BLOB_CHUNK_SIZE);
                    System.arraycopy(blob, chunkNumber * BLOB_CHUNK_SIZE, chunk, 0, len);
                    stmt.setString(1, SessionUtils.getEncryptedStorageKey(sid));
                    stmt.setBytes(2, chunk);
                    stmt.setInt(3, chunkNumber);
                    stmt.setLong(4, expirationTime);
                    stmt.executeUpdate();
                    ++chunkNumber;
                }
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
        }
    }

    void retrieveBlobRemainder(Connection conn, SessionID sid, byte[] blob) throws Exception {
        String storageKey = SessionUtils.getEncryptedStorageKey(sid);
        this.retrieveBlobRemainder(conn, storageKey, blob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retrieveBlobRemainder(Connection conn, String sKey, byte[] blob) throws Exception {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            int remaining = blob.length - BLOB_CHUNK_SIZE;
            if (remaining <= 0) {
                return;
            }
            stmt = conn.prepareStatement("select blob_chunk, blob_chunk_seq from sunwam_session_ext where id = ?");
            stmt.setString(1, sKey);
            rs = stmt.executeQuery();
            while (rs.next()) {
                byte[] chunk = rs.getBytes("blob_chunk");
                int chunkSeq = rs.getInt("blob_chunk_seq");
                if (chunk.length == 0 || chunk.length > BLOB_CHUNK_SIZE || chunkSeq < 1 || chunkSeq * BLOB_CHUNK_SIZE > blob.length) {
                    throw new IllegalArgumentException("Invalid chunk");
                }
                int len = Math.min(chunk.length, blob.length - chunkSeq * BLOB_CHUNK_SIZE);
                System.arraycopy(chunk, 0, blob, chunkSeq * BLOB_CHUNK_SIZE, len);
                remaining -= len;
            }
            if (remaining != 0) {
                throw new IllegalArgumentException("Missing chunks");
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public Map getSessionsByUUID(String uuid) throws Exception {
        if (!isDatabaseUp) {
            throw new SessionException("Session repository is not available.");
        }
        HashMap<String, Long> sessions = new HashMap<String, Long>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(GET_SESSION_COUNT_SQL_STMT);
            stmt.setString(1, uuid);
            long now = System.currentTimeMillis() / 1000L;
            stmt.setLong(2, now);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String sKey = rs.getString("id");
                byte[] chunk = rs.getBytes("blob_chunk");
                int blobSize = rs.getInt("blob_size");
                byte[] blob = chunk;
                if (blobSize != 0 && blobSize > chunk.length) {
                    blob = new byte[blobSize];
                    System.arraycopy(chunk, 0, blob, 0, chunk.length);
                    this.retrieveBlobRemainder(conn, sKey, blob);
                }
                InternalSession is = (InternalSession)SessionUtils.decode(blob);
                String sid = is.getID().toString();
                Long expirationTime = new Long(is.getExpirationTime());
                sessions.put(sid, expirationTime);
            }
            conn.commit();
        }
        catch (Exception ex) {
            try {
                conn.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw new SessionException("Error occurs when executing the GET_SESSION_COUNT query");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {}
        }
        return sessions;
    }

    public long getRunPeriod() {
        return runPeriod;
    }

    public boolean addElement(Object obj) {
        return false;
    }

    public boolean removeElement(Object obj) {
        return false;
    }

    public boolean isEmpty() {
        return true;
    }

    public void run() {
        try {
            if (debug.messageEnabled()) {
                debug.message("Cleaning expired session records");
            }
            if (cleanUpValue <= 0L) {
                this.deleteExpired();
                cleanUpValue = cleanUpPeriod;
            }
            cleanUpValue -= runPeriod;
            if (!isDatabaseUp) {
                this.checkDatabaseAvailability();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDatabaseAvailability() {
        Connection conn = null;
        try {
            conn = this.getConnection();
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {}
        }
    }

    static {
        try {
            gracePeriod = Integer.parseInt(SystemProperties.get(CLEANUP_GRACE_PERIOD, String.valueOf(gracePeriod)));
        }
        catch (Exception e) {
            debug.error("Invalid value for com.sun.identity.session.repository.cleanupGracePeriod, using default");
        }
        try {
            cleanUpPeriod = Integer.parseInt(SystemProperties.get(CLEANUP_RUN_PERIOD, String.valueOf(cleanUpPeriod)));
        }
        catch (Exception e) {
            debug.error("Invalid value for com.sun.identity.session.repository.cleanupRunPeriod, using default");
        }
        try {
            healthCheckPeriod = Integer.parseInt(SystemProperties.get(HEALTH_CHECK_RUN_PERIOD, String.valueOf(healthCheckPeriod)));
        }
        catch (Exception e) {
            debug.error("Invalid value for com.sun.identity.session.repository.healthCheckRunPeriod, using default");
        }
        runPeriod = cleanUpPeriod <= healthCheckPeriod ? cleanUpPeriod : healthCheckPeriod;
        cleanUpValue = cleanUpPeriod;
    }
}

