/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.server;

import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.server.AuthContextLocal;
import com.sun.identity.authentication.server.AuthXMLRequestParser;
import com.sun.identity.authentication.service.AuthException;
import com.sun.identity.shared.debug.Debug;
import java.security.Principal;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.servlet.http.HttpServletRequest;

public class AuthXMLRequest {
    public static final int NewAuthContext = 0;
    public static final int Login = 1;
    public static final int SubmitRequirements = 2;
    public static final int QueryInformation = 3;
    public static final int Logout = 4;
    public static final int Abort = 5;
    public static final int LoginIndex = 6;
    public static final int LoginPrincipal = 7;
    public static final int LoginSubject = 8;
    private int requestType;
    private String version = null;
    private String authIdentifier = null;
    private String appSSOTokenID = null;
    private String orgName = null;
    private String hostName = null;
    private String forceAuth = null;
    private boolean validSessionNoUpgrade = false;
    private String requestedInformation = null;
    private boolean isPCookie = false;
    private AuthContext.IndexType indexType = null;
    private String indexName = null;
    private String locale = null;
    private Principal principal;
    private char[] password;
    private Callback[] submittedCallbacks;
    private Subject subject;
    private String params = null;
    private List env = null;
    AuthContextLocal authContext = null;
    HttpServletRequest servletRequest = null;
    static Debug debug = Debug.getInstance((String)"amXMLHandler");

    public static AuthXMLRequest parseXML(String xml, HttpServletRequest req) throws AuthException {
        debug.message("Calling AuthXMLRequestParser");
        AuthXMLRequestParser authParser = new AuthXMLRequestParser(xml, req);
        debug.message("After AuthXMLRequestParser");
        return authParser.parseXML();
    }

    public void setRequestType(int i) {
        this.requestType = i;
    }

    public void setRequestVersion(String version) {
        this.version = version;
    }

    public void setAuthIdentifier(String authIdentifier) {
        this.authIdentifier = authIdentifier;
    }

    public void setAppSSOTokenID(String appSSOTokenID) {
        this.appSSOTokenID = appSSOTokenID;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setForceAuth(String aForceAuth) {
        this.forceAuth = aForceAuth;
    }

    public void setValidSessionNoUpgrade(boolean aValidSessionNoUpgrade) {
        this.validSessionNoUpgrade = aValidSessionNoUpgrade;
    }

    public void setRequestInformation(String requestInfo) {
        this.requestedInformation = requestInfo;
    }

    public void setIndexType(String strIndexType) {
        if (strIndexType.equalsIgnoreCase("service")) {
            this.indexType = AuthContext.IndexType.SERVICE;
        } else if (strIndexType.equalsIgnoreCase("authLevel")) {
            this.indexType = AuthContext.IndexType.LEVEL;
        } else if (strIndexType.equalsIgnoreCase("role")) {
            this.indexType = AuthContext.IndexType.ROLE;
        } else if (strIndexType.equalsIgnoreCase("moduleInstance")) {
            this.indexType = AuthContext.IndexType.MODULE_INSTANCE;
        } else if (strIndexType.equalsIgnoreCase("user")) {
            this.indexType = AuthContext.IndexType.USER;
        } else if (strIndexType.equalsIgnoreCase("compositeAdvice")) {
            this.indexType = AuthContext.IndexType.COMPOSITE_ADVICE;
        } else if (strIndexType.equalsIgnoreCase("resource")) {
            this.indexType = AuthContext.IndexType.RESOURCE;
        }
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public void setPrincipal(String className, String principalValue) {
        try {
            Class<?> clName = Class.forName(className);
            this.principal = (Principal)clName.newInstance();
        }
        catch (ClassNotFoundException ce) {
        }
        catch (IllegalAccessException ia) {
        }
        catch (InstantiationException ie) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setPassword(String password) {
        this.password = password.toCharArray();
    }

    public void setSubmittedCallbacks(Callback[] submittedCallbacks) {
        this.submittedCallbacks = submittedCallbacks;
    }

    public int getRequestType() {
        return this.requestType;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getForceAuth() {
        return this.forceAuth;
    }

    public boolean getValidSessionNoUpgrade() {
        return this.validSessionNoUpgrade;
    }

    public String getAuthIdentifier() {
        return this.authIdentifier;
    }

    public String getAppSSOTokenID() {
        return this.appSSOTokenID;
    }

    public Callback[] getSubmittedCallbacks() {
        return this.submittedCallbacks;
    }

    public AuthContext.IndexType getIndexType() {
        return this.indexType;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public char[] getPassword() {
        return this.password;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public void setAuthContext(AuthContextLocal authContext) {
        this.authContext = authContext;
    }

    public AuthContextLocal getAuthContext() {
        return this.authContext;
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    public void setHttpServletRequest(HttpServletRequest servletRequest) {
        this.servletRequest = servletRequest;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.servletRequest;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public String getParams() {
        return this.params;
    }

    public void setEnvironment(List env) {
        this.env = env;
    }

    public List getEnvironment() {
        return this.env;
    }
}

