/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.authentication;

import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.config.AMAuthenticationInstance;
import com.sun.identity.authentication.config.AMAuthenticationManager;
import com.sun.identity.authentication.config.AMConfigurationException;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.log.Level;
import java.text.MessageFormat;
import java.util.Set;

public class ListAuthInstances
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String realm = this.getStringOptionValue("realm");
        String[] params = new String[]{realm};
        this.writeLog(0, Level.INFO, "ATTEMPT_LIST_AUTH_INSTANCES", params);
        try {
            AMAuthenticationManager mgr = new AMAuthenticationManager(adminSSOToken, realm);
            Set instances = mgr.getAuthenticationInstances();
            if (instances != null && !instances.isEmpty()) {
                this.getOutputWriter().printlnMessage(this.getResourceString("authentication-list-auth-instance"));
                for (AMAuthenticationInstance instance : instances) {
                    Object[] args = new Object[]{instance.getName(), instance.getType()};
                    this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("authentication-list-auth-instance-entry"), args));
                }
            } else {
                this.getOutputWriter().printlnMessage(this.getResourceString("authentication-list-auth-instance-empty"));
            }
            this.writeLog(0, Level.INFO, "SUCCEEDED_LIST_AUTH_INSTANCES", params);
        }
        catch (AMConfigurationException e) {
            this.debugError("ListAuthInstances.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_LIST_AUTH_INSTANCES", params);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

