/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.user.model;

import com.iplanet.sso.SSOException;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.console.user.model.UMChangeUserPasswordModel;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMChangeUserPasswordModelImpl
extends AMModelBase
implements UMChangeUserPasswordModel {
    public UMChangeUserPasswordModelImpl(HttpServletRequest req, Map map) {
        super(req, map);
    }

    public String getUserName(String userId) {
        String userName = "";
        try {
            AMIdentity amid = IdUtils.getIdentity(this.getUserSSOToken(), userId);
            userName = amid.getName();
        }
        catch (IdRepoException e) {
            debug.warning("UMChangeUserPasswordModelImpl.getUserName", (Throwable)e);
        }
        return userName;
    }

    public String getPassword(String userId) throws AMConsoleException {
        String password = "";
        String[] params = new String[]{userId, "userpassword"};
        try {
            this.logEvent("ATTEMPT_READ_IDENTITY_ATTRIBUTE_VALUE", params);
            AMIdentity amid = IdUtils.getIdentity(this.getUserSSOToken(), userId);
            Set set = amid.getAttribute("userpassword");
            if (set != null && !set.isEmpty()) {
                password = (String)set.iterator().next();
            }
            this.logEvent("SUCCEED_READ_IDENTITY_ATTRIBUTE_VALUE", params);
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{userId, "userpassword", strError};
            this.logEvent("SSO_EXCEPTION_READ_IDENTITY_ATTRIBUTE_VALUE", paramsEx);
            throw new AMConsoleException(strError);
        }
        catch (IdRepoException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{userId, "userpassword", strError};
            this.logEvent("IDM_EXCEPTION_READ_IDENTITY_ATTRIBUTE_VALUE", paramsEx);
            throw new AMConsoleException(strError);
        }
        return password;
    }

    public void changePassword(String userId, String password) throws AMConsoleException {
        String[] params = new String[]{userId, "userpassword"};
        try {
            this.logEvent("ATTEMPT_MODIFY_IDENTITY_ATTRIBUTE_VALUE", params);
            AMIdentity amid = IdUtils.getIdentity(this.getUserSSOToken(), userId);
            HashMap map = new HashMap(2);
            HashSet<String> set = new HashSet<String>(2);
            set.add(password);
            map.put("userpassword", set);
            amid.setAttributes(map);
            amid.store();
            this.logEvent("SUCCEED_MODIFY_IDENTITY_ATTRIBUTE_VALUE", params);
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{userId, "userpassword", strError};
            this.logEvent("SSO_EXCEPTION_MODIFY_IDENTITY_ATTRIBUTE_VALUE", paramsEx);
            throw new AMConsoleException(strError);
        }
        catch (IdRepoException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{userId, "userpassword", strError};
            this.logEvent("IDM_EXCEPTION_MODIFY_IDENTITY_ATTRIBUTE_VALUE", paramsEx);
            throw new AMConsoleException(strError);
        }
    }
}

