/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tune.config;

import com.sun.identity.tune.base.WebContainerConfigInfoBase;
import com.sun.identity.tune.common.AMTuneException;
import com.sun.identity.tune.common.AMTuneLogger;
import com.sun.identity.tune.common.FileHandler;
import com.sun.identity.tune.common.MessageWriter;
import com.sun.identity.tune.config.AS9ContainerConfigInfo;
import com.sun.identity.tune.config.DSConfigInfo;
import com.sun.identity.tune.config.WS7ContainerConfigInfo;
import com.sun.identity.tune.constants.AMTuneConstants;
import com.sun.identity.tune.constants.DSConstants;
import com.sun.identity.tune.constants.FAMConstants;
import com.sun.identity.tune.constants.WebContainerConstants;
import com.sun.identity.tune.util.AMTuneUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;

public class AMTuneConfigInfo
implements AMTuneConstants,
DSConstants,
FAMConstants,
WebContainerConstants {
    private String confFileName;
    private AMTuneLogger pLogger;
    private MessageWriter mWriter;
    private boolean isReviewMode;
    private String logType;
    private boolean tuneOS;
    private boolean tuneWebContainer;
    private boolean tuneDS;
    private boolean tuneFAM;
    private boolean isJVM64BitAvailable;
    private String webContainer;
    private String famAdmLocation;
    private String famConfigDir;
    private String famServerUrl;
    private String famAdmUser;
    private String defaultOrgPeopleContainer;
    private int famTunePctMemoryToUse;
    private int famTunePerThreadStackSizeInKB;
    private int famTunePerThreadStackSizeInKB64Bit;
    private boolean famTuneDontTouchSessionParameters;
    private int famTuneSessionMaxSessionTimeInMts;
    private int famTuneSessionMaxIdleTimeInMts;
    private int famTuneSessionMaxCachingTimeInMts;
    private double famTuneMemMaxHeapSizeRatio;
    private double famTuneMemMinHeapSizeRatio;
    private int famTuneMinMemoryToUseInMB;
    private int famTuneMaxMemoryToUseInMB;
    private int famTuneMaxMemoryToUseInMBDefault;
    private String famTuneMemMaxHeapSizeRatioExp;
    private String famAdminPassword;
    private List realms;
    private int acceptorThreads;
    private int numNotificationQueue;
    private int numNotificationThreads;
    private int numSMLdapThreads;
    private int numLdapAuthThreads;
    private int numRQThrottle;
    private int numOfMaxThreadPool;
    private int numCpus;
    private int memAvail;
    private int memToUse;
    private int maxHeapSize;
    private int minHeapSize;
    private int maxNewSize;
    private int maxPermSize;
    private int cacheSize;
    private int sdkCacheSize;
    private int numSDKCacheEntries;
    private int sessionCacheSize;
    private int numSessions;
    private double amTuneMaxNoThreads;
    private double amTuneMaxNoThreads64Bit;
    private int maxThreads;
    private WebContainerConfigInfoBase webConfigInfo = null;
    private ResourceBundle confBundle;
    private DSConfigInfo dsConfigInfo;
    private String passFilePath = null;

    public AMTuneConfigInfo(String confFileName, String passFilePath) throws AMTuneException {
        this.confFileName = confFileName;
        this.passFilePath = passFilePath;
        this.pLogger = AMTuneLogger.getLoggerInst();
        this.mWriter = MessageWriter.getInstance();
        this.initialize();
    }

    private void initialize() throws AMTuneException {
        try {
            this.confBundle = ResourceBundle.getBundle(this.confFileName);
            this.setReviewMode(this.confBundle.getString("AMTUNE_MODE"));
            this.setLogType(this.confBundle.getString("AMTUNE_LOG_LEVEL"));
            this.setTuneOS(this.confBundle.getString("AMTUNE_TUNE_OS"));
            this.setTuneDS(this.confBundle.getString("AMTUNE_TUNE_DS"));
            this.setTuneWebContainer(this.confBundle.getString("AMTUNE_TUNE_WEB_CONTAINER"));
            this.setTuneFAM(this.confBundle.getString("AMTUNE_TUNE_OPENSSO"));
            if (this.isTuneFAM() || this.isTuneWebContainer()) {
                if (this.passFilePath == null || this.passFilePath != null && !new File(this.passFilePath).exists()) {
                    this.mWriter.writelnLocaleMsg("pt-password-file-keys-msg");
                    throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-password-file-not-found"));
                }
                this.setWebContainer(this.confBundle.getString("WEB_CONTAINER"));
                if (this.isTuneWebContainer() && !AMTuneUtil.isSupportedWebContainer(this.getWebContainer())) {
                    throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-unsupported-wc-tuning"));
                }
                if (this.getWebContainer().equalsIgnoreCase("WS7")) {
                    this.webConfigInfo = new WS7ContainerConfigInfo(this.confBundle, this.passFilePath);
                } else if (this.getWebContainer().equalsIgnoreCase("AS91")) {
                    this.webConfigInfo = new AS9ContainerConfigInfo(this.confBundle, this.passFilePath);
                }
            }
            this.isJVM64BitAvailable = this.webConfigInfo != null ? this.webConfigInfo.isJVM64Bit() : false;
            if (this.isTuneFAM()) {
                FileHandler pHdl = new FileHandler(this.passFilePath);
                String reqLine = pHdl.getLine("SSOADM_PASSWORD");
                if (reqLine == null || reqLine != null && reqLine.trim().length() < "SSOADM_PASSWORD".length() + 1) {
                    this.mWriter.writelnLocaleMsg("pt-cannot-proceed");
                    this.mWriter.writelnLocaleMsg("pt-opensso-password-not-found-msg");
                    throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-opensso-password-not-found"));
                }
                this.setFamAdminPassword(AMTuneUtil.getLastToken(reqLine, "="));
                this.setFAMAdmLocation(this.confBundle.getString("SSOADM_LOCATION"));
                this.setFAMAdmUser(this.confBundle.getString("OPENSSOADMIN_USER"));
                this.setFAMServerUrl(this.confBundle.getString("OPENSSOSERVER_URL"));
                this.setRealms(this.confBundle.getString("REALM_NAME"));
            }
            if (this.isTuneDS()) {
                this.dsConfigInfo = new DSConfigInfo(this.confBundle, this.passFilePath);
            }
            if (this.isTuneWebContainer() || this.isTuneFAM()) {
                this.setFAMTuneMinMemoryToUseInMB(this.confBundle.getString("AMTUNE_MIN_MEMORY_TO_USE_IN_MB"));
                this.setFAMTuneMaxMemoryToUseInMB();
                this.setFAMTunePerThreadStackSizeInKB(this.confBundle.getString("AMTUNE_PER_THREAD_STACK_SIZE_IN_KB"));
                this.setFAMTunePerThreadStackSizeInKB64Bit(this.confBundle.getString("AMTUNE_PER_THREAD_STACK_SIZE_IN_KB_64_BIT"));
                this.setFAMTunePctMemoryToUse(this.confBundle.getString("AMTUNE_PCT_MEMORY_TO_USE"));
                this.setFAMTuneMemMaxHeapSizeRatio(this.confBundle.getString("AMTUNE_MEM_MAX_HEAP_SIZE_RATIO"));
                this.setFAMTuneMemMinHeapSizeRatio(this.confBundle.getString("AMTUNE_MEM_MIN_HEAP_SIZE_RATIO"));
                this.calculateTuneParams();
            }
        }
        catch (AMTuneException aex) {
            throw aex;
        }
        catch (Exception ex) {
            this.pLogger.logException("initialize", ex);
            throw new AMTuneException(ex.getMessage());
        }
    }

    private void setRealms(String realmNames) throws AMTuneException {
        if (realmNames != null && realmNames.trim().length() > 0) {
            if (realmNames.indexOf("|") != -1) {
                this.realms = AMTuneUtil.getTokensList(realmNames, "|");
            } else {
                this.realms = new ArrayList();
                this.realms.add(realmNames);
            }
        } else {
            AMTuneUtil.printErrorMsg("REALM_NAME");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-realm-name"));
        }
    }

    public List getRealms() {
        return this.realms;
    }

    private void setReviewMode(String reviewMode) throws AMTuneException {
        if (reviewMode == null || reviewMode != null && reviewMode.trim().length() == 0) {
            AMTuneUtil.printErrorMsg("AMTUNE_MODE");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-amtune-mode"));
        }
        if (reviewMode.trim().equalsIgnoreCase("REVIEW")) {
            this.isReviewMode = true;
        } else if (reviewMode.trim().equalsIgnoreCase("CHANGE")) {
            this.isReviewMode = false;
        } else {
            AMTuneUtil.printErrorMsg("AMTUNE_MODE");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-invalid-amtune-mode"));
        }
        this.pLogger.log(Level.INFO, "setReviewMode", "Review mode is set to : " + this.isReviewMode);
    }

    public boolean isReviewMode() {
        return this.isReviewMode;
    }

    private void setLogType(String logType) throws AMTuneException {
        this.logType = logType;
        if (logType == null || logType != null && logType.trim().length() == 0) {
            AMTuneUtil.printErrorMsg("AMTUNE_LOG_LEVEL");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-config-log-type"));
        }
        if (logType.trim().equalsIgnoreCase("NONE")) {
            MessageWriter.setWriteToFile(true);
            MessageWriter.setWriteToTerm(false);
        } else if (logType.trim().equalsIgnoreCase("TERM")) {
            MessageWriter.setWriteToFile(false);
            MessageWriter.setWriteToTerm(true);
        } else if (logType.trim().equalsIgnoreCase("FILE")) {
            MessageWriter.setWriteToFile(true);
            MessageWriter.setWriteToTerm(true);
        } else {
            AMTuneUtil.printErrorMsg("AMTUNE_LOG_LEVEL");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-invalid-log-level"));
        }
    }

    public String getLogType() {
        return this.logType;
    }

    private void setTuneOS(String value) throws AMTuneException {
        if (value == null || value != null && value.trim().length() == 0) {
            AMTuneUtil.printErrorMsg("AMTUNE_TUNE_OS");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-tune-os"));
        }
        this.tuneOS = value.trim().equalsIgnoreCase("true");
    }

    public boolean isTuneOS() {
        return this.tuneOS;
    }

    private void setTuneWebContainer(String value) throws AMTuneException {
        if (value == null || value != null && value.trim().length() == 0) {
            AMTuneUtil.printErrorMsg("AMTUNE_TUNE_WEB_CONTAINER");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-tune-ws"));
        }
        this.tuneWebContainer = value.trim().equalsIgnoreCase("true");
    }

    public boolean isTuneWebContainer() {
        return this.tuneWebContainer;
    }

    private void setTuneDS(String value) throws AMTuneException {
        if (value == null || value != null && value.trim().length() == 0) {
            AMTuneUtil.printErrorMsg("AMTUNE_TUNE_DS");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-tune-ds"));
        }
        this.tuneDS = value.trim().equalsIgnoreCase("true");
    }

    public boolean isTuneDS() {
        return this.tuneDS;
    }

    private void setTuneFAM(String value) throws AMTuneException {
        if (value == null || value != null && value.trim().length() == 0) {
            AMTuneUtil.printErrorMsg("AMTUNE_TUNE_OPENSSO");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-tune-opensso"));
        }
        this.tuneFAM = value.trim().equalsIgnoreCase("true");
    }

    public boolean isTuneFAM() {
        return this.tuneFAM;
    }

    private void setWebContainer(String webContainer) throws AMTuneException {
        if (webContainer == null || webContainer.trim().length() <= 0) {
            AMTuneUtil.printErrorMsg("WEB_CONTAINER");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-wc"));
        }
        this.webContainer = webContainer.trim();
    }

    public String getWebContainer() {
        return this.webContainer;
    }

    private void setFAMAdmLocation(String famAdmLocation) throws AMTuneException {
        if (famAdmLocation != null && famAdmLocation.trim().length() > 0) {
            File famDir = new File(famAdmLocation.trim());
            if (!famDir.isDirectory()) {
                this.mWriter.write(famAdmLocation + " ");
                this.mWriter.writeLocaleMsg("pt-not-valid-dir");
                AMTuneUtil.printErrorMsg("SSOADM_LOCATION");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-invalid-opensso-admin-tools"));
            }
        } else {
            this.mWriter.writelnLocaleMsg("pt-inval-config");
            AMTuneUtil.printErrorMsg("SSOADM_LOCATION");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-invalid-opensso-admin-tools"));
        }
        this.famAdmLocation = famAdmLocation.trim();
    }

    public String getFAMAdmLocation() {
        return this.famAdmLocation;
    }

    private void setFAMServerUrl(String famServerUrl) throws AMTuneException {
        if (famServerUrl == null || famServerUrl.trim().length() <= 0) {
            AMTuneUtil.printErrorMsg("OPENSSOSERVER_URL");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-fam-server-url-not-found"));
        }
        this.famServerUrl = famServerUrl.trim();
    }

    public String getFAMServerUrl() {
        return this.famServerUrl;
    }

    private void setFAMAdmUser(String famAdmUser) throws AMTuneException {
        if (famAdmUser == null || famAdmUser.trim().length() <= 0) {
            AMTuneUtil.printErrorMsg("OPENSSOADMIN_USER");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-fam-admin-user-not-found"));
        }
        this.famAdmUser = famAdmUser.trim();
    }

    public String getFAMAdmUser() {
        return this.famAdmUser;
    }

    public void setFAMTunePctMemoryToUse(String famTunePctMemoryToUse) throws AMTuneException {
        try {
            this.famTunePctMemoryToUse = famTunePctMemoryToUse != null && famTunePctMemoryToUse.trim().length() > 0 ? Integer.parseInt(famTunePctMemoryToUse.trim()) : 75;
            if (this.famTunePctMemoryToUse > 100) {
                this.pLogger.log(Level.WARNING, "setTunePctMemoryToUse", "AMTUNE_PCT_MEMORY_TO_USE value is > 100 so using default value 100.");
                this.famTunePctMemoryToUse = 100;
            } else if (this.famTunePctMemoryToUse < 0) {
                this.pLogger.log(Level.WARNING, "setTunePctMemoryToUse", "AMTUNE_PCT_MEMORY_TO_USE value is < 0 so using default value 0.");
                this.famTunePctMemoryToUse = 0;
            }
        }
        catch (NumberFormatException ex) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("AMTUNE_PCT_MEMORY_TO_USE");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-not-valid-int"));
        }
    }

    private int getFAMTunePctMemoryToUse() {
        return this.famTunePctMemoryToUse;
    }

    private void setFAMTunePerThreadStackSizeInKB(String famTunePerThreadStackSizeInKB) throws AMTuneException {
        try {
            this.famTunePerThreadStackSizeInKB = famTunePerThreadStackSizeInKB != null && famTunePerThreadStackSizeInKB.trim().length() > 0 ? Integer.parseInt(famTunePerThreadStackSizeInKB.trim()) : 128;
        }
        catch (NumberFormatException ex) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("AMTUNE_PER_THREAD_STACK_SIZE_IN_KB");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-not-valid-int"));
        }
    }

    public int getFAMTunePerThreadStackSizeInKB() {
        return this.famTunePerThreadStackSizeInKB;
    }

    private void setFAMTunePerThreadStackSizeInKB64Bit(String famTunePerThreadStackSizeInKB64Bit) throws AMTuneException {
        try {
            this.famTunePerThreadStackSizeInKB64Bit = famTunePerThreadStackSizeInKB64Bit != null && famTunePerThreadStackSizeInKB64Bit.trim().length() > 0 ? Integer.parseInt(famTunePerThreadStackSizeInKB64Bit.trim()) : 512;
        }
        catch (NumberFormatException ex) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("AMTUNE_PER_THREAD_STACK_SIZE_IN_KB_64_BIT");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-not-valid-int"));
        }
    }

    public int getFAMTunePerThreadStackSizeInKB64Bit() {
        return this.famTunePerThreadStackSizeInKB64Bit;
    }

    private void setFAMTuneMemMaxHeapSizeRatio(String famTuneMemMaxHeapSizeRatio) throws AMTuneException {
        try {
            this.famTuneMemMaxHeapSizeRatio = AMTuneUtil.evaluteDivExp(famTuneMemMaxHeapSizeRatio.trim());
            this.famTuneMemMaxHeapSizeRatioExp = famTuneMemMaxHeapSizeRatio.trim();
        }
        catch (NumberFormatException ex) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("AMTUNE_MEM_MAX_HEAP_SIZE_RATIO");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-not-valid-exp"));
        }
        catch (NullPointerException ne) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("AMTUNE_MEM_MAX_HEAP_SIZE_RATIO");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-operands"));
        }
    }

    public double getFAMTuneMemMaxHeapSizeRatio() {
        return this.famTuneMemMaxHeapSizeRatio;
    }

    public String getFAMTuneMemMaxHeapSizeRatioExp() {
        return this.famTuneMemMaxHeapSizeRatioExp;
    }

    private void setFAMTuneMemMinHeapSizeRatio(String famTuneMemMinHeapSizeRatio) throws AMTuneException {
        try {
            this.famTuneMemMinHeapSizeRatio = AMTuneUtil.evaluteDivExp(famTuneMemMinHeapSizeRatio.trim());
        }
        catch (NumberFormatException ex) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("AMTUNE_MEM_MIN_HEAP_SIZE_RATIO");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-not-valid-exp"));
        }
        catch (NullPointerException ne) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("AMTUNE_MEM_MIN_HEAP_SIZE_RATIO");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-operands"));
        }
    }

    public double getFAMTuneMemMinHeapSizeRation() {
        return this.famTuneMemMinHeapSizeRatio;
    }

    private void setFAMTuneMinMemoryToUseInMB(String famTuneMinMemoryToUseInMB) throws AMTuneException {
        try {
            this.famTuneMinMemoryToUseInMB = famTuneMinMemoryToUseInMB != null ? Integer.parseInt(famTuneMinMemoryToUseInMB) : 512;
        }
        catch (NumberFormatException exp) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("AMTUNE_MIN_MEMORY_TO_USE_IN_MB");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-not-valid-int"));
        }
    }

    private void setFAMTuneMaxMemoryToUseInMB() throws Exception {
        if (AMTuneUtil.isLinux() || AMTuneUtil.isSunOs() || AMTuneUtil.isAIX()) {
            if (this.getWebContainer().equalsIgnoreCase("WS7")) {
                if (AMTuneUtil.isLinux()) {
                    this.setFAMTuneMaxMemoryToUseInMB("AMTUNE_MAX_MEMORY_TO_USE_IN_MB_X86");
                } else {
                    this.setFAMTuneMaxMemoryToUseInMB("AMTUNE_MAX_MEMORY_TO_USE_IN_MB_SOLARIS");
                }
            } else {
                this.setFAMTuneMaxMemoryToUseInMB("AMTUNE_MAX_MEMORY_TO_USE_IN_MB_SOLARIS");
            }
        } else if (AMTuneUtil.isWindows()) {
            this.setFAMTuneMaxMemoryToUseInMB("AMTUNE_MAX_MEMORY_TO_USE_IN_MB_DEFAULT");
        }
    }

    public int getFAMTuneMinMemoryToUseInMB() {
        return this.famTuneMinMemoryToUseInMB;
    }

    private void setFAMTuneMaxMemoryToUseInMB(String famTuneMaxMemoryToUseInMBKey) throws AMTuneException {
        try {
            String val = this.confBundle.getString(famTuneMaxMemoryToUseInMBKey);
            if (val == null || val != null && val.trim().length() == 0) {
                AMTuneUtil.printErrorMsg(famTuneMaxMemoryToUseInMBKey);
                throw new AMTuneException("Null value for " + famTuneMaxMemoryToUseInMBKey);
            }
            this.famTuneMaxMemoryToUseInMB = Integer.parseInt(val.trim());
        }
        catch (NumberFormatException exp) {
            AMTuneUtil.printErrorMsg(famTuneMaxMemoryToUseInMBKey);
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-not-valid-int"));
        }
        catch (MissingResourceException mex) {
            AMTuneUtil.printErrorMsg(famTuneMaxMemoryToUseInMBKey);
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-key-not-found"));
        }
    }

    public int getFAMTuneMaxMemoryToUseInMB() {
        return this.famTuneMaxMemoryToUseInMB;
    }

    private void setFamAdminPassword(String famAdminPassword) throws AMTuneException {
        if (famAdminPassword == null || famAdminPassword.trim().length() <= 0) {
            this.mWriter.writelnLocaleMsg("pt-opensso-password-not-found-msg");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-opensso-password-null"));
        }
        this.famAdminPassword = famAdminPassword.trim();
    }

    public String getFamAdminPassword() {
        return this.famAdminPassword;
    }

    private void calculateTuneParams() throws AMTuneException {
        try {
            this.mWriter.writeln("---------------------------------------------------------------------");
            this.mWriter.write("OpenSSO tune ");
            this.mWriter.writelnLocaleMsg("pt-conf-info");
            this.mWriter.writeln("---------------------------------------------------------------------");
            if (this.isReviewMode) {
                this.mWriter.writelnLocaleMsg("pt-review-msg");
            } else {
                this.mWriter.writelnLocaleMsg("pt-change-msg");
            }
            this.mWriter.writeLocaleMsg("pt-os-msg");
            this.mWriter.writeln(this.tuneOS + " ");
            this.mWriter.writeLocaleMsg("pt-fam-msg");
            this.mWriter.writeln(this.tuneFAM + " ");
            this.mWriter.writeLocaleMsg("pt-ds-msg");
            this.mWriter.writeln(this.tuneDS + " ");
            this.mWriter.writeLocaleMsg("pt-web-msg");
            this.mWriter.writeln(this.tuneWebContainer + " ");
            if (this.webContainer.equalsIgnoreCase("WS7") || this.webContainer.equalsIgnoreCase("WS61") || this.webContainer.equalsIgnoreCase("AS91")) {
                if (this.isJVM64BitAvailable) {
                    this.mWriter.writelnLocaleMsg("pt-ws-64-msg");
                } else {
                    this.mWriter.writelnLocaleMsg("pt-ws-32-msg");
                }
            }
            this.mWriter.writeln("---------------------------------------------------------------------");
            this.mWriter.writelnLocaleMsg("pt-conf-detecting");
            this.mWriter.writeln("---------------------------------------------------------------------");
            this.numCpus = Integer.parseInt(AMTuneUtil.getNumberOfCPUS());
            this.mWriter.writeLocaleMsg("pt-no-cpu");
            this.mWriter.writeln(this.numCpus + " ");
            this.acceptorThreads = this.numCpus;
            this.mWriter.writeLocaleMsg("pt-ws-acceptor-msg");
            this.mWriter.writeln(this.acceptorThreads + " ");
            this.memAvail = Integer.parseInt(AMTuneUtil.getSystemMemory());
            this.mWriter.writeLocaleMsg("pt-mem-avail-msg");
            this.mWriter.writeln(this.memAvail + " ");
            this.memToUse = this.memAvail * this.getFAMTunePctMemoryToUse() / 100;
            if (this.memToUse > this.famTuneMaxMemoryToUseInMB && !this.isJVM64BitAvailable) {
                this.memToUse = this.famTuneMaxMemoryToUseInMB;
            }
            this.mWriter.writeLocaleMsg("pt-mem-to-use-msg");
            this.mWriter.writeln(this.memToUse + " ");
            if (this.memToUse == 0) {
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-unable-mem-req"));
            }
            if (this.memToUse < this.getFAMTuneMinMemoryToUseInMB()) {
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-no-enough-mem"));
            }
            this.mWriter.writelnLocaleMsg("pt-enough-mem");
            this.mWriter.writeln("---------------------------------------------------------------------");
            this.mWriter.writelnLocaleMsg("pt-conf-calc-tune-params");
            this.mWriter.writeln("---------------------------------------------------------------------");
            this.maxHeapSize = (int)((double)this.memToUse * this.getFAMTuneMemMaxHeapSizeRatio());
            this.mWriter.writeLocaleMsg("pt-max-heap-size-msg");
            this.mWriter.writeln(this.maxHeapSize + " ");
            this.minHeapSize = this.maxHeapSize;
            this.mWriter.writeLocaleMsg("pt-min-heap-size-msg");
            this.mWriter.writeln(this.minHeapSize + " ");
            this.maxNewSize = (int)((double)this.maxHeapSize * 0.125);
            this.mWriter.writeLocaleMsg("pt-max-new-size-msg");
            this.mWriter.writeln(this.maxNewSize + " ");
            if (this.getWebContainer().equalsIgnoreCase("WS61")) {
                this.maxPermSize = (int)((double)this.maxHeapSize * 0.08333333333333333);
                this.mWriter.writeLocaleMsg("pt-max-perm-size-msg");
                this.mWriter.writeln(this.maxPermSize + " ");
            }
            this.cacheSize = (int)((double)this.maxHeapSize * 0.3333333333333333);
            this.mWriter.writeLocaleMsg("pt-cache-size-msg");
            this.mWriter.writeln(this.cacheSize + " ");
            this.sdkCacheSize = (int)((double)this.cacheSize * 0.6666666666666666);
            this.mWriter.writeLocaleMsg("pt-sdk-cache-size-msg");
            this.mWriter.writeln(this.sdkCacheSize + " ");
            this.numSDKCacheEntries = (int)((double)this.sdkCacheSize * 1024.0 / 8.0);
            this.mWriter.writeLocaleMsg("pt-no-sdk-cache-ent-msg");
            this.mWriter.writeln(this.numSDKCacheEntries + " ");
            this.sessionCacheSize = (int)((double)this.cacheSize * 0.3333333333333333);
            this.mWriter.writeLocaleMsg("pt-session-cache-size-msg");
            this.mWriter.writeln(this.sessionCacheSize + " ");
            this.numSessions = (int)((double)this.sessionCacheSize * 1024.0 / 4.0);
            this.mWriter.writeLocaleMsg("pt-no-session-cache-ent-msg");
            this.mWriter.writeln(this.numSessions + " ");
            this.amTuneMaxNoThreads = 0.0625 * (1024.0 / (double)this.getFAMTunePerThreadStackSizeInKB());
            this.amTuneMaxNoThreads64Bit = 0.0625 * (1024.0 / (double)this.getFAMTunePerThreadStackSizeInKB64Bit());
            this.maxThreads = 0;
            this.maxThreads = this.isJVM64BitAvailable ? (int)(this.amTuneMaxNoThreads64Bit * (double)this.maxHeapSize) : (int)(this.amTuneMaxNoThreads * (double)this.maxHeapSize);
            this.mWriter.writeLocaleMsg("pt-max-java-threads-msg");
            this.mWriter.writeln(this.maxThreads + " ");
            this.numOfMaxThreadPool = this.numRQThrottle = (int)((double)this.maxThreads * 0.4166666666666667);
            if (this.getWebContainer().equals("WS61")) {
                this.mWriter.writeLocaleMsg("pt-rq-thro-msg");
                this.mWriter.writeln(this.numRQThrottle + " ");
            } else {
                this.mWriter.writeLocaleMsg("pt-max-thread-pool-msg");
                this.mWriter.writeln(this.numOfMaxThreadPool + " ");
            }
            this.numLdapAuthThreads = (int)((double)this.maxThreads * 0.041666666666666664);
            this.mWriter.writeLocaleMsg("pt-ldap-auth-threads-msg");
            this.mWriter.writeln(this.numLdapAuthThreads + " ");
            this.numSMLdapThreads = (int)((double)this.maxThreads * 0.041666666666666664);
            this.mWriter.writeLocaleMsg("pt-sm-ldap-threads-msg");
            this.mWriter.writeln(this.numSMLdapThreads + " ");
            this.numNotificationThreads = this.numCpus * 3;
            this.mWriter.writeLocaleMsg("pt-notification-threads-msg");
            this.mWriter.writeln(this.numNotificationThreads + " ");
            this.numNotificationQueue = (int)(0.3 * (double)this.numSessions);
            this.numNotificationQueue = this.numNotificationQueue / 11 * 11;
            this.mWriter.writeLocaleMsg("pt-notification-queue-size-msg");
            this.mWriter.writeln(this.numNotificationQueue + " ");
            this.mWriter.writeln("=====================================================================");
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "calculateTuneParams", "Error while caliculating tuning parameters.");
            this.pLogger.logException("calculateTuneParams", ex);
            throw new AMTuneException(ex.getMessage());
        }
    }

    public int getAcceptorThreads() {
        return this.acceptorThreads;
    }

    public double getAmTuneMaxNoThreads() {
        return this.amTuneMaxNoThreads;
    }

    public double getAmTuneMaxNoThreads64Bit() {
        return this.amTuneMaxNoThreads64Bit;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public int getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public int getMaxNewSize() {
        return this.maxNewSize;
    }

    public int getMaxPermSize() {
        return this.maxPermSize;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public int getMemAvail() {
        return this.memAvail;
    }

    public int getMemToUse() {
        return this.memToUse;
    }

    public int getMinHeapSize() {
        return this.minHeapSize;
    }

    public int getNumCpus() {
        return this.numCpus;
    }

    public int getNumLdapAuthThreads() {
        return this.numLdapAuthThreads;
    }

    public int getNumNotificationQueue() {
        return this.numNotificationQueue;
    }

    public int getNumNotificationThreads() {
        return this.numNotificationThreads;
    }

    public int getNumOfMaxThreadPool() {
        return this.numOfMaxThreadPool;
    }

    public int getNumRQThrottle() {
        return this.numRQThrottle;
    }

    public int getNumSDKCacheEntries() {
        return this.numSDKCacheEntries;
    }

    public int getNumSMLdapThreads() {
        return this.numSMLdapThreads;
    }

    public int getNumSessions() {
        return this.numSessions;
    }

    public int getSdkCacheSize() {
        return this.sdkCacheSize;
    }

    public int getSessionCacheSize() {
        return this.sessionCacheSize;
    }

    public WebContainerConfigInfoBase getWSConfigInfo() {
        return this.webConfigInfo;
    }

    public DSConfigInfo getDSConfigInfo() {
        return this.dsConfigInfo;
    }
}

