/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.CaseInsensitiveHashSet;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.policy.ConditionDecision;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.interfaces.Condition;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SMSUtils;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class UserSelfCheckCondition
implements Condition {
    public static final String ATTRIBUTES = "attributes";
    public static final String NOT_ATTRIBUTES = "notAttributes";
    static final String RESOURCE_PREFIX = "sms://";
    static final String RESOURCE_NAME = "/sunIdentityRepositoryService/1.0/application/";
    private Set attributes;
    private Set notAttributes;
    private boolean allowAllAttributes;
    private Map properties;
    private static List propertyNames;
    Debug debug = Debug.getInstance((String)"amPolicy");

    public UserSelfCheckCondition() {
        this.attributes = Collections.EMPTY_SET;
    }

    public List getPropertyNames() {
        if (propertyNames == null) {
            LinkedList<String> answer = new LinkedList<String>();
            answer.add(ATTRIBUTES);
            answer.add(NOT_ATTRIBUTES);
            propertyNames = Collections.unmodifiableList(answer);
        }
        return propertyNames;
    }

    public Syntax getPropertySyntax(String property) {
        return Syntax.ANY;
    }

    public String getDisplayName(String property, Locale locale) throws PolicyException {
        return property;
    }

    public Set getValidValues(String property) throws PolicyException {
        return Collections.EMPTY_SET;
    }

    public void setProperties(Map properties) throws PolicyException {
        if (properties == null || properties.keySet() == null) {
            throw new PolicyException("amPolicy", "properties_can_not_be_null_or_empty", null, null);
        }
        this.properties = Collections.unmodifiableMap(properties);
        Object attrSet = properties.get(ATTRIBUTES);
        Object notAttrSet = properties.get(NOT_ATTRIBUTES);
        if (attrSet == null && notAttrSet == null) {
            throw new PolicyException("amPolicy", "properties_can_not_be_null_or_empty", null, null);
        }
        if (attrSet != null && attrSet instanceof Set) {
            this.attributes = new CaseInsensitiveHashSet();
            this.attributes.addAll((Set)attrSet);
        } else if (this.debug.messageEnabled()) {
            this.debug.message("UserSelfCheckCondition:setProperties: Attributes are empty");
        }
        if (notAttrSet != null && notAttrSet instanceof Set) {
            this.notAttributes = new CaseInsensitiveHashSet();
            this.notAttributes.addAll((Set)notAttrSet);
            if (this.debug.messageEnabled()) {
                this.debug.message("UserSelfCheckCondition.setProperties():notAttributes = " + properties.get(NOT_ATTRIBUTES));
            }
        } else if (this.debug.messageEnabled()) {
            this.debug.message("UserSelfCheckCondition:setProperties: NotAttributes are empty");
        }
        this.allowAllAttributes = this.attributes.contains("*");
        if (this.debug.messageEnabled()) {
            this.debug.message("UserSelfCheckCondition.setProperties():attributes, notAttributes = " + this.attributes + "," + this.notAttributes);
        }
    }

    public Map getProperties() {
        return this.properties;
    }

    public ConditionDecision getConditionDecision(SSOToken token, Map env) throws PolicyException, SSOException {
        boolean allowed = false;
        if (this.debug.messageEnabled()) {
            this.debug.message("UserSelfCheckCondition.getConditionDecision: called with Token: " + token.getPrincipal().getName() + ", requestedResourcename: " + env.get("sun.am.requestedResource"));
        }
        boolean attributeCheckOk = this.allowAllAttributes;
        if (this.debug.messageEnabled()) {
            this.debug.message("UserSelfCheckCondition.getConditionDecision: attributeCheckOk:" + attributeCheckOk);
        }
        Set attrSet = null;
        if (!attributeCheckOk) {
            Object o = env.get(ATTRIBUTES);
            if (o != null && o instanceof Set) {
                Set s = (Set)o;
                if (!s.isEmpty()) {
                    attrSet = new CaseInsensitiveHashSet();
                    attrSet.addAll((Set)o);
                    if (this.debug.messageEnabled()) {
                        this.debug.message("UserSelfCheckCondition.getConditionDecision: Is attributes " + attrSet + " subset of config attrs: " + this.attributes);
                    }
                    if (this.attributes.containsAll(attrSet)) {
                        attributeCheckOk = true;
                    }
                }
            } else if (this.debug.warningEnabled()) {
                this.debug.warning("UserSelfCheckCondition.getConditionDecision Invalid attribute set in env params");
            }
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("UserSelfCheckCondition.getConditionDecision: attributes check:" + attributeCheckOk);
        }
        if (!attributeCheckOk && this.notAttributes != null && !this.notAttributes.isEmpty()) {
            if (attrSet != null && !attrSet.isEmpty()) {
                if (this.debug.messageEnabled()) {
                    this.debug.message("UserSelfCheckCondition.getConditionDecision: Is attributes " + attrSet + " subset of notattrs:" + this.notAttributes);
                }
                Iterator it = attrSet.iterator();
                int i = 0;
                while (it.hasNext()) {
                    String attr = (String)it.next();
                    if (this.notAttributes.contains(attr)) {
                        attributeCheckOk = false;
                        break;
                    }
                    attributeCheckOk = true;
                    ++i;
                }
            }
            if (this.debug.messageEnabled()) {
                this.debug.message("UserSelfCheckCondition.getConditionDecision: attributeCheckOk " + attributeCheckOk + " for notAttributes " + this.notAttributes);
            }
        }
        if (attributeCheckOk) {
            StringBuffer name = new StringBuffer(100);
            name.append(RESOURCE_PREFIX);
            try {
                AMIdentity id = IdUtils.getIdentity(token);
                name.append(id.getRealm());
                name.append(RESOURCE_NAME);
                name.append(id.getType().getName()).append("/");
                name.append(id.getName());
            }
            catch (SSOException ssoe) {
                if (this.debug.messageEnabled()) {
                    this.debug.message("UserSelfCheckCondition.getConditionDecision: invalid sso token: " + ssoe.getMessage());
                }
                throw ssoe;
            }
            catch (IdRepoException ide) {
                if (this.debug.messageEnabled()) {
                    this.debug.message("UserSelfCheckCondition.getConditionDecision IdRepo exception: ", (Throwable)ide);
                }
                throw new PolicyException(ide);
            }
            Object o = env.get("sun.am.requestedResource");
            if (this.debug.messageEnabled()) {
                this.debug.message("UserSelfCheckCondition.getConditionDecision: name: " + name + " resource: " + o);
            }
            if (o != null) {
                String resource = null;
                if (o instanceof String) {
                    resource = (String)o;
                } else if (o instanceof Set) {
                    resource = (String)((Set)o).iterator().next();
                } else if (this.debug.warningEnabled()) {
                    resource = "";
                    this.debug.warning("UserSelfCheckCondition.getConditionDecision: Unable to get resource name");
                }
                if (resource.equalsIgnoreCase(name.toString())) {
                    allowed = true;
                    if (this.debug.messageEnabled()) {
                        this.debug.message("UserSelfCheckCondition.getConditionDecision: returning true");
                    }
                } else if (this.debug.messageEnabled()) {
                    this.debug.message("UserSelfCheckCondition.getConditionDecision:Resource names donot match: " + resource + " " + name);
                }
            }
        }
        return new ConditionDecision(allowed);
    }

    public Object clone() {
        UserSelfCheckCondition theClone = null;
        try {
            theClone = (UserSelfCheckCondition)super.clone();
            theClone.properties = Collections.unmodifiableMap(SMSUtils.copyAttributes(this.properties));
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        return theClone;
    }
}

