/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.cdc;

import com.iplanet.dpro.session.DNOrIPAddressListTokenRestriction;
import com.iplanet.dpro.session.TokenRestriction;
import com.iplanet.services.cdc.CDCServlet;
import com.iplanet.services.cdc.SPValidator;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoBundle;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchOpModifier;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.security.AdminTokenAction;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LdapSPValidator
implements SPValidator {
    private static final String LDAP_ATTR_NAME = "sunIdentityServerDeviceKeyValue";
    private static final String LDAP_STATUS_ATTR_NAME = "sunIdentityServerDeviceStatus";
    private static final String PROVIDER_ID_ATTR_NAME = "agentRootURL";
    private static final int PROVIDER_ID_ATTR_LEN = 13;
    private static final String HOSTNAME_ATTR_NAME = "hostname";
    private static final int HOSTNAME_ATTR_LEN = 9;
    private static final String REALM_NAME_ATTR = "Realm=";
    private static final String HTTPS = "https";
    private static final int HTTPS_DEFAULT_PORT = 443;
    private static final int HTTP_DEFAULT_PORT = 80;
    private AMIdentityRepository amIdRepo = null;
    private Exception exception;

    public LdapSPValidator() {
        try {
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            this.amIdRepo = new AMIdentityRepository(adminToken, null);
            if (this.amIdRepo == null) {
                this.exception = new IdRepoException(IdRepoBundle.getString((String)"32"), "32");
            }
        }
        catch (SSOException e) {
            this.exception = e;
            CDCServlet.debug.error("CDC:LdapSPValidator.<init>: unable to get SSO Token: ", (Throwable)e);
        }
        catch (IdRepoException e) {
            this.exception = e;
            CDCServlet.debug.error("CDC:LdapSPValidator.<init>: unable to get Root Realm/Organization: ", (Throwable)e);
        }
    }

    public TokenRestriction validateAndGetRestriction(FSAuthnRequest request, String gotoURL) throws Exception {
        int idx;
        if (this.exception != null) {
            throw this.exception;
        }
        String realm = null;
        URL url = new URL(URLDecoder.decode(request.getProviderId(), "UTF-8"));
        String realmName = url.getQuery();
        if (realmName != null && (idx = realmName.indexOf(REALM_NAME_ATTR)) != -1) {
            realm = realmName.substring(idx + REALM_NAME_ATTR.length() + 1);
        }
        StringBuffer rootPrefix = new StringBuffer(1024);
        rootPrefix.append(url.getProtocol()).append("://").append(url.getHost()).append(":").append(url.getPort()).append("/");
        try {
            Map agents = this.searchAgents(rootPrefix, realm);
            if (agents.isEmpty()) {
                if (CDCServlet.debug.warningEnabled()) {
                    CDCServlet.debug.warning("LdapSPValidator.validateAndGetRestriction: Invalid agent ID: " + rootPrefix);
                }
                throw new Exception("Invalid Agent: Not configured in directory");
            }
            String agentDN = null;
            ArrayList hostnames = new ArrayList();
            boolean gotoUrlValid = false;
            URL gotoUrl = new URL(gotoURL);
            String gotoHost = gotoUrl.getHost().toLowerCase();
            String gotoProtocol = gotoUrl.getProtocol().toLowerCase();
            int gotoPort = gotoUrl.getPort();
            if (gotoPort == -1) {
                gotoPort = HTTPS.equalsIgnoreCase(gotoProtocol) ? 443 : 80;
            }
            for (AMIdentity amid : agents.keySet()) {
                Set attrValues;
                Map attributes = amid.getAttributes();
                if (attributes == null || !this.isAgentActive(attributes) || (attrValues = (Set)attributes.get(LDAP_ATTR_NAME)) == null || attrValues.isEmpty()) continue;
                this.getHostnames(attrValues, hostnames);
                if (!this.validateGotoUrl(attrValues, hostnames, gotoHost, gotoProtocol, gotoPort)) continue;
                agentDN = IdUtils.getDN((AMIdentity)amid);
                gotoUrlValid = true;
            }
            if (!gotoUrlValid) {
                if (CDCServlet.debug.warningEnabled()) {
                    CDCServlet.debug.warning("LdapSPValidator.validateAndGetRestrictionInvalid GoTo URL: " + gotoURL + " for Agent ID: " + rootPrefix);
                }
                throw new Exception("Goto URL not valid for the agent Provider ID");
            }
            if (CDCServlet.debug.messageEnabled()) {
                CDCServlet.debug.message("LdapSPValidator.validateAndGetRestriction: Restriction string for: " + rootPrefix + " is: " + agentDN + " " + hostnames);
            }
            return new DNOrIPAddressListTokenRestriction(agentDN, hostnames);
        }
        catch (Exception ex) {
            throw new Exception("Invalid Agent: Could not get agent for the realm");
        }
    }

    private Map searchAgents(StringBuffer rootPrefix, String realm) throws Exception {
        HashMap searchParams = new HashMap();
        HashSet<String> attrValues = new HashSet<String>(2);
        attrValues.add("agentRootURL=" + rootPrefix.toString());
        searchParams.put(LDAP_ATTR_NAME, attrValues);
        IdSearchControl idsc = new IdSearchControl();
        idsc.setTimeOut(0);
        idsc.setMaxResults(0);
        idsc.setSearchModifiers(IdSearchOpModifier.AND, searchParams);
        HashSet<String> returnAttrs = new HashSet<String>(4);
        returnAttrs.add(LDAP_ATTR_NAME);
        returnAttrs.add(LDAP_STATUS_ATTR_NAME);
        idsc.setReturnAttributes(returnAttrs);
        try {
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            IdSearchResults sr = null;
            if (realm != null && realm.trim().length() > 0) {
                AMIdentityRepository idRepo = new AMIdentityRepository(adminToken, realm);
                sr = idRepo.searchIdentities(IdType.AGENT, "*", idsc);
            } else {
                sr = this.amIdRepo.searchIdentities(IdType.AGENT, "*", idsc);
            }
            return sr.getResultAttributes();
        }
        catch (IdRepoException e) {
            this.exception = e;
            CDCServlet.debug.error("LdapSPValidator.searchAgents", (Throwable)e);
            throw this.exception;
        }
        catch (SSOException e) {
            this.exception = e;
            CDCServlet.debug.error("LdapSPValidator.searchAgents", (Throwable)e);
            throw this.exception;
        }
    }

    private boolean isAgentActive(Map attributes) {
        Set attrvalues;
        boolean agentIsActive = false;
        if (attributes != null && (attrvalues = (Set)attributes.get(LDAP_STATUS_ATTR_NAME)) != null && !attrvalues.isEmpty()) {
            String status = (String)attrvalues.iterator().next();
            agentIsActive = status.equalsIgnoreCase("Active");
        }
        return agentIsActive;
    }

    private boolean validateGotoUrl(Set attrValues, List hostnames, String gotoHost, String gotoProtocol, int gotoPort) throws MalformedURLException {
        boolean valid = false;
        for (String value : attrValues) {
            if (!value.startsWith(PROVIDER_ID_ATTR_NAME)) continue;
            URL u = new URL(value.substring(13));
            hostnames.add(u.getHost());
            valid |= u.getHost().toLowerCase().equals(gotoHost) && u.getProtocol().toLowerCase().equals(gotoProtocol) && u.getPort() == gotoPort;
        }
        return valid;
    }

    private void getHostnames(Set attrValues, List hostnames) {
        if (attrValues != null && !attrValues.isEmpty()) {
            for (String value : attrValues) {
                if (!value.startsWith(HOSTNAME_ATTR_NAME)) continue;
                hostnames.add(value.substring(9));
            }
        }
    }
}

