/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.handlers;

import com.sun.identity.log.ILogRecord;
import com.sun.identity.log.LogManager;
import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.secure.MACGenerator;
import com.sun.identity.log.spi.Debug;
import com.sun.identity.log.spi.IGenerator;
import com.sun.identity.log.spi.ITimestampGenerator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Formatter;
import java.util.logging.Handler;

public class SecureELFFormatter
extends Formatter {
    private LogManager lmanager = LogManagerUtil.getLogManager();
    private IGenerator fieldGenerator = new MACGenerator();
    private ITimestampGenerator secureTimestampGenerator;
    private final String NOTAVAIL = "Not Available";

    public SecureELFFormatter() {
        String timestampGeneratorClass = this.lmanager.getProperty("iplanet-am-logging-secure-timestamp-generator");
        try {
            Class<?> clz = Class.forName(timestampGeneratorClass);
            this.secureTimestampGenerator = (ITimestampGenerator)clz.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            Debug.error("SecureELFFormatter: TimeStamp Generator Class not found", cnfe);
        }
        catch (InstantiationException ie) {
            Debug.error("SecureELFFormatter: Timestamp Generator Could not be Instantiated", ie);
        }
        catch (IllegalAccessException iae) {
            Debug.error("SecureELFFormatter: Timestamp Generator Could not be Instantiated", iae);
        }
    }

    public String format(LogRecord logRecord) {
        Map logInfoTable = logRecord.getLogInfoMap();
        StringBuffer sbuffer = new StringBuffer();
        StringBuffer stringForMAC = new StringBuffer();
        try {
            String[] allFields = this.lmanager.getAllFields();
            Set selectedFields = this.lmanager.getSelectedFieldSet();
            String strTime = this.secureTimestampGenerator.getTimestamp();
            sbuffer.append("\"").append(strTime).append("\"\t");
            stringForMAC.append("\"").append(strTime).append("\"");
            StringBuffer message = this.processString(this.formatMessage(logRecord));
            boolean escapeDone = false;
            for (int i = 0; i < message.length(); ++i) {
                if (message.charAt(i) != ' ' && message.charAt(i) != '\t') continue;
                sbuffer.append("\"").append(message).append("\"\t");
                stringForMAC.append("\"").append(message).append("\"");
                escapeDone = true;
                break;
            }
            if (!escapeDone) {
                sbuffer.append(message).append("\t");
                stringForMAC.append(message);
            }
            String key = null;
            String value = null;
            for (int i = 2; i < allFields.length; ++i) {
                key = allFields[i];
                if (key != null && key.length() != 0 && selectedFields != null && logInfoTable != null && selectedFields.contains(key)) {
                    value = (String)logInfoTable.get(key);
                    StringBuffer valueBuffer = this.processString(value);
                    escapeDone = false;
                    for (int j = 0; j < valueBuffer.length(); ++j) {
                        if (valueBuffer.charAt(j) != ' ' && valueBuffer.charAt(j) != '\t') continue;
                        sbuffer.append("\"").append(valueBuffer).append("\"\t");
                        stringForMAC.append("\"").append(valueBuffer).append("\"");
                        escapeDone = true;
                        break;
                    }
                    if (escapeDone) continue;
                    sbuffer.append(valueBuffer).append("\t");
                    stringForMAC.append(valueBuffer);
                    continue;
                }
                sbuffer.append("-").append("\t");
                stringForMAC.append("-");
            }
        }
        catch (Exception e) {
            Debug.error("SecureELFFormatter: Exception in String Handling", e);
        }
        String key = "Signature";
        if (logInfoTable.containsKey(key)) {
            sbuffer.append("-\t").append(logInfoTable.get(key));
        } else {
            try {
                Object[] obj = new Object[]{logRecord.getLoggerName()};
                String mac = this.fieldGenerator.generateLogField(stringForMAC.toString(), obj);
                sbuffer.append(mac).append("\t").append("-");
            }
            catch (Exception e) {
                Debug.error("SecureLFFormatter: couldnot generate mac", e);
                sbuffer.append("\"MAC NOT AVAILABLE\"").append("\t").append("-");
            }
        }
        sbuffer.append("\n");
        return sbuffer.toString();
    }

    public String format(java.util.logging.LogRecord logRecord) {
        if (LogManagerUtil.isAMLoggingMode() && logRecord instanceof ILogRecord) {
            return this.format((LogRecord)logRecord);
        }
        StringBuffer sbuffer = new StringBuffer();
        StringBuffer stringForMAC = new StringBuffer();
        try {
            int i;
            String[] allFields = this.lmanager.getAllFields();
            Set selectedFields = this.lmanager.getSelectedFieldSet();
            String strTime = this.secureTimestampGenerator.getTimestamp();
            sbuffer.append("\"").append(strTime).append("\"\t");
            stringForMAC.append("\"").append(strTime).append("\"");
            StringBuffer message = this.processString(this.formatMessage(logRecord));
            boolean escapeDone = false;
            for (i = 0; i < message.length(); ++i) {
                if (message.charAt(i) != ' ' && message.charAt(i) != '\t') continue;
                sbuffer.append("\"").append(message).append("\"\t");
                stringForMAC.append("\"").append(message).append("\"");
                escapeDone = true;
                break;
            }
            if (!escapeDone) {
                sbuffer.append(message).append("\t");
                stringForMAC.append(message);
            }
            for (i = 2; i < allFields.length; ++i) {
                sbuffer.append("-").append("\t");
                stringForMAC.append("-");
            }
        }
        catch (Exception e) {
            Debug.error("SecureELFFormatter: Exception in String Handling", e);
        }
        try {
            Object[] obj = new Object[]{logRecord.getLoggerName()};
            String mac = this.fieldGenerator.generateLogField(stringForMAC.toString(), obj);
            sbuffer.append(mac).append("\t").append("-");
        }
        catch (Exception e) {
            Debug.error("SecureLFFormatter: couldnot generate mac", e);
            sbuffer.append("\"MAC NOT AVAILABLE\"").append("\t").append("-");
        }
        sbuffer.append("\n");
        return sbuffer.toString();
    }

    public String getHead(Handler handler) {
        StringBuffer sbuffer = new StringBuffer();
        sbuffer.append("#Version: 1.0").append("\n");
        sbuffer.append("#Fields: ").append(this.constructHeader()).append("\n");
        return sbuffer.toString();
    }

    public String getTail(Handler handler) {
        return "";
    }

    private String constructHeader() {
        StringBuffer sbuffer = new StringBuffer();
        String[] allFields = this.lmanager.getAllFields();
        for (int i = 0; i < allFields.length; ++i) {
            sbuffer.append(allFields[i]).append("\t");
        }
        sbuffer.append("MAC").append("\t");
        sbuffer.append("Signature");
        return sbuffer.toString();
    }

    private StringBuffer processString(String field) {
        if (field == null || field.length() == 0) {
            return new StringBuffer("Not Available");
        }
        StringBuffer sbuffer = new StringBuffer();
        int len = field.length();
        boolean hasUniqueChar = false;
        for (int i = 0; i < len; ++i) {
            char currentCharacter = field.charAt(i);
            if (currentCharacter == '\"') {
                sbuffer.append("\"\"");
                hasUniqueChar = true;
            }
            if (currentCharacter == '\r') {
                sbuffer.append("\\\\r");
                hasUniqueChar = true;
            }
            if (currentCharacter == '\n') {
                sbuffer.append("\\\\n");
                hasUniqueChar = true;
            }
            if (!hasUniqueChar) {
                sbuffer.append(currentCharacter);
            }
            hasUniqueChar = false;
        }
        return sbuffer;
    }
}

