/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.serverconfig;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.serverconfig.ServerConfigBase;
import com.sun.identity.common.configuration.ConfigurationException;
import com.sun.identity.common.configuration.SiteConfiguration;
import com.sun.identity.sm.SMSException;
import java.text.MessageFormat;
import java.util.logging.Level;

public class SetSitePrimaryURL
extends ServerConfigBase {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String siteName = this.getStringOptionValue("sitename");
        String siteURL = this.getStringOptionValue("siteurl");
        String[] params = new String[]{siteName, siteURL};
        try {
            if (SiteConfiguration.isLegacy(adminSSOToken)) {
                outputWriter.printMessage(this.getResourceString("serverconfig-no-supported"));
                return;
            }
            this.writeLog(0, Level.INFO, "ATTEMPT_SET_SITE_PRIMARY_URL", params);
            if (SiteConfiguration.isSiteExist(adminSSOToken, siteName)) {
                SiteConfiguration.setSitePrimaryURL(adminSSOToken, siteName, siteURL);
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("set-site-primary-url-succeeded"), params));
            } else {
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("set-site-primary-url-no-exists"), params));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_SET_SITE_PRIMARY_URL", params);
        }
        catch (SSOException e) {
            String[] args = new String[]{siteName, siteURL, e.getMessage()};
            this.debugError("SetSitePrimaryURL.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_SET_SITE_PRIMARY_URL", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (ConfigurationException e) {
            String[] args = new String[]{siteName, siteURL, e.getMessage()};
            this.debugError("SetSitePrimaryURL.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_SET_SITE_PRIMARY_URL", args);
            throw new CLIException(e, 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{siteName, siteURL, e.getMessage()};
            this.debugError("SetSitePrimaryURL.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_SET_SITE_PRIMARY_URL", args);
            throw new CLIException(e, 127);
        }
    }
}

