/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.delegation;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.common.CaseInsensitiveHashSet;
import com.sun.identity.delegation.DelegationException;
import com.sun.identity.delegation.DelegationPrivilege;
import com.sun.identity.delegation.DelegationUtils;
import com.sun.identity.delegation.interfaces.DelegationInterface;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.PluginSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class DelegationManager {
    public static final String DELEGATION_SERVICE = "sunAMDelegationService";
    static final String DELEGATION_PLUGIN_INTERFACE = "DelegationInterface";
    static final String PERMISSIONS = "Permissions";
    static final String PRIVILEGES = "Privileges";
    static final String LIST_OF_PERMISSIONS = "listOfPermissions";
    static final String DELEGATION_DEBUG = "amDelegation";
    static final String SUBJECT_ID_TYPES = "SubjectIdTypes";
    public static final Debug debug = Debug.getInstance((String)"amDelegation");
    private static DelegationInterface pluginInstance = null;
    private static Set subjectIdTypes = new CaseInsensitiveHashSet();
    private String orgName;
    private SSOToken token;

    public DelegationManager(SSOToken token, String orgName) throws SSOException, DelegationException {
        SSOTokenManager.getInstance().validateToken(token);
        this.token = token;
        this.orgName = DNMapper.orgNameToDN(orgName);
        if (pluginInstance == null) {
            pluginInstance = DelegationManager.getDelegationPlugin();
        }
    }

    public Set getConfiguredPrivilegeNames() throws DelegationException {
        Set privNames = null;
        Set globalPrivNames = null;
        Set orgPrivNames = null;
        String subConfigName = null;
        int revisionNum = DelegationUtils.getRevisionNumber();
        subConfigName = revisionNum == 10 ? PERMISSIONS : PRIVILEGES;
        try {
            ServiceConfig privsConfig;
            ServiceConfigManager scm = new ServiceConfigManager(DELEGATION_SERVICE, DelegationManager.getAdminToken());
            ServiceConfig sc = scm.getGlobalConfig(null);
            if (sc != null && (privsConfig = sc.getSubConfig(subConfigName)) != null) {
                globalPrivNames = privsConfig.getSubConfigNames();
            }
            try {
                sc = scm.getOrganizationConfig(this.orgName, null);
                if (sc != null && (privsConfig = sc.getSubConfig(subConfigName)) != null) {
                    orgPrivNames = privsConfig.getSubConfigNames();
                }
            }
            catch (SMSException ex) {
                // empty catch block
            }
            if (globalPrivNames != null && !globalPrivNames.isEmpty()) {
                privNames = globalPrivNames;
                if (orgPrivNames != null && !orgPrivNames.isEmpty()) {
                    privNames.addAll(orgPrivNames);
                }
            } else {
                privNames = orgPrivNames;
            }
        }
        catch (Exception e) {
            throw new DelegationException(e);
        }
        return privNames;
    }

    public Set getPrivileges() throws DelegationException {
        if (pluginInstance != null) {
            try {
                return pluginInstance.getPrivileges(this.token, this.orgName);
            }
            catch (SSOException se) {
                throw new DelegationException((Throwable)((Object)se));
            }
        }
        throw new DelegationException(DELEGATION_DEBUG, "no_plugin_specified", null, null);
    }

    public Set getPrivileges(String universalId) throws DelegationException {
        Set privileges = this.getPrivileges();
        if (universalId == null) {
            return privileges;
        }
        HashSet<DelegationPrivilege> applicablePrivileges = new HashSet<DelegationPrivilege>();
        if (privileges != null && !privileges.isEmpty()) {
            AMIdentity identity = null;
            try {
                identity = IdUtils.getIdentity(this.token, universalId);
            }
            catch (IdRepoException idrepo) {
                throw new DelegationException(idrepo.getMessage());
            }
            block4: for (DelegationPrivilege dp : privileges) {
                Set subjs = dp.getSubjects();
                if (subjs == null || subjs.isEmpty()) continue;
                for (String subject : subjs) {
                    try {
                        AMIdentity id = IdUtils.getIdentity(this.token, subject);
                        if (!id.equals(identity)) continue;
                        applicablePrivileges.add(dp);
                        continue block4;
                    }
                    catch (IdRepoException e) {
                    }
                }
            }
        }
        return applicablePrivileges;
    }

    public void addPrivilege(DelegationPrivilege privilege) throws DelegationException {
        DelegationPrivilege dp;
        if (debug.messageEnabled()) {
            debug.message("privilege=" + privilege);
        }
        String name = privilege.getName();
        Set subjects = privilege.getSubjects();
        DelegationManager.validateSupportedSubjectTypes(subjects);
        privilege = dp = new DelegationPrivilege(name, subjects, this.orgName);
        if (pluginInstance != null) {
            try {
                pluginInstance.addPrivilege(this.token, this.orgName, privilege);
            }
            catch (SSOException se) {
                throw new DelegationException((Throwable)((Object)se));
            }
        } else {
            throw new DelegationException(DELEGATION_DEBUG, "no_plugin_specified", null, null);
        }
    }

    public void removePrivilege(String privilegeName) throws DelegationException {
        if (pluginInstance != null) {
            try {
                pluginInstance.removePrivilege(this.token, this.orgName, privilegeName);
            }
            catch (SSOException se) {
                throw new DelegationException((Throwable)((Object)se));
            }
        } else {
            throw new DelegationException(DELEGATION_DEBUG, "no_plugin_specified", null, null);
        }
    }

    public Set getSubjects(String pattern) throws DelegationException {
        if (pluginInstance != null) {
            try {
                return pluginInstance.getSubjects(this.token, this.orgName, subjectIdTypes, pattern);
            }
            catch (SSOException se) {
                throw new DelegationException((Throwable)((Object)se));
            }
        }
        throw new DelegationException(DELEGATION_DEBUG, "no_plugin_specified", null, null);
    }

    public Set getManageableOrganizationNames(Set organizationNames) throws DelegationException {
        if (pluginInstance != null) {
            try {
                return pluginInstance.getManageableOrganizationNames(this.token, organizationNames);
            }
            catch (SSOException se) {
                throw new DelegationException((Throwable)((Object)se));
            }
        }
        throw new DelegationException(DELEGATION_DEBUG, "no_plugin_specified", null, null);
    }

    static DelegationInterface getDelegationPlugin() throws DelegationException {
        if (pluginInstance != null) {
            return pluginInstance;
        }
        return DelegationManager.loadDelegationPlugin();
    }

    static synchronized DelegationInterface loadDelegationPlugin() throws DelegationException {
        block11: {
            if (pluginInstance == null) {
                try {
                    Iterator it;
                    Set pluginNames;
                    Map attributeDefaults;
                    SSOToken privilegedToken = DelegationManager.getAdminToken();
                    ServiceSchemaManager ssm = new ServiceSchemaManager(DELEGATION_SERVICE, privilegedToken);
                    ServiceSchema globalSchema = ssm.getGlobalSchema();
                    if (globalSchema != null && (attributeDefaults = globalSchema.getAttributeDefaults()) != null) {
                        subjectIdTypes.addAll((Set)attributeDefaults.get(SUBJECT_ID_TYPES));
                    }
                    if (debug.messageEnabled()) {
                        debug.message("Configured Subject ID Types: " + subjectIdTypes);
                    }
                    if ((pluginNames = ssm.getPluginSchemaNames(DELEGATION_PLUGIN_INTERFACE, null)) == null) {
                        throw new DelegationException(DELEGATION_DEBUG, "no_plugin_specified", null, null);
                    }
                    if (debug.messageEnabled()) {
                        debug.message("pluginNames=" + pluginNames);
                    }
                    if ((it = pluginNames.iterator()).hasNext()) {
                        String pluginName = (String)it.next();
                        PluginSchema ps = ssm.getPluginSchema(pluginName, DELEGATION_PLUGIN_INTERFACE, null);
                        if (ps == null) {
                            throw new DelegationException(DELEGATION_DEBUG, "no_plugin_specified", null, null);
                        }
                        String className = ps.getClassName();
                        if (debug.messageEnabled()) {
                            debug.message("Plugin class name:" + className);
                        }
                        pluginInstance = (DelegationInterface)Class.forName(className).newInstance();
                        pluginInstance.initialize(privilegedToken, null);
                        if (debug.messageEnabled()) {
                            debug.message("Successfully created a delegation plugin instance");
                        }
                        break block11;
                    }
                    throw new DelegationException(DELEGATION_DEBUG, "no_plugin_specified", null, null);
                }
                catch (Exception e) {
                    debug.error("Unable to get an instance of plugin for delegation", (Throwable)e);
                    pluginInstance = null;
                    throw new DelegationException(e);
                }
            }
        }
        return pluginInstance;
    }

    private static void validateSupportedSubjectTypes(Set subjects) throws DelegationException {
        if (subjects != null && !subjects.isEmpty()) {
            try {
                SSOToken adminToken = DelegationManager.getAdminToken();
                for (String uuid : subjects) {
                    AMIdentity amid = IdUtils.getIdentity(adminToken, uuid);
                    if (subjectIdTypes.contains(amid.getType().getName())) continue;
                    throw new DelegationException(DELEGATION_DEBUG, "un_supported_subject_type", null, null);
                }
            }
            catch (SSOException e) {
                throw new DelegationException((Throwable)((Object)e));
            }
            catch (IdRepoException e) {
                throw new DelegationException(e);
            }
        }
    }

    static SSOToken getAdminToken() throws SSOException {
        SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        if (adminToken == null) {
            throw new SSOException(new DelegationException(DELEGATION_DEBUG, "getting_admin_token_failed", null, null));
        }
        return adminToken;
    }
}

