/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm.flatfile;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.CaseInsensitiveHashSet;
import com.sun.identity.common.CaseInsensitiveProperties;
import com.sun.identity.common.CaseInsensitiveTreeSet;
import com.sun.identity.common.ReaderWriterLock;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSObjectDB;
import com.sun.identity.sm.SMSObjectListener;
import com.sun.identity.sm.ServiceNotFoundException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.AbstractSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.ModificationItem;

public abstract class SMSFlatFileObjectBase
extends SMSObjectDB {
    protected String mRootDir = null;
    protected File mRootDirHandle = null;
    protected String mRootDN = null;
    protected boolean mInitialized = false;
    protected Debug mDebug = null;
    protected ReaderWriterLock mRWLock = new ReaderWriterLock();
    static final String SMS_FLATFILE_ROOTDIR_PROPERTY = "com.sun.identity.sm.flatfile.root_dir";
    static final String DEFAULT_ROOT_DIR = "/var/opt/SUNWam/sms";

    private void init() throws SMSException {
        this.getBaseDirectory();
        this.loadMapper();
    }

    private void getBaseDirectory() throws SMSException {
        this.mRootDir = SystemProperties.get(SMS_FLATFILE_ROOTDIR_PROPERTY, DEFAULT_ROOT_DIR);
        this.mRootDN = this.getRootSuffix();
        this.mRootDirHandle = new File(this.mRootDir);
        if (this.mRootDirHandle.isDirectory()) {
            if (!this.mRootDirHandle.canRead() || !this.mRootDirHandle.canWrite()) {
                String errmsg = "SMSFlatFileObject.initialize: cannot read or write to the root directory." + this.mRootDir;
                this.mDebug.error(errmsg);
                throw new SMSException(errmsg);
            }
            if (this.mDebug.messageEnabled()) {
                this.mDebug.message("SMSFlatFileObject: Root Directory: " + this.mRootDir);
            }
        } else {
            if (!this.mRootDirHandle.mkdirs()) {
                String errmsg = "SMSFlatFileObject.initialize: Cannot create the root directory." + this.mRootDir;
                this.mDebug.error(errmsg);
                throw new SMSException(errmsg);
            }
            if (this.mDebug.messageEnabled()) {
                this.mDebug.message("SMSFlatFileObject: Created root directory: " + this.mRootDir);
            }
        }
    }

    protected Properties loadProperties(File filehandle, String objName) throws SMSException {
        FileInputStream fileistr = null;
        try {
            fileistr = new FileInputStream(filehandle);
            CaseInsensitiveProperties props = new CaseInsensitiveProperties();
            props.load(fileistr);
            CaseInsensitiveProperties caseInsensitiveProperties = props;
            return caseInsensitiveProperties;
        }
        catch (FileNotFoundException e) {
            String errmsg = "SMSFlatFileObject.loadProperties: " + objName + " File, " + filehandle.getPath() + e.getMessage();
            this.mDebug.error("SMSFlatFileObject.loadProperties", (Throwable)e);
            throw new ServiceNotFoundException(errmsg);
        }
        catch (IOException e) {
            String errmsg = "SMSFlatFileObject.loadProperties: " + objName + " File, " + filehandle.getPath() + e.getMessage();
            this.mDebug.error("SMSFlatFileObject.loadProperties", (Throwable)e);
            throw new ServiceNotFoundException(errmsg);
        }
        catch (IllegalArgumentException e) {
            String errmsg = "SMSFlatFileObject.loadProperties: " + objName + " File, " + filehandle.getPath() + e.getMessage();
            this.mDebug.error("SMSFlatFileObject.loadProperties", (Throwable)e);
            throw new ServiceNotFoundException(errmsg);
        }
        finally {
            if (fileistr != null) {
                try {
                    fileistr.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected void saveProperties(Properties props, File filehandle, String header) throws SMSException {
        FileOutputStream fileostr = null;
        try {
            fileostr = new FileOutputStream(filehandle);
            props.store(fileostr, header);
        }
        catch (FileNotFoundException e) {
            String errmsg = "SMSFlatFileObjectBase.saveProperties: " + (header == null ? "" : header + ": ") + " File, " + filehandle.getPath() + ". Exception: " + e.getMessage();
            this.mDebug.error("SMSFlatFileObjectBase.saveProperties", (Throwable)e);
            throw new ServiceNotFoundException(errmsg);
        }
        catch (IOException e) {
            String errmsg = "SMSFlatFileObjectBase.saveProperties: " + (header == null ? "" : header + ": ") + " File, " + filehandle.getPath() + ". Exception: " + e.getMessage();
            this.mDebug.error("SMSFlatFileObjectBase.saveProperties", (Throwable)e);
            throw new ServiceNotFoundException(errmsg);
        }
        finally {
            try {
                fileostr.close();
            }
            catch (IOException e) {}
        }
    }

    protected String toValString(Set vals) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (String val : vals) {
            val = this.encodeVal(val);
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(val);
        }
        return sb.toString();
    }

    protected void modifyValues(String objName, ModificationItem modItem, Properties props) {
        Attribute attr = modItem.getAttribute();
        String key = attr.getID();
        try {
            int op = modItem.getModificationOp();
            switch (op) {
                case 1: {
                    Set values = this.toValSet(key, (String)props.get(key));
                    NamingEnumeration<?> e = attr.getAll();
                    while (e.hasMoreElements()) {
                        values.add(e.nextElement());
                    }
                    props.put(key, this.toValString(values));
                    break;
                }
                case 3: {
                    Set val = this.toValSet(key, (String)props.get(key));
                    NamingEnumeration<?> e = attr.getAll();
                    while (e.hasMoreElements()) {
                        val.remove(e.nextElement());
                    }
                    props.put(key, this.toValString(val));
                    break;
                }
                case 2: {
                    props.put(key, this.toValString(attr.getAll()));
                }
            }
        }
        catch (NamingException e) {
            this.mDebug.error("SMSFlatFileObjectBase.modifyValues", (Throwable)e);
            throw new IllegalArgumentException("SMSFlatFileObjectBase.modifyValues: " + objName + ": Error modifying attributes: " + e.getMessage());
        }
    }

    protected String toValString(Enumeration en) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        while (en.hasMoreElements()) {
            String val = (String)en.nextElement();
            val = this.encodeVal(val);
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(val);
        }
        return sb.toString();
    }

    protected String encodeVal(String v) {
        char[] chars = v.toCharArray();
        StringBuffer sb = new StringBuffer(chars.length + 20);
        int i = 0;
        int lastIdx = 0;
        for (i = 0; i < chars.length; ++i) {
            if (chars[i] == '%') {
                if (lastIdx != i) {
                    sb.append(chars, lastIdx, i - lastIdx);
                }
                sb.append("%25");
                lastIdx = i + 1;
                continue;
            }
            if (chars[i] != ',') continue;
            if (lastIdx != i) {
                sb.append(chars, lastIdx, i - lastIdx);
            }
            sb.append("%2C");
            lastIdx = i + 1;
        }
        if (lastIdx != i) {
            sb.append(chars, lastIdx, i - lastIdx);
        }
        return sb.toString();
    }

    protected Set toValSet(String attrName, String vals) {
        HashSet<String> valset;
        HashSet<String> hashSet = valset = SMSEntry.isAttributeCaseSensitive(attrName) ? new HashSet<String>() : new CaseInsensitiveHashSet();
        if (vals != null && vals.length() > 0) {
            int j;
            char[] valchars = vals.toCharArray();
            int i = 0;
            for (j = 0; j < valchars.length; ++j) {
                char c = valchars[j];
                if (c != ',') continue;
                if (i == j) {
                    i = j + 1;
                    continue;
                }
                String val = new String(valchars, i, j - i).trim();
                if (val.length() > 0) {
                    val = this.decodeVal(val);
                }
                valset.add(val);
                i = j + 1;
            }
            if (j == valchars.length && i < j) {
                String val = new String(valchars, i, j - i).trim();
                if (val.length() > 0) {
                    val = this.decodeVal(val);
                }
                valset.add(val);
            }
        }
        return valset;
    }

    protected String decodeVal(String v) {
        char[] chars = v.toCharArray();
        StringBuffer sb = new StringBuffer(chars.length);
        int i = 0;
        int lastIdx = 0;
        for (i = 0; i < chars.length; ++i) {
            if (chars[i] != '%' || i + 2 >= chars.length || chars[i + 1] != '2') continue;
            if (lastIdx != i) {
                sb.append(chars, lastIdx, i - lastIdx);
            }
            if (chars[i + 2] == 'C') {
                sb.append(',');
            } else if (chars[i + 2] == '5') {
                sb.append('%');
            } else {
                sb.append(chars, i, 3);
            }
            lastIdx = (i += 2) + 1;
        }
        if (lastIdx != i) {
            sb.append(chars, lastIdx, i - lastIdx);
        }
        return sb.toString();
    }

    private Set getSubEntries(String objName, String filter, String sidFilter, int numOfEntries, boolean sortResults, boolean ascendingOrder) throws SMSException {
        return this.getSubEntries(objName, "ou=" + filter, sidFilter, true, numOfEntries, sortResults, ascendingOrder);
    }

    protected SMSFlatFileObjectBase() throws SMSException {
    }

    protected synchronized void initialize() throws SMSException {
        if (!this.mInitialized) {
            this.mDebug = Debug.getInstance((String)"amSMSFlatFiles");
            this.init();
            this.mInitialized = true;
        }
    }

    public Set subEntries(SSOToken token, String objName, String filter, int numOfEntries, boolean sortResults, boolean ascendingOrder) throws SMSException, SSOException {
        if (objName == null || objName.length() == 0 || filter == null || filter.length() == 0 || numOfEntries < 0) {
            throw new IllegalArgumentException("SMSFlatFileObject.subEntries(): One or more arguments is null or empty: objName [" + objName == null ? "null" : (objName + "] filter ]" + filter == null ? "null" : filter + "]"));
        }
        Set subentries = null;
        try {
            subentries = this.getSubEntries(objName, filter, null, numOfEntries, sortResults, ascendingOrder);
        }
        catch (ServiceNotFoundException e) {
            subentries = new CaseInsensitiveHashSet();
        }
        if (this.mDebug.messageEnabled()) {
            this.mDebug.message("SMSFlatFileObject: SubEntries search " + filter + " for " + objName + " returned " + subentries.size() + " items");
        }
        return subentries;
    }

    public Set schemaSubEntries(SSOToken token, String objName, String filter, String sidFilter, int numOfEntries, boolean sortResults, boolean ascendingOrder) throws SMSException, SSOException {
        if (objName == null || objName.length() == 0 || filter == null || filter.length() == 0 || sidFilter == null || sidFilter.length() == 0) {
            throw new IllegalArgumentException("SMSFlatFileObject.schemaSubEntries: One or more arguments is null or empty.");
        }
        Set subentries = null;
        try {
            subentries = this.getSubEntries(objName, filter, sidFilter, numOfEntries, sortResults, ascendingOrder);
        }
        catch (ServiceNotFoundException e) {
            subentries = new CaseInsensitiveHashSet();
        }
        if (this.mDebug.messageEnabled()) {
            this.mDebug.message("SMSFlatFileObject: SchemaSubEntries search " + filter + " for " + objName + " returned " + subentries.size() + " items");
        }
        return subentries;
    }

    public Iterator search(SSOToken token, String objName, String filter, Set excludes) throws SSOException, SMSException {
        return null;
    }

    public Set search(SSOToken token, String objName, String filter) throws SSOException, SMSException {
        if (objName == null || objName.length() == 0 || filter == null || filter.length() == 0) {
            throw new IllegalArgumentException("SMSFlatFileObject.search: One or more arguments is null or empty.");
        }
        try {
            String filterPattern = SMSEntry.getFilterPatternService();
            MessageFormat format = new MessageFormat(filterPattern);
            Object[] args = format.parse(filter);
            if (args.length != 2 || !(args[0] instanceof String) || !(args[1] instanceof String)) {
                throw new IllegalArgumentException("SMSFlatFile.search: Error parsing filter pattern " + filter);
            }
            String serviceName = (String)args[0];
            String sunservice = (String)args[1];
            String theObjName = "ou=" + serviceName + ",ou=services," + this.mRootDN;
            Set subentries = null;
            subentries = this.getSubEntries(theObjName, "*", "ou=" + sunservice, 0, false, false);
            return subentries;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("SMSFlatFileObject.search: Unexpected filter pattern " + filter);
        }
    }

    public Set searchSubOrgNames(SSOToken token, String objName, String filter, int numOfEntries, boolean sortResults, boolean ascendingOrder, boolean recursive) throws SMSException, SSOException {
        return this.searchOrgs(token, objName, filter, numOfEntries, sortResults, ascendingOrder, recursive, null, null, null);
    }

    public Set searchOrganizationNames(SSOToken token, String objName, int numOfEntries, boolean sortResults, boolean ascendingOrder, String serviceName, String attrName, Set values) throws SMSException, SSOException {
        int index = objName.indexOf(44);
        if (index != -1) {
            objName = objName.substring(index + 1);
        }
        return this.searchOrgs(token, objName, "*", numOfEntries, sortResults, ascendingOrder, true, serviceName, attrName, values);
    }

    private Set searchOrgs(SSOToken token, String objName, String filter, int numOfEntries, boolean sortResults, boolean ascendingOrder, boolean recursive, String serviceName, String attrName, Set values) throws SMSException, SSOException {
        AbstractSet subentries;
        block12: {
            if (objName == null || objName.length() == 0 || filter == null || filter.length() == 0 || numOfEntries < 0) {
                throw new IllegalArgumentException("SMSFlatFileObject.searchOrganizationNames(): One or more arguments is null or empty: objName [" + objName == null ? "null" : (objName + "] filter ]" + filter == null ? "null" : filter + "]"));
            }
            String fPrefix = "o=";
            String sidFilter = null;
            if (serviceName != null && attrName != null && values != null && !values.isEmpty()) {
                sidFilter = serviceName + "-" + attrName + "=" + values.iterator().next();
                if (objName.equalsIgnoreCase(this.mRootDN)) {
                    fPrefix = "ou=";
                }
            }
            subentries = null;
            subentries = sortResults ? new CaseInsensitiveTreeSet(ascendingOrder) : new CaseInsensitiveHashSet();
            try {
                Set entries = this.getSubEntries(objName, fPrefix + filter, sidFilter, false, numOfEntries, sortResults, ascendingOrder);
                for (String suborg : entries) {
                    subentries.add(fPrefix + suborg + "," + objName);
                }
                if (!recursive) break block12;
                HashSet<String> subOrgs = new HashSet<String>();
                if (!filter.equals("*") || sidFilter != null) {
                    Set ssubOrgs = this.getSubEntries(objName, fPrefix + "*", null, false, 0, sortResults, ascendingOrder);
                    for (String suborg : ssubOrgs) {
                        subOrgs.add(fPrefix + suborg + "," + objName);
                    }
                } else {
                    subOrgs.addAll(subentries);
                }
                for (String subOrgName : subOrgs) {
                    int reqEntries;
                    int n = reqEntries = numOfEntries == 0 ? numOfEntries : numOfEntries - subentries.size();
                    if (numOfEntries >= 0) {
                        Set subsubentries = this.searchOrgs(token, subOrgName, filter, reqEntries, sortResults, ascendingOrder, recursive, serviceName, attrName, values);
                        subentries.addAll(subsubentries);
                        continue;
                    }
                    break;
                }
            }
            catch (ServiceNotFoundException e) {
                subentries = new CaseInsensitiveHashSet();
            }
        }
        if (this.mDebug.messageEnabled()) {
            this.mDebug.message("SMSFlatFileObject:searchOrgs search " + filter + " for " + objName + " returned " + subentries.size() + " items");
        }
        return subentries;
    }

    public String registerCallbackHandler(SSOToken token, SMSObjectListener changeListener) throws SMSException, SSOException {
        return null;
    }

    public void deregisterCallbackHandler(String id) {
    }

    abstract void loadMapper() throws SMSException;

    protected abstract Set getSubEntries(String var1, String var2, String var3, boolean var4, int var5, boolean var6, boolean var7) throws SMSException;
}

