/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement;

import com.sun.identity.entitlement.Application;
import com.sun.identity.entitlement.ApplicationManager;
import com.sun.identity.entitlement.Entitlement;
import com.sun.identity.entitlement.interfaces.ResourceName;
import com.sun.identity.policy.ResourceMatch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EntitlementCombiner {
    private String resourceName;
    private Set<String> actions;
    private boolean isDone;
    private boolean isRecursive;
    private List<Entitlement> results = new ArrayList<Entitlement>();
    private ResourceName resourceComparator;
    private Entitlement rootE;

    public void init(Subject adminSubject, String realm, String applicationName, String resourceName, Set<String> actions, boolean isRecursive) {
        this.resourceName = resourceName;
        this.isRecursive = isRecursive;
        this.actions = new HashSet<String>();
        Application application = ApplicationManager.getApplication(adminSubject, realm, applicationName);
        this.rootE = new Entitlement(applicationName, resourceName, (Map<String, Boolean>)Collections.EMPTY_MAP);
        this.resourceComparator = application.getResourceComparator();
        if (!isRecursive) {
            if (actions != null && !actions.isEmpty()) {
                this.actions.addAll(actions);
            } else {
                this.actions.addAll(application.getActions().keySet());
            }
        } else {
            this.actions.addAll(application.getActions().keySet());
        }
        this.results.add(this.rootE);
    }

    public void add(List<Entitlement> entitlements) {
        if (!this.isRecursive) {
            for (Entitlement e : entitlements) {
                this.mergeActionValues(this.rootE, e);
                this.mergeAdvices(this.rootE, e);
                this.mergeAttributes(this.rootE, e);
            }
        } else {
            for (Entitlement e : entitlements) {
                boolean toAdd = true;
                for (Entitlement existing : this.results) {
                    ResourceMatch match = this.resourceComparator.compare(e.getResourceName(), existing.getResourceName(), true);
                    if (match.equals(ResourceMatch.EXACT_MATCH)) {
                        this.mergeActionValues(existing, e);
                        this.mergeAdvices(existing, e);
                        this.mergeAttributes(existing, e);
                        toAdd = false;
                        continue;
                    }
                    if (match.equals(ResourceMatch.SUB_RESOURCE_MATCH)) {
                        this.mergeActionValues(existing, e);
                        this.mergeAdvices(existing, e);
                        this.mergeAttributes(existing, e);
                        continue;
                    }
                    if (!match.equals(ResourceMatch.SUPER_RESOURCE_MATCH) && !match.equals(ResourceMatch.WILDCARD_MATCH)) continue;
                    this.mergeActionValues(e, existing);
                    this.mergeAdvices(e, existing);
                    this.mergeAttributes(e, existing);
                }
                if (!toAdd) continue;
                Entitlement tmp = new Entitlement(e.getApplicationName(), e.getResourceName(), e.getActionValues());
                tmp.setAttributes(e.getAttributes());
                tmp.setAdvices(e.getAdvices());
                this.results.add(tmp);
            }
        }
    }

    protected void mergeActionValues(Entitlement e1, Entitlement e2) {
        Map a2;
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        Map a1 = e1.getActionValues();
        if (a1 == null) {
            a1 = Collections.EMPTY_MAP;
        }
        if ((a2 = e2.getActionValues()) == null) {
            a2 = Collections.EMPTY_MAP;
        }
        HashSet actionNames = new HashSet();
        actionNames.addAll(a1.keySet());
        actionNames.addAll(a2.keySet());
        for (String n : actionNames) {
            Boolean b1 = (Boolean)a1.get(n);
            Boolean b2 = (Boolean)a2.get(n);
            if (b1 == null) {
                result.put(n, b2);
                continue;
            }
            if (b2 == null) {
                result.put(n, b1);
                continue;
            }
            Boolean b = this.combine(b1, b2);
            result.put(n, b);
        }
        e1.setActionValues(result);
        this.isDone = this.isCompleted();
    }

    protected void mergeAdvices(Entitlement e1, Entitlement e2) {
        Map a2;
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        Map a1 = e1.getAdvices();
        if (a1 == null) {
            a1 = Collections.EMPTY_MAP;
        }
        if ((a2 = e2.getAdvices()) == null) {
            a2 = Collections.EMPTY_MAP;
        }
        HashSet names = new HashSet();
        names.addAll(a1.keySet());
        names.addAll(a2.keySet());
        for (String n : names) {
            Set advice1 = (Set)a1.get(n);
            Set advice2 = (Set)a2.get(n);
            HashSet r = (HashSet)result.get(n);
            if (r == null) {
                r = new HashSet();
                result.put(n, r);
            }
            if (advice1 != null && !advice1.isEmpty()) {
                r.addAll(advice1);
            }
            if (advice2 == null || advice2.isEmpty()) continue;
            r.addAll(advice2);
        }
        e1.setAdvices(result);
    }

    protected void mergeAttributes(Entitlement e1, Entitlement e2) {
        Map a2;
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        Map a1 = e1.getAttributes();
        if (a1 == null) {
            a1 = Collections.EMPTY_MAP;
        }
        if ((a2 = e2.getAttributes()) == null) {
            a2 = Collections.EMPTY_MAP;
        }
        HashSet names = new HashSet();
        names.addAll(a1.keySet());
        names.addAll(a2.keySet());
        for (String n : names) {
            Set attr1 = (Set)a1.get(n);
            Set attr2 = (Set)a2.get(n);
            HashSet r = (HashSet)result.get(n);
            if (r == null) {
                r = new HashSet();
                result.put(n, r);
            }
            if (attr1 != null && !attr1.isEmpty()) {
                r.addAll(attr1);
            }
            if (attr2 == null || attr2.isEmpty()) continue;
            r.addAll(attr2);
        }
        e1.setAttributes(result);
    }

    protected Set<String> getActions() {
        return this.actions;
    }

    protected boolean isRecursive() {
        return this.isRecursive;
    }

    protected Entitlement getRootE() {
        return this.rootE;
    }

    protected ResourceName getResourceComparator() {
        return this.resourceComparator;
    }

    public boolean isDone() {
        return this.isDone;
    }

    public List<Entitlement> getResults() {
        return this.results;
    }

    protected abstract boolean combine(Boolean var1, Boolean var2);

    protected abstract boolean isCompleted();
}

