/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.cli;

import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cot.COTException;
import com.sun.identity.cot.CircleOfTrustManager;
import java.text.MessageFormat;
import java.util.Set;
import java.util.logging.Level;

public class ListCircleOfTrusts
extends AuthenticatedCommand {
    private String realm;

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        this.superAdminUserValidation();
        this.realm = this.getStringOptionValue("realm", "/");
        IOutput outputWriter = this.getOutputWriter();
        String[] params = new String[]{this.realm};
        this.writeLog(0, Level.INFO, "ATTEMPT_LIST_COTS", params);
        try {
            CircleOfTrustManager cotManager = new CircleOfTrustManager();
            Set members = cotManager.getAllCirclesOfTrust(this.realm);
            if (members == null || members.isEmpty()) {
                Object[] obj = new Object[]{this.realm};
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("list-circles-of-trust-no-members"), obj));
            } else {
                Object[] obj = new Object[]{this.realm};
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("list-circles-of-trust-members"), obj));
                for (String cot : members) {
                    outputWriter.printlnMessage("  " + cot);
                }
            }
            this.writeLog(0, Level.INFO, "SUCCEEDED_LIST_COTS", params);
        }
        catch (COTException e) {
            this.debugWarning("ListCircleOfTrusts.handleRequest", e);
            String[] args = new String[]{this.realm, e.getMessage()};
            this.writeLog(1, Level.INFO, "FAILED_LIST_COTS", args);
            throw new CLIException(e.getMessage(), 127);
        }
    }
}

