/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.idpp.plugin;

import com.iplanet.sso.SSOToken;
import com.sun.identity.liberty.ws.interfaces.Authorizer;
import com.sun.identity.policy.ActionDecision;
import com.sun.identity.policy.PolicyDecision;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.Locale;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class IDPPAuthorizer
implements Authorizer {
    private static ResourceBundle bundle = Locale.getInstallResourceBundle((String)"fmPersonalProfile");
    private static Debug debug = Debug.getInstance((String)"libIDWSF");
    private static PolicyEvaluator evaluator = null;

    public boolean isAuthorized(Object credential, String action, Object data, Map env) {
        return false;
    }

    public Object getAuthorizationDecision(Object credential, String action, Object data, Map env) throws Exception {
        debug.message("IDPPAuthorizer.getAuthorizationDecision:Init");
        if (credential == null || action == null || data == null) {
            debug.error("IDPPAuthorizer.isAuthorized:null input");
            throw new Exception(bundle.getString("nullInputParams"));
        }
        try {
            PolicyDecision policyDecision;
            SSOToken token = (SSOToken)credential;
            String resource = (String)data;
            HashSet<String> actions = new HashSet<String>(1);
            actions.add(action);
            HashMap<String, HashSet<String>> map = null;
            String userid = (String)env.get("userID");
            if (debug.messageEnabled()) {
                debug.message("IDPPAuthorizer.getAuthorizationDecision: uid=" + userid);
            }
            if (userid != null && userid.length() != 0) {
                HashSet<String> set = new HashSet<String>();
                set.add(userid);
                map = new HashMap<String, HashSet<String>>();
                map.put("invocatorPrincipalUuid", set);
            }
            if ((policyDecision = evaluator.getPolicyDecision(token, resource, actions, map)) == null) {
                if (debug.messageEnabled()) {
                    debug.message("IDPPAuthorizer.getAuthorizationDecision:PolicyDecision is null");
                }
                return "deny";
            }
            Map actionDecisions = policyDecision.getActionDecisions();
            ActionDecision actionDecision = (ActionDecision)actionDecisions.get(action);
            if (actionDecision == null) {
                if (debug.messageEnabled()) {
                    debug.message("IDPPAuthorizer.getAuthorizationDecision:ActionDecision is null");
                }
                return "deny";
            }
            Set values = actionDecision.getValues();
            if (values == null || values.isEmpty()) {
                if (debug.messageEnabled()) {
                    debug.message("IDPPAuthorizer.getAuthorizationDecision:values are null");
                }
                return "deny";
            }
            if (debug.messageEnabled()) {
                debug.message("IDPPAuthorizer.getAuthorizationDecision: action values:" + values);
            }
            if (values.contains("deny")) {
                return "deny";
            }
            if (values.contains("interactForValue")) {
                return "interactForValue";
            }
            if (values.contains("interactForConsent")) {
                return "interactForConsent";
            }
            Iterator iter = values.iterator();
            return (String)iter.next();
        }
        catch (Exception ex) {
            debug.error("IDPPAuthorizer.getAuthorizationDecision:Exception during authorization.", (Throwable)ex);
            throw ex;
        }
    }

    static {
        try {
            evaluator = new PolicyEvaluator("sunIdentityServerLibertyPPService");
        }
        catch (Exception ex) {
            debug.error("IDPPAuthorizer:Static Init failed", (Throwable)ex);
        }
    }
}

