/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.server;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.services.comm.client.PLLClient;
import com.iplanet.services.comm.server.RequestHandler;
import com.iplanet.services.comm.share.Request;
import com.iplanet.services.comm.share.RequestSet;
import com.iplanet.services.comm.share.Response;
import com.iplanet.services.comm.share.ResponseSet;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.client.AuthClientUtils;
import com.sun.identity.authentication.jaas.LoginContext;
import com.sun.identity.authentication.server.AuthContextLocal;
import com.sun.identity.authentication.server.AuthXMLRequest;
import com.sun.identity.authentication.server.AuthXMLResponse;
import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.authentication.service.AuthException;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.authentication.service.LoginState;
import com.sun.identity.authentication.spi.AMPostAuthProcessInterface;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.X509CertificateCallback;
import com.sun.identity.common.ISLocaleContext;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.AMResourceBundleCache;
import com.sun.identity.shared.locale.L10NMessage;
import com.sun.identity.shared.locale.Locale;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthXMLHandler
implements RequestHandler {
    private String localAuthServerProtocol = SystemProperties.get("com.iplanet.am.server.protocol");
    private String localAuthServer = SystemProperties.get("com.iplanet.am.server.host");
    private String localAuthServerPort = SystemProperties.get("com.iplanet.am.server.port");
    private java.util.Locale locale;
    static Debug debug;
    private static String serviceURI;
    private static boolean messageEnabled;
    private boolean security = false;

    public AuthXMLHandler() {
        AuthContext.localAuthServiceID = this.localAuthServerProtocol + "://" + this.localAuthServer + ":" + this.localAuthServerPort;
        this.locale = new ISLocaleContext().getLocale();
    }

    public ResponseSet process(Vector requests, HttpServletRequest servletRequest, HttpServletResponse servletResponse, ServletContext servletContext) {
        ResponseSet rset = new ResponseSet("auth");
        for (int i = 0; i < requests.size(); ++i) {
            Request req = (Request)requests.elementAt(i);
            Response res = this.processRequest(req, servletRequest, servletResponse);
            rset.addResponse(res);
        }
        return rset;
    }

    private Response processRequest(Request req, HttpServletRequest servletReq, HttpServletResponse servletRes) {
        debug.message("=======================Entering processRequest");
        servletReq.getSession(true);
        String content = req.getContent();
        AuthXMLResponse authResponse = null;
        String cookieURL = null;
        int index = content.indexOf("authIdentifier");
        if (index != -1) {
            int beginIndex = content.indexOf(34, index);
            int endIndex = content.indexOf(34, beginIndex + 1);
            String authIdentifier = content.substring(beginIndex + 1, endIndex);
            if (debug.messageEnabled()) {
                debug.message("authIdentifier = " + authIdentifier + "beginIndex = " + beginIndex + "endIndex =" + endIndex);
            }
            if (!authIdentifier.equals("0")) {
                try {
                    SessionID sessionID = new SessionID(authIdentifier);
                    URL sessionServerURL = Session.getSessionServiceURL(sessionID);
                    StringBuffer srtBuff = new StringBuffer(100);
                    srtBuff.append(sessionServerURL.getProtocol()).append("://").append(sessionServerURL.getHost()).append(":").append(Integer.toString(sessionServerURL.getPort())).append(serviceURI);
                    cookieURL = srtBuff.toString();
                }
                catch (Exception exp) {
                    debug.error("Error in getting URL from session", (Throwable)exp);
                    cookieURL = null;
                }
            }
        }
        if (cookieURL != null && cookieURL.trim().length() != 0 && !AuthUtils.isLocalServer(cookieURL, serviceURI)) {
            HashMap cookieTable = new HashMap();
            HashMap headers = new HashMap();
            Enumeration headerNames = servletReq.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                ArrayList headerValues = new ArrayList();
                Enumeration enum1 = servletReq.getHeaders(headerName);
                while (enum1.hasMoreElements()) {
                    headerValues.add(enum1.nextElement());
                }
                headers.put(headerName, headerValues);
            }
            if (debug.messageEnabled()) {
                debug.message("Headers: " + headers);
            }
            PLLClient.parseCookies(headers, cookieTable);
            if (debug.messageEnabled()) {
                debug.message("Cookies: " + cookieTable);
            }
            RequestSet set = new RequestSet("auth");
            set.addRequest(req);
            try {
                Vector responses = PLLClient.send(new URL(cookieURL), set, cookieTable);
                if (!responses.isEmpty()) {
                    debug.message("=====================Returning redirected");
                    return (Response)responses.elementAt(0);
                }
            }
            catch (Exception e) {
                debug.error("Error in misrouted ", (Throwable)e);
                authResponse = new AuthXMLResponse(0);
                this.setErrorCode(authResponse, e);
                return new Response(authResponse.toXMLString());
            }
        }
        try {
            AuthXMLRequest sreq = AuthXMLRequest.parseXML(content, servletReq);
            sreq.setHttpServletRequest(servletReq);
            authResponse = this.processAuthXMLRequest(sreq, servletReq, servletRes);
        }
        catch (AuthException e) {
            debug.error("Got Auth Exception", (Throwable)((Object)e));
            authResponse = new AuthXMLResponse(0);
            authResponse.setErrorCode(e.getErrorCode());
        }
        catch (Exception ex) {
            debug.error("Error while processing xml request", (Throwable)ex);
            authResponse = new AuthXMLResponse(0);
            this.setErrorCode(authResponse, ex);
        }
        debug.message("=======================Returning");
        return new Response(authResponse.toXMLString());
    }

    /*
     * Unable to fully structure code
     */
    private AuthXMLResponse processAuthXMLRequest(AuthXMLRequest authXMLRequest, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        if (AuthXMLHandler.messageEnabled) {
            AuthXMLHandler.debug.message("authXMLRequest is : " + authXMLRequest);
        }
        requestType = authXMLRequest.getRequestType();
        sessionID = authXMLRequest.getAuthIdentifier();
        orgName = authXMLRequest.getOrgName();
        authContext = authXMLRequest.getAuthContext();
        loginState = AuthUtils.getLoginState(authContext);
        params = authXMLRequest.getParams();
        envList = authXMLRequest.getEnvironment();
        envMap = this.toEnvMap(envList);
        authResponse = new AuthXMLResponse(requestType);
        authResponse.setAuthContext(authContext);
        authResponse.setAuthIdentifier(sessionID);
        if (AuthXMLHandler.messageEnabled) {
            AuthXMLHandler.debug.message("authContext is : " + authContext);
            AuthXMLHandler.debug.message("requestType : " + requestType);
        }
        if (authXMLRequest.getValidSessionNoUpgrade()) {
            authResponse.setAuthXMLRequest(authXMLRequest);
            authResponse.setValidSessionNoUpgrade(true);
            return authResponse;
        }
        securityEnabled = null;
        try {
            securityEnabled = AuthUtils.getRemoteSecurityEnabled();
        }
        catch (AuthException auExp) {
            AuthXMLHandler.debug.error("Got Exception", (Throwable)auExp);
            this.setErrorCode(authResponse, (Exception)auExp);
            return authResponse;
        }
        if (AuthXMLHandler.debug.messageEnabled()) {
            AuthXMLHandler.debug.message("Security Enabled = " + securityEnabled);
        }
        if (securityEnabled != null && securityEnabled.equals("true")) {
            this.security = true;
            indexNameLoc = authXMLRequest.getIndexName();
            indexTypeLoc = authXMLRequest.getIndexType();
            if (indexTypeLoc == null) {
                indexTypeLoc = AuthUtils.getIndexType(authContext);
                indexNameLoc = AuthUtils.getIndexName(authContext);
            }
            if (AuthXMLHandler.debug.messageEnabled()) {
                AuthXMLHandler.debug.message("Index Name Local : " + indexNameLoc);
                AuthXMLHandler.debug.message("Index Type Local : " + indexTypeLoc);
            }
            if (indexTypeLoc == null || indexNameLoc == null || indexTypeLoc != AuthContext.IndexType.MODULE_INSTANCE || !indexNameLoc.equals("Application")) {
                try {
                    ssoTokenID = authXMLRequest.getAppSSOTokenID();
                    if (AuthXMLHandler.debug.messageEnabled()) {
                        AuthXMLHandler.debug.message("Session ID = : " + ssoTokenID);
                    }
                    if (!(manager = SSOTokenManager.getInstance()).isValidToken(appSSOToken = manager.createSSOToken(ssoTokenID))) {
                        AuthXMLHandler.debug.message("App SSOToken is not valid");
                        throw new AuthException("122", null);
                    }
                    AuthXMLHandler.debug.message("App SSOToken is VALID");
                }
                catch (Exception exp) {
                    AuthXMLHandler.debug.error("Got Exception", (Throwable)exp);
                    this.setErrorCode(authResponse, exp);
                    return authResponse;
                }
            }
        } else {
            this.security = false;
        }
        if (AuthUtils.getIndexType(authContext) == AuthContext.IndexType.LEVEL || AuthUtils.getIndexType(authContext) == AuthContext.IndexType.COMPOSITE_ADVICE) {
            callbacks = authXMLRequest.getSubmittedCallbacks();
            if (AuthXMLHandler.messageEnabled) {
                AuthXMLHandler.debug.message("Callbacks are  : " + callbacks);
            }
            if (callbacks != null) {
                if (AuthXMLHandler.messageEnabled) {
                    AuthXMLHandler.debug.message("Callback length is : " + callbacks.length);
                }
                if (callbacks[0] instanceof ChoiceCallback) {
                    cc = (ChoiceCallback)callbacks[0];
                    selectedIndexes = cc.getSelectedIndexes();
                    selected = selectedIndexes[0];
                    choices = cc.getChoices();
                    indexName = choices[selected];
                    if (AuthXMLHandler.messageEnabled) {
                        AuthXMLHandler.debug.message("Selected Index is : " + indexName);
                    }
                    authXMLRequest.setIndexType("moduleInstance");
                    authXMLRequest.setIndexName(indexName);
                    authXMLRequest.setRequestType(6);
                    requestType = 6;
                }
            }
        }
        loginStatus = AuthContext.Status.IN_PROGRESS;
        switch (requestType) {
            case 0: {
                try {
                    this.processNewRequest(servletRequest, servletResponse, authResponse, loginState, authContext);
                    this.postProcess(loginState, authResponse);
                }
                catch (Exception ae) {
                    AuthXMLHandler.debug.error("Error creating AuthContext ", (Throwable)ae);
                    if (AuthXMLHandler.messageEnabled) {
                        AuthXMLHandler.debug.message("Exception ", (Throwable)ae);
                    }
                    this.setErrorCode(authResponse, ae);
                }
                break;
            }
            case 1: {
                try {
                    if (sessionID != null && sessionID.equals("0")) {
                        this.processNewRequest(servletRequest, servletResponse, authResponse, loginState, authContext);
                    }
                    clientHost = null;
                    if (this.security) {
                        clientHost = authXMLRequest.getHostName();
                        if (AuthXMLHandler.messageEnabled) {
                            AuthXMLHandler.debug.message("Client Host from Request = " + clientHost);
                        }
                    }
                    if (clientHost == null && servletRequest != null) {
                        clientHost = servletRequest.getRemoteAddr();
                    }
                    loginState.setClient(clientHost);
                    authContext.login();
                    this.setServletRequest(servletRequest, authContext);
                    this.processRequirements(authContext, authResponse, params, servletRequest);
                    this.postProcess(loginState, authResponse);
                    this.checkACException(authResponse, authContext);
                }
                catch (Exception le) {
                    AuthXMLHandler.debug.error("Error during login ", (Throwable)le);
                    if (AuthXMLHandler.messageEnabled) {
                        AuthXMLHandler.debug.message("Exception ", (Throwable)le);
                    }
                    this.setErrorCode(authResponse, le);
                }
                break;
            }
            case 6: {
                try {
                    indexType = authXMLRequest.getIndexType();
                    indexName = authXMLRequest.getIndexName();
                    if (AuthXMLHandler.messageEnabled) {
                        AuthXMLHandler.debug.message("indexName is : " + indexName);
                        AuthXMLHandler.debug.message("indexType is : " + indexType);
                    }
                    if (sessionID != null && sessionID.equals("0")) {
                        this.processNewRequest(servletRequest, servletResponse, authResponse, loginState, authContext);
                    }
                    clientHost = null;
                    if (this.security) {
                        clientHost = authXMLRequest.getHostName();
                        if (AuthXMLHandler.messageEnabled) {
                            AuthXMLHandler.debug.message("Client Host from Request = " + clientHost);
                        }
                    }
                    if (clientHost == null && servletRequest != null) {
                        clientHost = servletRequest.getRemoteAddr();
                    }
                    loginState.setClient(clientHost);
                    locale = authXMLRequest.getLocale();
                    if (locale != null && locale.length() > 0) {
                        if (AuthXMLHandler.debug.messageEnabled()) {
                            AuthXMLHandler.debug.message("locale is : " + locale);
                        }
                        authContext.login(indexType, indexName, false, envMap, locale);
                    } else {
                        authContext.login(indexType, indexName, false, envMap, null);
                    }
                    this.setServletRequest(servletRequest, authContext);
                    this.processRequirements(authContext, authResponse, params, servletRequest);
                    this.postProcess(loginState, authResponse);
                    this.checkACException(authResponse, authContext);
                }
                catch (Exception le) {
                    AuthXMLHandler.debug.error("Login Exception ", (Throwable)le);
                    if (AuthXMLHandler.messageEnabled) {
                        AuthXMLHandler.debug.message("Exception ", (Throwable)le);
                    }
                    this.setErrorCode(authResponse, le);
                }
                break;
            }
            case 8: {
                try {
                    subject = authXMLRequest.getSubject();
                    authContext.login(subject);
                    this.setServletRequest(servletRequest, authContext);
                    this.processRequirements(authContext, authResponse, params, servletRequest);
                    this.postProcess(loginState, authResponse);
                    this.checkACException(authResponse, authContext);
                }
                catch (AuthLoginException le) {
                    AuthXMLHandler.debug.error("Login Exception ", (Throwable)le);
                    if (AuthXMLHandler.messageEnabled) {
                        AuthXMLHandler.debug.message("Exception ", (Throwable)le);
                    }
                    this.setErrorCode(authResponse, le);
                }
                break;
            }
            case 2: {
                try {
                    this.setServletRequest(servletRequest, authContext);
                    submittedCallbacks = authXMLRequest.getSubmittedCallbacks();
                    authContext.submitRequirements(submittedCallbacks);
                    reqdCallbacks = null;
                    if (authContext.hasMoreRequirements()) {
                        reqdCallbacks = authContext.getRequirements();
                        authResponse.setReqdCallbacks(reqdCallbacks);
                    }
                    this.postProcess(loginState, authResponse);
                    loginStatus = authContext.getStatus();
                    authResponse.setLoginStatus(loginStatus);
                    oldSession = loginState.getOldSession();
                    authResponse.setOldSession(oldSession);
                    this.checkACException(authResponse, authContext);
                }
                catch (Exception le) {
                    AuthXMLHandler.debug.error("Error during login ", (Throwable)le);
                    if (AuthXMLHandler.messageEnabled) {
                        AuthXMLHandler.debug.message("Exception ", (Throwable)le);
                    }
                    this.setErrorCode(authResponse, le);
                }
                break;
            }
            case 3: {
                try {
                    if (sessionID != null && sessionID.equals("0")) {
                        this.processNewRequest(servletRequest, servletResponse, authResponse, loginState, authContext);
                    }
                    moduleNames = authContext.getModuleInstanceNames();
                    authResponse.setModuleNames(moduleNames);
                    authResponse.setAuthContext(authContext);
                    this.postProcess(loginState, authResponse);
                    this.checkACException(authResponse, authContext);
                }
                catch (Exception ae) {
                    AuthXMLHandler.debug.error("Error aborting ", (Throwable)ae);
                    if (AuthXMLHandler.messageEnabled) {
                        AuthXMLHandler.debug.message("Exception ", (Throwable)ae);
                    }
                    this.setErrorCode(authResponse, ae);
                }
                break;
            }
            case 4: {
                loginContext = null;
                intSess = null;
                token = null;
                logoutCalled = false;
                this.setServletRequest(servletRequest, authContext);
                if (sessionID == null || sessionID.equals("0")) ** GOTO lbl217
                intSess = AuthD.getSession(sessionID);
                try {
                    token = SSOTokenManager.getInstance().createSSOToken(sessionID);
                    if (AuthXMLHandler.debug.messageEnabled()) {
                        AuthXMLHandler.debug.message("AuthXMLHandler.processAuthXMLRequest: Created token during logout = " + token);
                    }
                }
                catch (SSOException ssoExp) {
                    if (!AuthXMLHandler.debug.messageEnabled()) ** GOTO lbl217
                    AuthXMLHandler.debug.message("AuthXMLHandler.processAuthXMLRequest:SSOException checking validity of SSO Token");
                }
lbl217:
                // 4 sources

                if (intSess != null) {
                    loginContext = intSess.getObject("sunAMAuthLoginContext");
                }
                try {
                    if (loginContext != null) {
                        if (loginContext instanceof javax.security.auth.login.LoginContext) {
                            lc = (javax.security.auth.login.LoginContext)loginContext;
                            lc.logout();
                        } else {
                            jlc = (LoginContext)loginContext;
                            jlc.logout();
                        }
                        logoutCalled = true;
                    }
                }
                catch (LoginException loginExp) {
                    AuthXMLHandler.debug.error("AuthXMLHandler.processAuthXMLRequest: Cannot Execute module Logout", (Throwable)loginExp);
                }
                postAuthSet = null;
                if (intSess != null) {
                    postAuthSet = (Set)intSess.getObject("sunAMAuthPostProcessInstanceSet");
                }
                if (postAuthSet != null && !postAuthSet.isEmpty()) {
                    postLoginInstance = null;
                    iter = postAuthSet.iterator();
                    while (iter.hasNext()) {
                        try {
                            postLoginInstance = (AMPostAuthProcessInterface)iter.next();
                            postLoginInstance.onLogout(servletRequest, servletResponse, token);
                        }
                        catch (Exception exp) {
                            AuthXMLHandler.debug.error("AuthXMLHandler.processAuthXMLRequest: Failed in post logout.", (Throwable)exp);
                        }
                    }
                } else {
                    plis = null;
                    if (intSess != null) {
                        plis = intSess.getProperty("PostAuthProcessInstance");
                    }
                    if (plis != null && plis.length() > 0) {
                        st = new StringTokenizer(plis, "|");
                        if (token != null) {
                            while (st.hasMoreTokens()) {
                                pli = st.nextToken();
                                try {
                                    postProcess = (AMPostAuthProcessInterface)Thread.currentThread().getContextClassLoader().loadClass(pli).newInstance();
                                    postProcess.onLogout(servletRequest, servletResponse, token);
                                }
                                catch (Exception e) {
                                    AuthXMLHandler.debug.error("AuthXMLHandler.processAuthXMLRequest:" + pli, (Throwable)e);
                                }
                            }
                        }
                    }
                }
                try {
                    isTokenValid = SSOTokenManager.getInstance().isValidToken(token);
                    if (token != null && isTokenValid) {
                        AuthD.getAuth().logLogout(token);
                        session = Session.getSession(new SessionID(sessionID));
                        session.logout();
                        AuthXMLHandler.debug.message("logout successful.");
                    }
                }
                catch (SessionException sessExp) {
                    if (AuthXMLHandler.debug.messageEnabled()) {
                        AuthXMLHandler.debug.message("AuthXMLHandler.processAuthXMLRequest: SessionException checking validity of SSO Token");
                    }
                }
                catch (SSOException ssoExp) {
                    if (!AuthXMLHandler.debug.messageEnabled()) ** GOTO lbl276
                    AuthXMLHandler.debug.message("AuthXMLHandler.processAuthXMLRequest: SSOException checking validity of SSO Token");
                }
lbl276:
                // 4 sources

                authResponse.setLoginStatus(AuthContext.Status.COMPLETED);
                this.checkACException(authResponse, authContext);
                break;
            }
            case 5: {
                try {
                    authContext.abort();
                    loginStatus = authContext.getStatus();
                    authResponse.setLoginStatus(loginStatus);
                    this.checkACException(authResponse, authContext);
                    break;
                }
                catch (AuthLoginException le) {
                    AuthXMLHandler.debug.error("Error aborting ", (Throwable)le);
                    if (AuthXMLHandler.messageEnabled) {
                        AuthXMLHandler.debug.message("Exception ", (Throwable)le);
                    }
                    this.setErrorCode(authResponse, le);
                }
            }
        }
        if (AuthXMLHandler.messageEnabled) {
            AuthXMLHandler.debug.message("loginStatus: " + loginStatus);
            AuthXMLHandler.debug.message("error Code: " + authContext.getErrorCode());
            AuthXMLHandler.debug.message("error Template: " + authContext.getErrorTemplate());
        }
        if (loginStatus == AuthContext.Status.FAILED) {
            if (authContext.getErrorMessage() != null && authContext.getErrorMessage().equals(AMResourceBundleCache.getInstance().getResBundle("amAuthLDAP", Locale.getLocale((String)loginState.getLocale())).getString("ExceedRetryLimit"))) {
                loginState.setErrorCode("107");
            }
            if (authContext.getErrorCode() != null && authContext.getErrorCode().length() > 0) {
                authResponse.setErrorCode(authContext.getErrorCode());
            }
            this.checkACException(authResponse, authContext);
            if (authContext.getErrorTemplate() != null && authContext.getErrorTemplate().length() > 0) {
                authResponse.setErrorTemplate(authContext.getErrorTemplate());
            }
            if (authContext.getErrorCode() != null && authContext.getErrorCode().equals("103") && (lockWarning = authContext.getLockoutMsg()) != null && lockWarning.length() > 0) {
                authResponse.setErrorMessage(lockWarning);
            }
        }
        return authResponse;
    }

    private void processNewRequest(HttpServletRequest servletRequest, HttpServletResponse servletResponse, AuthXMLResponse authResponse, LoginState loginState, AuthContextLocal authContext) throws AuthException {
        if (authContext == null) {
            throw new AuthException("108", null);
        }
        InternalSession oldSession = loginState.getOldSession();
        authResponse.setOldSession(oldSession);
        authResponse.setLoginStatus(AuthContext.Status.IN_PROGRESS);
        AuthUtils.setlbCookie(authContext, servletRequest, servletResponse);
    }

    private void postProcess(LoginState loginState, AuthXMLResponse authResponse) {
        SessionID sid = loginState.getSid();
        String sidString = null;
        if (sid != null) {
            sidString = sid.toString();
        }
        if (messageEnabled) {
            debug.message("sidString is.. : " + sidString);
        }
        authResponse.setAuthIdentifier(sidString);
    }

    private String getNextParam(StringTokenizer st) {
        String retStr = null;
        if (st != null && st.hasMoreTokens()) {
            retStr = st.nextToken();
        }
        return retStr;
    }

    private void processRequirements(AuthContextLocal authContext, AuthXMLResponse authResponse, String params, HttpServletRequest servletRequest) {
        Object paramArray = null;
        StringTokenizer paramsSet = null;
        if (params != null) {
            paramsSet = new StringTokenizer(params, "|");
        }
        boolean allCallbacksAreSet = true;
        while (authContext.hasMoreRequirements()) {
            Callback[] reqdCallbacks = authContext.getRequirements();
            for (int i = 0; i < reqdCallbacks.length; ++i) {
                if (reqdCallbacks[i] instanceof X509CertificateCallback) {
                    X509CertificateCallback certCallback = (X509CertificateCallback)reqdCallbacks[i];
                    LoginState loginState = AuthUtils.getLoginState(authContext);
                    if (loginState == null) continue;
                    X509Certificate cert = loginState.getX509Certificate(servletRequest);
                    if (cert != null) {
                        certCallback.setCertificate(cert);
                        certCallback.setReqSignature(false);
                        continue;
                    }
                    allCallbacksAreSet = false;
                    continue;
                }
                String param = null;
                if (reqdCallbacks[i] instanceof NameCallback) {
                    param = this.getNextParam(paramsSet);
                    if (param != null) {
                        NameCallback nc = (NameCallback)reqdCallbacks[i];
                        nc.setName(param);
                        if (!messageEnabled) continue;
                        debug.message("Name callback set to " + param);
                        continue;
                    }
                    allCallbacksAreSet = false;
                    break;
                }
                if (reqdCallbacks[i] instanceof PasswordCallback) {
                    param = this.getNextParam(paramsSet);
                    if (param != null) {
                        PasswordCallback pc = (PasswordCallback)reqdCallbacks[i];
                        pc.setPassword(param.toCharArray());
                        if (!messageEnabled) continue;
                        debug.message("Password callback is set");
                        continue;
                    }
                    allCallbacksAreSet = false;
                    break;
                }
                if (params != null) continue;
                allCallbacksAreSet = false;
            }
            if (allCallbacksAreSet) {
                if (messageEnabled) {
                    debug.message("submit callbacks with passed in params");
                }
                authContext.submitRequirements(reqdCallbacks);
                continue;
            }
            authResponse.setReqdCallbacks(reqdCallbacks);
            break;
        }
        if (!authContext.hasMoreRequirements()) {
            AuthContext.Status loginStatus = authContext.getStatus();
            if (messageEnabled) {
                debug.message(" Status: " + loginStatus);
            }
            authResponse.setLoginStatus(loginStatus);
        }
    }

    private void checkACException(AuthXMLResponse authResponse, AuthContextLocal acl) {
        AuthLoginException ale = acl.getLoginException();
        if (ale == null) {
            return;
        }
        if (ale.getL10NMessage(this.locale) != null && ale.getL10NMessage(this.locale).length() > 0) {
            authResponse.setErrorMessage(ale.getL10NMessage(this.locale));
        }
        authResponse.setIsException(true);
    }

    private void setErrorCode(AuthXMLResponse authResponse, Exception e) {
        if (e == null) {
            return;
        }
        if (e instanceof L10NMessage) {
            authResponse.setErrorCode(this.getAuthErrorCode((L10NMessage)e));
        } else {
            authResponse.setErrorCode(e.getMessage());
        }
        authResponse.setIsException(true);
    }

    private String getAuthErrorCode(L10NMessage le) {
        String errorCode = le.getErrorCode();
        if (errorCode == null) {
            errorCode = le.getMessage();
        }
        return errorCode;
    }

    private void setServletRequest(HttpServletRequest servletRequest, AuthContextLocal authContext) {
        LoginState theLoginState = AuthUtils.getLoginState(authContext);
        theLoginState.setHttpServletRequest(servletRequest);
        if (debug.messageEnabled()) {
            debug.message("AuthXMLHandler.setServletRequest(): Setting servlet request.");
        }
    }

    private Map toEnvMap(List envList) {
        if (envList == null) {
            return null;
        }
        HashMap map = new HashMap();
        int size = envList.size();
        for (int i = 0; i < size; ++i) {
            String value = (String)envList.get(i);
            StringTokenizer tokens = new StringTokenizer(value, "|");
            String envName = null;
            if (tokens.hasMoreTokens()) {
                envName = tokens.nextToken();
            }
            HashSet<String> envValues = new HashSet<String>();
            while (tokens.hasMoreTokens()) {
                envValues.add(AuthClientUtils.unescapePipe(tokens.nextToken()));
            }
            if (envName == null || envValues.isEmpty()) continue;
            map.put(envName, envValues);
        }
        return map;
    }

    static {
        messageEnabled = false;
        debug = Debug.getInstance((String)"amXMLHandler");
        messageEnabled = debug.messageEnabled();
        serviceURI = SystemProperties.get("com.iplanet.am.services.deploymentDescriptor") + "/authservice";
    }
}

