/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.agentconfig;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.common.configuration.AgentConfiguration;
import com.sun.identity.sm.SMSException;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;

public class ShowAgentTypes
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        try {
            this.writeLog(0, Level.INFO, "ATTEMPT_SHOW_AGENT_TYPES", null);
            Set agentTypes = AgentConfiguration.getAgentTypes();
            if (!agentTypes.isEmpty()) {
                Iterator i = agentTypes.iterator();
                while (i.hasNext()) {
                    outputWriter.printlnMessage((String)i.next());
                }
            } else {
                outputWriter.printlnMessage(this.getResourceString("show-agent-type-no-results"));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_SHOW_AGENT_TYPES", null);
        }
        catch (SMSException e) {
            String[] args = new String[]{e.getMessage()};
            this.debugError("ShowAgentTypes.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_SHOW_AGENT_TYPES", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{e.getMessage()};
            this.debugError("ShowAgentTypes.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_SHOW_AGENT_TYPES", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

