/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement.opensso;

import com.sun.identity.entitlement.Entitlement;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.Privilege;
import com.sun.identity.entitlement.PrivilegeType;
import com.sun.identity.entitlement.util.NetworkMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenSSOPrivilege
extends Privilege {
    private static final NetworkMonitor EVAL_SINGLE_LEVEL_MONITOR = NetworkMonitor.getInstance("privilegeSingleLevelEvaluation");
    private static final NetworkMonitor EVAL_SUB_TREE_MONITOR = NetworkMonitor.getInstance("privilegeSubTreeEvaluation");
    private String policyName;

    @Override
    public PrivilegeType getType() {
        return PrivilegeType.OPENSSO;
    }

    @Override
    public List<Entitlement> evaluate(Subject adminSubject, String realm, Subject subject, String applicationName, String resourceName, Set<String> actionNames, Map<String, Set<String>> environment, boolean recursive) throws EntitlementException {
        long start = recursive ? EVAL_SUB_TREE_MONITOR.start() : EVAL_SINGLE_LEVEL_MONITOR.start();
        ArrayList<Entitlement> results = new ArrayList<Entitlement>();
        if (!this.isActive()) {
            Entitlement origE = this.getEntitlement();
            Entitlement e = new Entitlement(origE.getApplicationName(), origE.getResourceName(), Collections.EMPTY_SET);
            results.add(e);
            return results;
        }
        HashMap<String, Set<String>> advices = new HashMap<String, Set<String>>();
        if (this.doesSubjectMatch(realm, advices, subject, resourceName, environment) && this.doesConditionMatch(realm, advices, subject, resourceName, environment)) {
            Entitlement origE = this.getEntitlement();
            Set<String> resources = origE.evaluate(adminSubject, realm, subject, applicationName, resourceName, actionNames, environment, recursive);
            for (String r : resources) {
                Entitlement e = new Entitlement(origE.getApplicationName(), r, origE.getActionValues());
                e.setAttributes(this.getAttributes(adminSubject, realm, subject, resourceName, environment));
                results.add(e);
            }
        } else {
            Entitlement origE = this.getEntitlement();
            Entitlement e = new Entitlement(origE.getApplicationName(), origE.getResourceName(), Collections.EMPTY_SET);
            e.setAdvices(advices);
            results.add(e);
        }
        if (recursive) {
            EVAL_SUB_TREE_MONITOR.end(start);
        } else {
            EVAL_SINGLE_LEVEL_MONITOR.end(start);
        }
        return results;
    }

    @Override
    public JSONObject toJSONObject() throws JSONException {
        JSONObject jo = super.toJSONObject();
        if (this.policyName != null) {
            jo.put("policyName", (Object)this.policyName);
        }
        return jo;
    }

    @Override
    protected void init(JSONObject jo) {
        this.policyName = jo.optString("policyName");
    }

    public void setPolicyName(String policyName) {
        this.policyName = policyName;
    }

    public String getPolicyName() {
        return this.policyName;
    }
}

