/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.security;

import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.Attribute;
import com.sun.identity.saml.assertion.AttributeStatement;
import com.sun.identity.saml.assertion.AuthenticationStatement;
import com.sun.identity.saml.assertion.Statement;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectLocality;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.wss.security.SecurityException;
import com.sun.identity.wss.security.WSSUtils;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;

public class SAML11AssertionValidator {
    private static Debug debug = WSSUtils.debug;
    private Map attributeMap = null;
    private String subjectName = null;
    private Map config = null;
    private X509Certificate cert = null;

    public SAML11AssertionValidator(Element assertionE, Map config) throws SecurityException {
        debug.message("SAML11AssertionValidator.constructor..");
        this.config = config;
        if (config == null) {
            throw new SecurityException(WSSUtils.bundle.getString("nullConfig"));
        }
        try {
            Assertion saml11Assertion = new Assertion(assertionE);
            if (!saml11Assertion.isSigned()) {
                throw new SecurityException(WSSUtils.bundle.getString("assertionNotSigned"));
            }
            String issuer = saml11Assertion.getIssuer();
            if (issuer == null) {
                throw new SecurityException(WSSUtils.bundle.getString("nullIssuer"));
            }
            Set trustedIssuers = (Set)config.get("trustedIssuers");
            if (trustedIssuers != null && !trustedIssuers.isEmpty() && !trustedIssuers.contains(issuer)) {
                throw new SecurityException(WSSUtils.bundle.getString("issuerNotTrusted"));
            }
            if (!saml11Assertion.isTimeValid()) {
                throw new SecurityException(WSSUtils.bundle.getString("assertionTimeNotValid"));
            }
            Set statements = saml11Assertion.getStatement();
            if (statements == null || statements.isEmpty()) {
                throw new SecurityException(WSSUtils.bundle.getString("nullStatments"));
            }
            for (Statement statement : statements) {
                int type = statement.getStatementType();
                if (type == 1) {
                    AuthenticationStatement authnStatement = (AuthenticationStatement)statement;
                    this.validateAuthnStatement(authnStatement);
                    continue;
                }
                if (type != 3) continue;
                AttributeStatement attributeStatement = (AttributeStatement)statement;
                this.validateAttributeStatement(attributeStatement);
            }
        }
        catch (SAMLException se) {
            throw new SecurityException(se.getMessage());
        }
    }

    private void validateAuthnStatement(AuthenticationStatement authnStatement) throws SecurityException {
        Element keyInfo;
        Subject subject = authnStatement.getSubject();
        if (subject == null) {
            throw new SecurityException(WSSUtils.bundle.getString("nullSubject"));
        }
        this.subjectName = subject.getNameIdentifier().getName();
        SubjectLocality subjectLocality = authnStatement.getSubjectLocality();
        String ipAddress = null;
        if (subjectLocality != null) {
            ipAddress = subjectLocality.getIPAddress();
        }
        if (ipAddress != null) {
            // empty if block
        }
        if ((keyInfo = authnStatement.getSubject().getSubjectConfirmation().getKeyInfo()) != null) {
            this.cert = WSSUtils.getCertificate(keyInfo);
        }
    }

    private void validateAttributeStatement(AttributeStatement attributeStatement) throws SecurityException {
        try {
            Subject subject = attributeStatement.getSubject();
            if (subject == null) {
                throw new SecurityException(WSSUtils.bundle.getString("nullSubject"));
            }
            this.subjectName = subject.getNameIdentifier().getName();
            Element keyInfo = attributeStatement.getSubject().getSubjectConfirmation().getKeyInfo();
            if (keyInfo != null) {
                this.cert = WSSUtils.getCertificate(keyInfo);
            }
            List attributes = attributeStatement.getAttribute();
            for (Attribute attribute : attributes) {
                String attrName = attribute.getAttributeName();
                List values = attribute.getAttributeValue();
                if (values == null || values.isEmpty()) continue;
                String value = XMLUtils.getElementValue((Element)((Element)values.get(0)));
                this.attributeMap.put(attrName, value);
            }
        }
        catch (SAMLException se) {
            throw new SecurityException(se.getMessage());
        }
    }

    public Map getAttributes() {
        return this.attributeMap;
    }

    public String getSubjectName() {
        return this.subjectName;
    }

    public X509Certificate getKeyInfoCert() {
        return this.cert;
    }
}

