/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.user.model;

import com.sun.identity.console.base.model.AMConsoleException;
import java.io.Serializable;

public class UMUserPasswordResetOptionsData
implements Serializable {
    public static final int DEFAULT_OFF = 0;
    public static final int DEFAULT_ON = 1;
    public static final int PERSONAL_OFF = 2;
    public static final int PERSONAL_ON = 3;
    private String question = null;
    private String questionLocalizedName = null;
    private String answer = null;
    private int dataStatus = 0;

    public UMUserPasswordResetOptionsData(String question, String questionLocalizedName, String answer, int dataStatus) {
        this.question = question.trim();
        this.questionLocalizedName = questionLocalizedName;
        this.answer = answer.trim();
        this.dataStatus = dataStatus;
    }

    public String getAnswer() {
        return this.answer;
    }

    public void setAnswer(String answer) {
        this.answer = answer.trim();
    }

    public int getDataStatus() {
        return this.dataStatus;
    }

    public String getQuestion() {
        return this.question;
    }

    public void setQuestion(String question) {
        if (this.isPersonalQuestion()) {
            this.question = question.trim();
            this.questionLocalizedName = question.trim();
        }
    }

    public String getQuestionLocalizedName() {
        return this.questionLocalizedName;
    }

    public boolean isSelected() {
        return this.dataStatus == 1 || this.dataStatus == 3;
    }

    public void setSelected(boolean selected) {
        this.dataStatus = selected ? (this.isPersonalQuestion() ? 3 : 1) : (this.isPersonalQuestion() ? 2 : 0);
    }

    public boolean isPersonalQuestion() {
        return this.dataStatus == 3 || this.dataStatus == 2;
    }

    public void validate() throws AMConsoleException {
        if (this.isSelected()) {
            if (this.isPersonalQuestion()) {
                if (this.question.length() == 0 || this.answer.length() == 0) {
                    throw new AMConsoleException("user.password.reset.missing.personal.question.answer.message");
                }
            } else if (this.answer.length() == 0) {
                throw new AMConsoleException("user.password.reset.missing.answer.message");
            }
        }
    }

    public String toString() {
        return "Question=\"" + this.question + "\"\n" + "Question Localized Name=\"" + this.questionLocalizedName + "\"\n" + "Answer=\"" + this.answer + "\"\n" + "Selected Status=\"" + this.dataStatus + "\"\n";
    }
}

