/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tools.manifest;

import com.sun.identity.tools.manifest.FilesDigester;
import com.sun.identity.tools.manifest.ManifestConstants;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Properties;

public class Manifest
implements ManifestConstants {
    String manifestName;
    public File srcFile;
    public File destFile;
    static boolean verbose;
    FilesDigester digester;
    Properties digestResult;
    static char wildCard;
    static LinkedList includePattern;
    static LinkedList excludePattern;
    static String headerFilePath;
    static String srcFilePath;
    static String destFilePath;
    static boolean recursive;
    static String includePatternString;
    static String excludePatternString;
    static String wildCardString;
    static String digestAlg;
    boolean intoJar;
    boolean intoWar;
    static boolean overwrite;

    public void setDefaultProperties() {
        verbose = Boolean.valueOf("false");
        recursive = Boolean.valueOf("true");
        digestAlg = "SHA1";
        this.intoJar = Boolean.valueOf("true");
        this.intoWar = Boolean.valueOf("true");
        this.manifestName = "manifest.manifest";
        overwrite = Boolean.valueOf("true");
        wildCard = (char)42;
    }

    private void getProperties() {
        String tempPattern;
        int index;
        int offset;
        headerFilePath = System.getProperty("file.header.path");
        srcFilePath = System.getProperty("file.src.path");
        destFilePath = System.getProperty("file.dest.path");
        verbose = Boolean.valueOf(System.getProperty("option.verbose", "false"));
        recursive = Boolean.valueOf(System.getProperty("file.recursive", "true"));
        includePatternString = System.getProperty("file.include");
        excludePatternString = System.getProperty("file.exclude");
        this.manifestName = System.getProperty("name.manifest", "manifest.manifest");
        wildCardString = System.getProperty("pattern.wildcard");
        digestAlg = System.getProperty("digest.alg", "SHA1");
        this.intoJar = Boolean.valueOf(System.getProperty("digest.handlejar", "true"));
        this.intoWar = Boolean.valueOf(System.getProperty("digest.handlewar", "true"));
        overwrite = Boolean.valueOf(System.getProperty("file.overwrite", "true"));
        if (includePatternString != null && includePatternString.length() > 0) {
            includePattern = new LinkedList();
            offset = 0;
            index = includePatternString.indexOf(",", offset);
            while (true) {
                if (index <= offset) {
                    if (offset >= includePatternString.length() || (tempPattern = includePatternString.substring(offset, includePatternString.length()).trim()).length() <= 0) break;
                    includePattern.add(tempPattern);
                    break;
                }
                includePattern.add(includePatternString.substring(offset, index).trim());
                offset = index + 1;
                index = includePatternString.indexOf(",", offset);
            }
        }
        if (excludePatternString != null && excludePatternString.length() > 0) {
            excludePattern = new LinkedList();
            offset = 0;
            index = excludePatternString.indexOf(",", offset);
            while (true) {
                if (index <= offset) {
                    if (offset >= excludePatternString.length() || (tempPattern = excludePatternString.substring(offset, excludePatternString.length()).trim()).length() <= 0) break;
                    excludePattern.add(tempPattern);
                    break;
                }
                excludePattern.add(excludePatternString.substring(offset, index).trim());
                offset = index + 1;
                index = excludePatternString.indexOf(",", offset);
            }
        }
        wildCard = (char)42;
        if (wildCardString != null) {
            wildCard = wildCardString.trim().charAt(0);
        }
    }

    private boolean setSourceFile(String srcFilePath) {
        if (srcFilePath == null) {
            System.out.println("Source file not specified!");
            return false;
        }
        Manifest.srcFilePath = srcFilePath;
        this.srcFile = new File(srcFilePath);
        if (!this.srcFile.isFile()) {
            System.out.println("Source file not found!");
            return false;
        }
        return true;
    }

    public void setProperties(Properties prop) {
        this.digestResult = new Properties(prop);
    }

    public String getProperty(String propertyName) {
        return this.digestResult.getProperty(propertyName);
    }

    public Enumeration getPropertyNames() {
        return this.digestResult.propertyNames();
    }

    public void removeProperty(String propertyName) {
        this.digestResult.remove(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDestFile() {
        this.destFile = new File(destFilePath);
        FilterOutputStream fout = null;
        try {
            if (this.destFile.isDirectory()) {
                fout = new BufferedOutputStream(new FileOutputStream(new File(this.destFile, this.manifestName)));
            } else if (this.destFile.isFile() && !overwrite) {
                fout = new BufferedOutputStream(new FileOutputStream(this.destFile, true));
            } else {
                File parentFile = this.destFile.getParentFile();
                if (parentFile != null && !parentFile.exists()) {
                    parentFile.mkdirs();
                }
                fout = new BufferedOutputStream(new FileOutputStream(this.destFile));
            }
            if (headerFilePath != null) {
                File headerFile = new File(headerFilePath);
                if (headerFile.exists() && headerFile.isFile()) {
                    String line;
                    BufferedReader fr = new BufferedReader(new FileReader(headerFile));
                    while ((line = fr.readLine()) != null) {
                        fout.write(line.getBytes());
                        fout.write("\n".getBytes());
                    }
                    fr.close();
                }
            } else {
                long currentTimeInMillis = System.currentTimeMillis();
                Date date = new Date(currentTimeInMillis);
                String DATE_FORMAT = "yyyyMMddhhmm";
                SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
                fout.write("identifier=(".getBytes());
                fout.write(sdf.format(date).getBytes());
                fout.write(")\n".getBytes());
            }
            this.digestResult.store(fout, "");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException iOException) {}
                fout = null;
            }
        }
    }

    private void createManifest() {
        this.digester = new FilesDigester(includePattern, excludePattern, wildCard, recursive);
        this.digestResult = new Properties();
        this.digester.digest(digestAlg, this.srcFile, this.digestResult, srcFilePath, this.intoJar, this.intoWar);
    }

    public boolean createManifest(String srcFilePath, String destFilePath, String headerFilePath, boolean intoJar, boolean intoWar) {
        this.intoJar = intoJar;
        this.intoWar = intoWar;
        if (!this.setSourceFile(srcFilePath)) {
            return false;
        }
        if (verbose) {
            if (destFilePath != null) {
                System.out.print("Creating Manifest file " + destFilePath);
            } else {
                System.out.print("Displaying Manifest file ");
            }
            System.out.println(" for " + srcFilePath + "\n");
        }
        this.createManifest();
        if (destFilePath != null) {
            Manifest.destFilePath = destFilePath;
            this.writeDestFile();
        } else {
            long currentTimeInMillis = System.currentTimeMillis();
            Date date = new Date(currentTimeInMillis);
            String DATE_FORMAT = "yyyyMMddhhmm";
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
            this.digestResult.setProperty("identifier", "generated-" + sdf.format(date));
        }
        return true;
    }

    public static void main(String[] args) {
        Manifest m = new Manifest();
        m.getProperties();
        m.createManifest(srcFilePath, destFilePath, headerFilePath, true, true);
    }

    public static void printUsage(PrintStream out) {
        System.out.println("Usage: java ARGUMENTS -jar Manifest.jar");
        System.out.println("\nARGUMENTS");
        System.out.println("\t-D\"file.dest.path=<RTM zip file>\"");
        System.out.println("\tPath of RTM zip file [Required].");
        System.out.println("\n\t-D\"file.war.latest=<latest zip file>\"");
        System.out.println("\tPath of the resulting patch file [Optional].");
        System.out.println("\n\t-D\"entry.identifier=<name of the entry which indicate version>\"");
        System.out.println("\tName of the entry in manifest indicate identity [Default: identifier].");
        System.out.println("\n\t-D\"pattern.manifest=<pattern of manifest file>\"");
        System.out.println("\tPattern of the manifest file in the war file [Default: *.manifest].");
        System.out.println("\n\t-D\"filename.manifest=<name of the manifest file in the resulting file>\"");
        System.out.println("\tName of the manifest file [Required if file.version is not defined].");
        System.out.println("\n\t-D\"pattern.wildcard=<char to be used as wildcard>\"");
        System.out.println("\tWild card character [Default: *].");
        System.out.println("\n\t-D\"file.version=<properties file indicate version>\"");
        System.out.println("\tProperties file indicate the version of patch [Optional].");
        System.out.println("\n\t-D\"file.properties=<propeties file has the above directive defined>\"");
        System.out.println("\tProperties file have above directives defined [Optional].");
    }

    static {
        includePattern = null;
        excludePattern = null;
    }
}

