/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.IDSConfigMgr;
import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.Server;
import com.iplanet.services.ldap.ServerGroup;
import com.iplanet.services.ldap.ServerInstance;
import com.iplanet.services.util.XMLException;
import com.iplanet.services.util.XMLParser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.configuration.ServerConfiguration;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.SMSException;
import java.security.AccessController;
import java.util.Collection;
import java.util.Hashtable;

public class DSConfigMgrBase
implements IDSConfigMgr {
    Hashtable groupHash = new Hashtable();

    public ServerGroup getServerGroup(String serverGroupID) {
        return (ServerGroup)this.groupHash.get(serverGroupID);
    }

    public String getHostName(String serverGroupID) {
        ServerGroup serverGrp = this.getServerGroup(serverGroupID);
        Collection serverList = serverGrp.getServersList();
        StringBuffer hostName = new StringBuffer();
        for (Server serverObj : serverList) {
            hostName.append(serverObj.getServerName());
            hostName.append(':');
            hostName.append(serverObj.getPort());
            hostName.append(' ');
        }
        hostName.deleteCharAt(hostName.length() - 1);
        return hostName.toString();
    }

    public ServerInstance getServerInstance(String serverGroupID, LDAPUser.Type authType) {
        if (serverGroupID == null) {
            return null;
        }
        ServerGroup svc = this.getServerGroup(serverGroupID);
        if (svc != null) {
            return svc.getServerInstance(authType);
        }
        return null;
    }

    public ServerInstance getServerInstance(LDAPUser.Type authType) {
        return this.getServerInstance("default", authType);
    }

    public void parseServiceConfigXML() throws SMSException, SSOException, XMLException {
        this.groupHash.clear();
        SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        String xml = ServerConfiguration.getServerConfigXML(adminToken, SystemProperties.getServerInstanceName());
        XMLParser parser = new XMLParser(true, this.groupHash);
        parser.register("ServerGroup", "com.iplanet.services.ldap.ServerGroup");
        parser.register("Server", "com.iplanet.services.ldap.Server");
        parser.register("User", "com.iplanet.services.ldap.LDAPUser");
        parser.parse(xml);
    }

    public String toString() {
        return this.groupHash.toString();
    }
}

