/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap;

import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.Server;
import com.iplanet.services.ldap.ServerGroup;

public class ServerInstance {
    ServerGroup serverGroup = null;
    Server server = null;
    LDAPUser user = null;
    boolean status;

    ServerInstance(ServerGroup group, Server theServer, LDAPUser theUser) {
        this.serverGroup = group;
        this.server = theServer;
        this.user = theUser;
    }

    public synchronized void setActiveStatus(boolean serverStatus) {
        this.server.setActiveStatus(serverStatus);
    }

    public synchronized boolean getActiveStatus() {
        return this.server.getActiveStatus();
    }

    public synchronized String getServerName() {
        return this.server.getServerName();
    }

    public synchronized int getPort() {
        return this.server.getPort();
    }

    public synchronized String getServerID() {
        return this.server.getServerID();
    }

    public synchronized String getAuthID() {
        return this.user.getAuthID();
    }

    public Server.Type getConnectionType() {
        return this.server.getConnectionType();
    }

    public synchronized String getPasswd() {
        return this.user.getPasswd();
    }

    public synchronized LDAPUser.Type getAuthType() {
        return this.user.getAuthType();
    }

    public synchronized int getMinConnections() {
        return this.serverGroup.minConnPool;
    }

    public synchronized int getMaxConnections() {
        return this.serverGroup.maxConnPool;
    }

    public synchronized String getBaseDN() {
        return this.serverGroup.baseDN;
    }

    public synchronized int getIntValue(String key, int defVal) {
        if (this.serverGroup.miscConfig != null) {
            String attrVal = (String)this.serverGroup.miscConfig.get(key);
            if (attrVal == null) {
                return defVal;
            }
            try {
                int intValue = Integer.parseInt(attrVal);
                return intValue;
            }
            catch (NumberFormatException ex) {
                return defVal;
            }
        }
        return defVal;
    }

    public synchronized String getStringValue(String key, String defVal) {
        if (this.serverGroup.miscConfig == null) {
            return defVal;
        }
        String retVal = (String)this.serverGroup.miscConfig.get(key);
        if (retVal == null) {
            return defVal;
        }
        return retVal;
    }

    public synchronized boolean getBooleanValue(String key, boolean defVal) {
        if (this.serverGroup.miscConfig == null) {
            return defVal;
        }
        String attrVal = (String)this.serverGroup.miscConfig.get(key);
        if (attrVal == null) {
            return defVal;
        }
        if (attrVal.equalsIgnoreCase("true")) {
            return true;
        }
        if (attrVal.equalsIgnoreCase("false")) {
            return false;
        }
        return defVal;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Server Group Name =");
        buf.append(this.serverGroup.serverGroupName());
        buf.append(" Server ID:=");
        buf.append(this.server.getServerID());
        buf.append(" LDAPUser=");
        buf.append(this.user.getUserID());
        buf.append(" Base DN=");
        buf.append(this.serverGroup.baseDN);
        return buf.toString();
    }
}

