/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.sso;

import com.iplanet.services.util.I18n;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOProvider;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.providers.dpro.SSOProviderBundle;
import com.iplanet.sso.providers.dpro.SSOProviderImpl;
import com.sun.identity.authentication.internal.AuthSSOProvider;
import com.sun.identity.shared.debug.Debug;
import java.security.Principal;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public final class SSOTokenManager {
    static final String GRAPPA_PROVIDER_PACKAGE = "com.sun.identity.authentication.internal";
    static SSOProvider grappaProvider = null;
    static SSOProvider dProProvider = null;
    public static Debug debug = Debug.getInstance((String)"amSDK");
    private static SSOTokenManager instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SSOTokenManager getInstance() throws SSOException {
        if (instance != null) return instance;
        Class<SSOTokenManager> clazz = SSOTokenManager.class;
        synchronized (SSOTokenManager.class) {
            if (instance != null) return instance;
            debug.message("Constructing a new instance of SSOTokenManager");
            instance = new SSOTokenManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private SSOTokenManager() throws SSOException {
        Throwable dProException = null;
        try {
            grappaProvider = new AuthSSOProvider();
            if (debug.messageEnabled()) {
                debug.message("Obtained Grappa SSO Provider");
            }
        }
        catch (Throwable e) {
            debug.error("Unable to obtain Grappa SSO provider", e);
            dProException = e;
        }
        try {
            dProProvider = new SSOProviderImpl();
            if (debug.messageEnabled()) {
                debug.message("Obtained DPRO SSO Provider");
            }
        }
        catch (Throwable e) {
            debug.error("DPRO SSO Provider Exception", e);
            dProException = e;
        }
        if (dProProvider == null && grappaProvider == null) {
            debug.error("Unable to obtain either GRAPPA or DPRO SSO providers");
            I18n i18n = I18n.getInstance("amSDK");
            String rbName = i18n.getResBundleName();
            if (dProException instanceof ClassNotFoundException) {
                throw new SSOException(rbName, "sso-noproviderclass", null);
            }
            if (dProException instanceof InstantiationException) {
                throw new SSOException(rbName, "sso-noproviderinstance", null);
            }
            if (dProException instanceof IllegalAccessException) {
                throw new SSOException(rbName, "sso-illegalaccess", null);
            }
            throw new SSOException(dProException);
        }
    }

    protected static SSOProvider getProvider(SSOToken token) throws SSOException {
        if (token == null) {
            throw new SSOException(SSOProviderBundle.rbName, "ssotokennull", null);
        }
        String packageName = token.getClass().getName();
        if (packageName.startsWith(GRAPPA_PROVIDER_PACKAGE)) {
            if (grappaProvider == null) {
                I18n i18n = I18n.getInstance("amSDK");
                throw new SSOException(i18n.getResBundleName(), "sso-noproviderclass", null);
            }
            return grappaProvider;
        }
        return dProProvider;
    }

    public SSOToken createSSOToken(HttpServletRequest request) throws UnsupportedOperationException, SSOException {
        if (dProProvider != null) {
            return dProProvider.createSSOToken(request);
        }
        return grappaProvider.createSSOToken(request);
    }

    public SSOToken createSSOToken(Principal user, String password) throws UnsupportedOperationException, SSOException {
        if (dProProvider != null) {
            return dProProvider.createSSOToken(user, password);
        }
        return grappaProvider.createSSOToken(user, password);
    }

    public SSOToken createSSOToken(String tokenId) throws UnsupportedOperationException, SSOException {
        if (dProProvider != null) {
            return dProProvider.createSSOToken(tokenId);
        }
        return grappaProvider.createSSOToken(tokenId);
    }

    public SSOToken createSSOToken(String tokenId, String clientIP) throws UnsupportedOperationException, SSOException {
        if (dProProvider != null) {
            return dProProvider.createSSOToken(tokenId, clientIP);
        }
        return grappaProvider.createSSOToken(tokenId, clientIP);
    }

    public boolean isValidToken(SSOToken token) {
        try {
            return SSOTokenManager.getProvider(token).isValidToken(token);
        }
        catch (SSOException ssoe) {
            return false;
        }
    }

    public void validateToken(SSOToken token) throws SSOException {
        SSOTokenManager.getProvider(token).validateToken(token);
    }

    public void destroyToken(SSOToken token) throws SSOException {
        SSOTokenManager.getProvider(token).destroyToken(token);
    }

    public void refreshSession(SSOToken token) throws SSOException {
        try {
            SSOTokenManager.getProvider(token).refreshSession(token);
        }
        catch (Exception e) {
            debug.error("Error in refreshing the session from session server");
            throw new SSOException(e);
        }
    }

    public void destroyToken(SSOToken destroyer, SSOToken destroyed) throws SSOException {
        SSOTokenManager.getProvider(destroyer).destroyToken(destroyer, destroyed);
    }

    public Set getValidSessions(SSOToken requester, String server) throws SSOException {
        return SSOTokenManager.getProvider(requester).getValidSessions(requester, server);
    }
}

