/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.common.ISResourceBundle;
import com.sun.identity.sm.SMSException;
import java.util.logging.Level;

public class DeleteResourceBundle
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String bundleName = this.getStringOptionValue("bundlename");
        String localeName = this.getStringOptionValue("bundlelocale");
        try {
            String[] params = new String[]{bundleName, localeName};
            this.writeLog(0, Level.INFO, "ATTEMPT_DELETE_RESOURCE_BUNDLE", params);
            ISResourceBundle.deleteResourceBundle(adminSSOToken, bundleName, localeName);
            IOutput outputWriter = this.getOutputWriter();
            outputWriter.printlnMessage(this.getResourceString("resourcebundle-deleted"));
            this.writeLog(0, Level.INFO, "SUCCEED_DELETE_RESOURCE_BUNDLE", params);
        }
        catch (SMSException e) {
            String[] args = new String[]{bundleName, localeName, e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_DELETE_RESOURCE_BUNDLE", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{bundleName, localeName, e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_DELETE_RESOURCE_BUNDLE", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

