/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.schema;

import com.iplanet.sso.SSOException;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.schema.SchemaCommand;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import java.text.MessageFormat;
import java.util.logging.Level;

public class ModifyAttributeSchemaUIType
extends SchemaCommand {
    static final String ARGUMENT_UI_TYPE = "uitype";

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        String schemaType = this.getStringOptionValue("schematype");
        String serviceName = this.getStringOptionValue("servicename");
        String subSchemaName = this.getStringOptionValue("subschemaname");
        String attributeSchemaName = this.getStringOptionValue("attributeschema");
        String uitype = this.getStringOptionValue(ARGUMENT_UI_TYPE);
        ServiceSchema ss = this.getServiceSchema();
        IOutput outputWriter = this.getOutputWriter();
        try {
            String[] params = new String[]{serviceName, schemaType, subSchemaName, attributeSchemaName, uitype};
            this.writeLog(0, Level.INFO, "ATTEMPT_MODIFY_ATTRIBUTE_SCHEMA_UI_TYPE", params);
            AttributeSchema attrSchema = ss.getAttributeSchema(attributeSchemaName);
            if (attrSchema == null) {
                String[] args = new String[]{serviceName, schemaType, subSchemaName, attributeSchemaName, uitype, "attribute schema does not exist"};
                this.attributeSchemaNoExist(attributeSchemaName, "FAILED_MODIFY_ATTRIBUTE_SCHEMA_UI_TYPE", args);
            }
            attrSchema.setUIType(uitype);
            this.writeLog(0, Level.INFO, "SUCCEED_MODIFY_ATTRIBUTE_SCHEMA_UI_TYPE", params);
            outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("attribute-schema-modify-type-succeed"), params));
        }
        catch (SSOException e) {
            String[] args = new String[]{serviceName, schemaType, subSchemaName, attributeSchemaName, uitype, e.getMessage()};
            this.debugError("ModifyAttributeSchemaUIType.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_MODIFY_ATTRIBUTE_SCHEMA_UI_TYPE", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{serviceName, schemaType, subSchemaName, attributeSchemaName, uitype, e.getMessage()};
            this.debugError("ModifyAttributeSchemaUIType.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_MODIFY_ATTRIBUTE_SCHEMA_UI_TYPE", args);
            throw new CLIException(e, 127);
        }
    }
}

