/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.base;

import com.iplanet.am.util.BrowserEncoding;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.jato.ApplicationServletBase;
import com.iplanet.jato.CompleteRequestException;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.ViewBeanManager;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.common.FQDNUtils;
import com.sun.identity.common.RequestUtils;
import com.sun.identity.console.base.AMInvalidURLViewBean;
import com.sun.identity.console.base.AMLoginViewBean;
import com.sun.identity.shared.debug.Debug;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

public abstract class ConsoleServletBase
extends ApplicationServletBase {
    static final String PARAM_REDIRECT = "amconsoleRedirect";
    static final String URL_ADMIN_FRAME = "/base/AMAdminFrame";
    static final String LOGIN_PARAM = "?service=adminconsoleservice&goto=";

    public ConsoleServletBase() {
        this.setEnforceStrictSessionTimeout(true);
    }

    protected void onBeforeRequest(RequestContext requestContext) throws ServletException {
        HttpServletRequest req = requestContext.getRequest();
        String host = req.getHeader("Host");
        if (host == null) {
            host = ConsoleServletBase.getConsoleHost();
        } else {
            String validHost = this.validateHost(host);
            if (validHost != null) {
                try {
                    requestContext.getResponse().sendRedirect(this.replaceHostNameInUrl(req, validHost));
                }
                catch (IOException ioe) {
                    ConsoleServletBase.getDebug().error("ConsoleServletBase.onBeforeRequest, failed to redirect to fully qualified host");
                }
                throw new CompleteRequestException();
            }
        }
        this.validateSSOToken(requestContext);
    }

    private String replaceHostNameInUrl(HttpServletRequest req, String newHostName) {
        StringBuffer buff = new StringBuffer(1024);
        String protocol = RequestUtils.getRedirectProtocol(req.getScheme(), newHostName);
        buff.append(protocol).append("://").append(newHostName).append(req.getRequestURI());
        String queryString = req.getQueryString();
        if (queryString != null) {
            buff.append("?").append(queryString);
        }
        return buff.toString();
    }

    private void validateSSOToken(RequestContext requestContext) throws ServletException {
        try {
            HttpServletRequest req = requestContext.getRequest();
            SSOToken token = this.checkAuthentication(req);
            String enc = token.getProperty("CharSet");
            try {
                String jCharset = BrowserEncoding.mapHttp2JavaCharset(enc);
                req.setCharacterEncoding(jCharset);
            }
            catch (UnsupportedEncodingException ex) {
                ConsoleServletBase.getDebug().error("ConsoleServletBase.validateSSOToken Unsupported encoding", (Throwable)ex);
            }
        }
        catch (SSOException soe) {
            this.browserRedirect(requestContext, this.formGotoUrl(requestContext.getRequest()));
            throw new CompleteRequestException();
        }
    }

    private void browserRedirect(RequestContext requestContext, String url) {
        ViewBeanManager mgr = requestContext.getViewBeanManager();
        AMLoginViewBean vb = (AMLoginViewBean)mgr.getViewBean(AMLoginViewBean.class);
        if (ConsoleServletBase.getDebug().messageEnabled()) {
            ConsoleServletBase.getDebug().message("ConsoleServletBase.browserRedirect redirecting unauthenticated user to " + url);
        }
        vb.setLoginURL(url);
        vb.forwardTo(requestContext);
    }

    protected void onSessionTimeout(RequestContext requestContext) throws ServletException {
    }

    protected void onRequestHandlerNotFound(RequestContext requestContext, String handlerName) throws ServletException {
        ViewBeanManager viewBeanManager = requestContext.getViewBeanManager();
        ViewBean targetView = viewBeanManager.getViewBean(AMInvalidURLViewBean.class);
        targetView.forwardTo(requestContext);
        throw new CompleteRequestException();
    }

    protected void onRequestHandlerNotSpecified(RequestContext requestContext) throws ServletException {
        ViewBeanManager viewBeanManager = requestContext.getViewBeanManager();
        ViewBean targetView = viewBeanManager.getViewBean(AMInvalidURLViewBean.class);
        targetView.forwardTo(requestContext);
        throw new CompleteRequestException();
    }

    protected void onUncaughtException(RequestContext requestContext, Exception e) throws ServletException, IOException {
        ConsoleServletBase.getDebug().error("ConsoleServletBase.onUncaughtException", (Throwable)e);
        requestContext.getResponse().sendRedirect("../base/AMUncaughtException");
    }

    private SSOToken checkAuthentication(HttpServletRequest request) throws SSOException {
        SSOTokenManager manager = SSOTokenManager.getInstance();
        SSOToken ssoToken = manager.createSSOToken(request);
        manager.validateToken(ssoToken);
        return ssoToken;
    }

    private String formGotoUrl(HttpServletRequest request) {
        String protocol;
        String loginURL;
        StringBuffer redirectURL = new StringBuffer(2048);
        String host = request.getHeader("Host");
        if (host == null) {
            ConsoleServletBase.getDebug().message("ConsoleServletBase.formGotoURL Host header is null.");
            host = ConsoleServletBase.getConsoleHost();
        }
        if ((loginURL = SystemProperties.get("com.sun.identity.loginurl")) != null && loginURL.trim().length() > 0) {
            redirectURL.append(loginURL);
        } else if (ConsoleServletBase.isConsoleRemote()) {
            redirectURL.append(ConsoleServletBase.getServerURL()).append(ConsoleServletBase.getServerURI()).append("/UI/Login");
        } else {
            protocol = RequestUtils.getRedirectProtocol(request.getScheme(), host);
            redirectURL.append(protocol).append("://").append(host).append(ConsoleServletBase.getServerURI()).append("/UI/Login");
        }
        redirectURL.append(LOGIN_PARAM);
        if (ConsoleServletBase.isConsoleRemote()) {
            redirectURL.append(ConsoleServletBase.getConsoleURL());
        } else {
            protocol = RequestUtils.getRedirectProtocol(request.getScheme(), host);
            redirectURL.append(protocol).append("://").append(host);
        }
        redirectURL.append(ConsoleServletBase.getConsoleURI()).append(URL_ADMIN_FRAME);
        String amconsoleRedirect = request.getParameter(PARAM_REDIRECT);
        if (amconsoleRedirect != null && amconsoleRedirect.equals("1")) {
            String queryParam = this.getQueryParameters(request);
            redirectURL.append(queryParam);
        }
        return redirectURL.toString();
    }

    private String validateHost(String host) {
        String validHostname = null;
        String hostname = null;
        String port = null;
        int idx = host.indexOf(58);
        if (idx != -1) {
            port = host.substring(idx + 1);
            hostname = host.substring(0, idx);
        } else {
            hostname = host;
        }
        if (!hostname.equalsIgnoreCase(ConsoleServletBase.getConsoleHost()) && (hostname = FQDNUtils.getInstance().getFullyQualifiedHostName(hostname)) != null) {
            if (ConsoleServletBase.isConsoleRemote() && hostname.equals(ConsoleServletBase.getServerHost())) {
                hostname = ConsoleServletBase.getConsoleHost();
            }
            validHostname = port != null ? hostname + ":" + port : hostname;
        }
        return validHostname;
    }

    private String getQueryParameters(HttpServletRequest request) {
        String queryString = request.getQueryString();
        if (queryString != null && queryString.length() > 0) {
            int index = queryString.indexOf(PARAM_REDIRECT);
            if (index != -1) {
                String x = queryString.substring(0, index);
                if (queryString.length() > index + PARAM_REDIRECT.length() + 3) {
                    x = x + queryString.substring(index + PARAM_REDIRECT.length() + 3);
                }
                queryString = x;
            }
            return "&" + queryString;
        }
        return queryString != null ? queryString : "";
    }

    private static String getConsoleHost() {
        return SystemProperties.get("com.iplanet.am.console.host");
    }

    private static String getServerHost() {
        return SystemProperties.get("com.iplanet.am.server.host");
    }

    private static String getConsoleURI() {
        String uri = SystemProperties.get("com.iplanet.am.console.deploymentDescriptor");
        if (uri != null && !uri.startsWith("/")) {
            uri = "/" + uri;
        }
        return uri;
    }

    private static String getServerURI() {
        String uri = SystemProperties.get("com.iplanet.am.services.deploymentDescriptor");
        if (uri != null && !uri.startsWith("/")) {
            uri = "/" + uri;
        }
        return uri;
    }

    private static String getConsoleURL() {
        return SystemProperties.get("com.iplanet.am.console.protocol") + "://" + ConsoleServletBase.getConsoleHost() + ":" + SystemProperties.get("com.iplanet.am.console.port");
    }

    private static String getServerURL() {
        return SystemProperties.get("com.iplanet.am.server.protocol") + "://" + ConsoleServletBase.getServerHost() + ":" + SystemProperties.get("com.iplanet.am.server.port");
    }

    private static boolean isConsoleRemote() {
        return Boolean.valueOf(SystemProperties.get("com.iplanet.am.console.remote"));
    }

    private static Debug getDebug() {
        return Debug.getInstance((String)"amConsole");
    }
}

