/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.base.model;

import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.DisplayFieldImpl;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.html.OptionList;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.console.ui.model.CCMapListModel;
import com.sun.identity.console.ui.model.CCOrderedListModel;
import com.sun.identity.console.ui.model.CCUnOrderedListModel;
import com.sun.identity.console.ui.view.CCGlobalMapList;
import com.sun.identity.console.ui.view.CCMapList;
import com.sun.identity.console.ui.view.CCOrderedList;
import com.sun.identity.console.ui.view.CCUnOrderedList;
import com.sun.identity.shared.locale.Locale;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCAddRemoveModel;
import com.sun.web.ui.model.CCEditableListModel;
import com.sun.web.ui.model.CCEditableListModelInterface;
import com.sun.web.ui.model.CCOrderableListModelInterface;
import com.sun.web.ui.model.CCPropertySheetModel;
import com.sun.web.ui.view.addremove.CCAddRemove;
import com.sun.web.ui.view.editablelist.CCEditableList;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AMPropertySheetModel
extends CCPropertySheetModel {
    private static String UTF_8 = "UTF-8";
    private static String NON_BREAK_SPACE = "\u00a0";
    public static final String TBL_SUB_CONFIG = "tblSubConfig";
    public static final String TBL_SUB_CONFIG_BUTTON_ADD = "tblSubConfigButtonAdd";
    public static final String TBL_SUB_CONFIG_BUTTON_DELETE = "tblSubConfigButtonDelete";
    public static final String TBL_SUB_CONFIG_COL_NAME = "tblSubConfigColName";
    public static final String TBL_SUB_CONFIG_COL_TYPE = "tblSubConfigColType";
    public static final String TBL_SUB_CONFIG_DATA_NAME = "tblSubConfigDataName";
    public static final String TBL_SUB_CONFIG_HREF_NAME = "tblSubConfigHrefName";
    public static final String TBL_SUB_CONFIG_DATA_TYPE = "tblSubConfigDataType";
    private Set children = new HashSet();
    private Set passwordComponents;
    private Map radioDefaultValue;
    private Map childMap;
    private Set dateComponents;
    private Map addRemoveOptions;
    private boolean hasSubConfigTable;
    public static final String ORDERED_LIST = "com.sun.identity.console.ui.taglib.CCOrderedListTag";
    public static final String UNORDERED_LIST = "com.sun.identity.console.ui.taglib.CCUnOrderedListTag";
    public static final String MAP_LIST = "com.sun.identity.console.ui.taglib.CCMapListTag";
    public static final String GLOBAL_MAP_LIST = "com.sun.identity.console.ui.taglib.CCGlobalMapListTag";
    public static final String EDITABLE_LIST = "com.sun.web.ui.taglib.editablelist.CCEditableListTag";
    public static final String ADDREMOVE_LIST = "com.sun.web.ui.taglib.addremove.CCAddRemoveTag";
    public static final String passwordRandom = "KmhUnWR1MYWDYW4xuqdF5nbm+CXIyOVt";

    public AMPropertySheetModel() {
    }

    public Set getChildrenNames() {
        return this.children;
    }

    public AMPropertySheetModel(String name) {
        this.setDocument(new ByteArrayInputStream(name.getBytes()));
    }

    public AMPropertySheetModel(ServletContext sc, String file) {
        super(sc, file);
    }

    public AMPropertySheetModel(InputStream is) {
        super(is);
    }

    public void setDocument(InputStream is) {
        try {
            String strXML = AMPropertySheetModel.toString(is);
            strXML = this.extractAddRemoveOptions(strXML);
            is = new ByteArrayInputStream(strXML.getBytes());
        }
        catch (IOException e) {
            AMModelBase.debug.error("AMPropertySheetModel.setDocument", (Throwable)e);
        }
        super.setDocument(is);
        this.passwordComponents = new HashSet();
        this.dateComponents = new HashSet();
        this.radioDefaultValue = new HashMap();
        this.childMap = new HashMap();
        this.hackToGetChildViews();
    }

    public void registerChildren(ContainerViewBase view) {
        super.registerChildren(view);
        for (String name : this.childMap.keySet()) {
            String tagName = (String)this.childMap.get(name);
            if (tagName == null) continue;
            if (tagName.equals(ORDERED_LIST)) {
                view.registerChild(name, CCOrderedList.class);
                continue;
            }
            if (tagName.equals(UNORDERED_LIST)) {
                view.registerChild(name, CCUnOrderedList.class);
                continue;
            }
            if (tagName.equals(MAP_LIST)) {
                view.registerChild(name, CCMapList.class);
                continue;
            }
            if (tagName.equals(GLOBAL_MAP_LIST)) {
                view.registerChild(name, CCGlobalMapList.class);
                continue;
            }
            if (!tagName.equals(EDITABLE_LIST)) continue;
            view.registerChild(name, CCEditableList.class);
        }
        if (this.hasSubConfigTable) {
            CCActionTableModel model = this.createSubConfigActionTableModel();
            model.registerChildren(view);
        }
    }

    private void hackToGetChildViews() {
        Document document = this.getDocument();
        if (document != null) {
            this.parseNodeList(document.getElementsByTagName("cc"));
        }
    }

    private void parseNodeList(NodeList nodeList) {
        if (nodeList != null) {
            int length = nodeList.getLength();
            for (int i = 0; i < length; ++i) {
                Node node = nodeList.item(i);
                if (!node.hasAttributes()) continue;
                NamedNodeMap nodeAttrs = node.getAttributes();
                Node nameNode = nodeAttrs.getNamedItem("name");
                Node tagclassNode = nodeAttrs.getNamedItem("tagclass");
                if (nameNode == null || tagclassNode == null) continue;
                String name = nameNode.getNodeValue();
                String v = tagclassNode.getNodeValue();
                if (name.startsWith("dateMarker")) {
                    String dateName = name.substring("dateMarker".length());
                    this.dateComponents.add(dateName);
                } else if (v != null) {
                    String def;
                    if (v.equals(EDITABLE_LIST)) {
                        this.setModel(name, new CCEditableListModel());
                    } else if (v.equals("com.sun.web.ui.taglib.html.CCPasswordTag")) {
                        this.passwordComponents.add(name);
                    } else if (v.equals("com.sun.web.ui.taglib.html.CCRadioButtonTag") && (def = this.getNodeDefaultValue(node)) != null) {
                        this.radioDefaultValue.put(name, def);
                    }
                    this.childMap.put(name, v);
                }
                if (!name.equals(TBL_SUB_CONFIG)) continue;
                this.hasSubConfigTable = true;
            }
        }
    }

    private String getNodeDefaultValue(Node n) {
        String defaultValue = null;
        NodeList children = n.getChildNodes();
        if (children != null) {
            int length = children.getLength();
            for (int i = 0; i < length && defaultValue == null; ++i) {
                String name;
                NamedNodeMap nodeAttrs;
                Node nameNode;
                Node node = children.item(i);
                String tagName = node.getNodeName();
                if (!tagName.equals("attribute") || (nameNode = (nodeAttrs = node.getAttributes()).getNamedItem("name")) == null || !(name = nameNode.getNodeValue()).equals("defaultValue")) continue;
                Node valueNode = nodeAttrs.getNamedItem("value");
                defaultValue = valueNode.getNodeValue();
            }
        }
        return defaultValue;
    }

    public void setValues(String name, Object[] values, AMModel model) {
        String val;
        Object m = this.getModel(name);
        if (values != null && values.length == 1 && values[0] instanceof String && ((val = (String)values[0]) == null || val.equals(NON_BREAK_SPACE))) {
            values[0] = "";
        }
        if (m != null && CCEditableListModel.class.isInstance(m)) {
            ((CCEditableListModel)m).setOptionList(AMAdminUtils.toSet(values));
        }
        if (this.passwordComponents.contains(name)) {
            boolean bRandom = false;
            if (values != null && values.length > 0) {
                String tmp = (String)values[0];
                boolean bl = bRandom = tmp != null && tmp.trim().length() > 0;
            }
            if (bRandom) {
                super.setValue(name + "_confirm", (Object)passwordRandom);
                super.setValue(name, (Object)passwordRandom);
            } else {
                super.setValues(name + "_confirm", values);
                super.setValues(name, values);
            }
        } else if (this.dateComponents.contains(name)) {
            super.setValues(name, this.getDateInUserLocale(values, model));
        } else {
            super.setValues(name, values);
        }
    }

    protected Object[] getDateInUserLocale(Object[] dates, AMModel model) {
        Object[] values = null;
        if (dates != null && dates.length > 0) {
            values = new Object[dates.length];
            for (int i = 0; i < dates.length; ++i) {
                Date dt;
                String dateString;
                String tmp = (String)dates[i];
                values[i] = tmp == null ? tmp : ((dateString = Locale.getDateString((Date)(dt = Locale.parseNormalizedDateString((String)tmp)), (java.util.Locale)model.getUserLocale())) != null ? dateString : tmp);
            }
        }
        return values == null ? dates : values;
    }

    public Map getRadioDefaultValues() {
        return this.radioDefaultValue;
    }

    public View createChild(View parent, String name, AMModel model) {
        String tagName = (String)this.childMap.get(name);
        Object view = null;
        if (tagName != null) {
            Object m;
            if (tagName.equals(ORDERED_LIST)) {
                m = new CCOrderedListModel();
                view = new CCOrderedList((ContainerView)parent, (CCOrderableListModelInterface)m, name);
                ((CCOrderedListModel)((Object)m)).setAddButtonLabel(model.getLocalizedString("addremove.orderable.list.add.button"));
                ((CCOrderedListModel)((Object)m)).setDeleteButtonLabel(model.getLocalizedString("addremove.orderable.list.delete.button"));
                this.setModel(name, m);
            } else if (tagName.equals(UNORDERED_LIST)) {
                m = new CCUnOrderedListModel();
                view = new CCUnOrderedList((ContainerView)parent, (CCEditableListModelInterface)m, name);
                this.setModel(name, m);
            } else if (tagName.equals(MAP_LIST) || tagName.equals(GLOBAL_MAP_LIST)) {
                m = new CCMapListModel();
                view = new CCMapList((ContainerView)parent, (CCEditableListModelInterface)m, name);
                ((CCMapListModel)((Object)m)).setKeyLabel(model.getLocalizedString("maplist.key.label"));
                ((CCMapListModel)((Object)m)).setValueLabel(model.getLocalizedString("maplist.value.label"));
                ((CCMapListModel)((Object)m)).setMsgInvalidEntry(model.getLocalizedString("maplist.msg.invalid.entry"));
                ((CCMapListModel)((Object)m)).setMsgInvalidKey(model.getLocalizedString("maplist.msg.invalid.key"));
                ((CCMapListModel)((Object)m)).setMsgInvalidValue(model.getLocalizedString("maplist.msg.invalid.value"));
                ((CCMapListModel)((Object)m)).setMsgInvalidNoKey(model.getLocalizedString("maplist.msg.invalid.nokey"));
                this.setModel(name, m);
            } else if (tagName.equals(ADDREMOVE_LIST) && (m = (CCAddRemoveModel)this.getModel(name)) == null) {
                this.setModel(name, new CCAddRemoveModel());
            }
        }
        if (view == null && CCEditableList.class.isInstance(view = super.createChild(parent, name))) {
            CCEditableList editable = (CCEditableList)view;
            CCEditableListModel m = (CCEditableListModel)editable.getModel();
            m.setAddBtnLabel(model.getLocalizedString("editableList.addButtonLabel"));
            m.setRemoveBtnLabel(model.getLocalizedString("editableList.deleteButtonLabel"));
        }
        this.children.add(view);
        return view;
    }

    private CCActionTableModel createSubConfigActionTableModel() {
        CCActionTableModel tblModel = new CCActionTableModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/tblSubConfig.xml"));
        tblModel.setTitleLabel("label.items");
        tblModel.setActionValue(TBL_SUB_CONFIG_BUTTON_ADD, (Object)"button.new");
        tblModel.setActionValue(TBL_SUB_CONFIG_BUTTON_DELETE, (Object)"button.delete");
        tblModel.setActionValue(TBL_SUB_CONFIG_COL_NAME, (Object)"subconfig.table.column.name");
        tblModel.setActionValue(TBL_SUB_CONFIG_COL_NAME, (Object)"subconfig.table.column.name");
        tblModel.setActionValue(TBL_SUB_CONFIG_COL_TYPE, (Object)"subconfig.table.column.type");
        this.setModel(TBL_SUB_CONFIG, tblModel);
        return tblModel;
    }

    public void clear() {
        super.clear();
        for (View view : this.children) {
            Object m;
            if (CCAddRemove.class.isInstance(view)) {
                m = (CCAddRemoveModel)this.getModel(view.getName());
                m.clear();
                m.setAvailableOptionList(new OptionList());
                m.setSelectedOptionList(new OptionList());
                continue;
            }
            if (CCEditableList.class.isInstance(view)) {
                m = (CCEditableListModel)this.getModel(view.getName());
                m.setOptionList(new OptionList());
                ((CCEditableList)view).resetStateData();
                continue;
            }
            if (CCOrderedList.class.isInstance(view)) {
                m = (CCOrderedListModel)((Object)this.getModel(view.getName()));
                m.setSelectedOptionList(new OptionList());
                ((CCOrderedList)view).resetStateData();
                continue;
            }
            if (CCUnOrderedList.class.isInstance(view)) {
                m = (CCUnOrderedListModel)((Object)this.getModel(view.getName()));
                m.setOptionList(new OptionList());
                ((CCUnOrderedList)view).resetStateData();
                continue;
            }
            if (CCMapList.class.isInstance(view)) {
                m = (CCMapListModel)((Object)this.getModel(view.getName()));
                m.setOptionList(new OptionList());
                ((CCMapList)view).resetStateData();
                continue;
            }
            if (!DisplayFieldImpl.class.isInstance(view)) continue;
            ((DisplayFieldImpl)view).setValues(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toString(InputStream is) throws IOException {
        BufferedReader rawReader = null;
        String content = null;
        try {
            rawReader = new BufferedReader(new InputStreamReader(is));
            StringBuffer buff = new StringBuffer();
            String line = null;
            while ((line = rawReader.readLine()) != null) {
                buff.append(line);
            }
            rawReader.close();
            rawReader = null;
            content = buff.toString();
        }
        finally {
            if (rawReader != null) {
                rawReader.close();
            }
        }
        return content;
    }

    private String extractAddRemoveOptions(String strXML) {
        int idx = strXML.indexOf(ADDREMOVE_LIST);
        this.addRemoveOptions = new HashMap();
        while (idx != -1) {
            String name = this.getPropertyValue(strXML, idx, "name");
            OptionList options = new OptionList();
            idx = strXML.indexOf(">", idx);
            int idx2 = strXML.indexOf("</cc>", idx);
            int idx3 = strXML.indexOf("<option ", idx);
            if (idx2 != -1 && idx3 != -1) {
                while (idx3 != -1 && idx3 < idx2) {
                    int idx4 = strXML.indexOf("/>", idx3);
                    String label = this.getPropertyValue(strXML, idx4, "label");
                    String value = this.getPropertyValue(strXML, idx4, "value");
                    options.add(label, value);
                    strXML = strXML.substring(0, idx3) + strXML.substring(idx4 + 2);
                    idx3 = strXML.indexOf("<option ", idx);
                    idx2 = strXML.indexOf("</cc>", idx);
                }
                this.addRemoveOptions.put(name, options);
                idx = strXML.indexOf(ADDREMOVE_LIST, idx2);
                continue;
            }
            idx = strXML.indexOf(ADDREMOVE_LIST, idx);
        }
        return strXML;
    }

    private String getPropertyValue(String xml, int idx, String name) {
        int idx1 = xml.lastIndexOf(name + "=\"", idx);
        int idx2 = xml.indexOf("\"", idx1 + name.length() + 3);
        return xml.substring(idx1 + name.length() + 2, idx2);
    }

    public OptionList getAddRemoveAvailOptions(String name) {
        return (OptionList)this.addRemoveOptions.get(name);
    }
}

