/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.delegation;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.delegation.DelegationException;
import com.sun.identity.delegation.DelegationManager;
import com.sun.identity.delegation.DelegationPermission;
import com.sun.identity.delegation.DelegationPrivilege;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DelegationUtils {
    static final Debug debug = DelegationManager.debug;
    static final String REALM_NAME_TAG = "REALM";
    static final String SUBJECTS_IN_LEGACY_MODE = "defaultSubjectInLegacyMode";
    static final int AM70_DELEGATION_REVISION = 10;
    private static int revisionNum = 0;

    public static void createRealmPrivileges(SSOToken token, String realmName) throws SSOException, DelegationException {
        String realmId = DNMapper.orgNameToDN(realmName);
        DelegationManager dm = new DelegationManager(token, realmName);
        Set privs = dm.getConfiguredPrivilegeNames();
        if (privs == null || privs.isEmpty()) {
            return;
        }
        if (debug.messageEnabled()) {
            debug.message("DelegationUtils:Getting global privileges");
        }
        Iterator it = privs.iterator();
        while (it.hasNext()) {
            ServiceConfig perm = null;
            String privName = (String)it.next();
            perm = DelegationUtils.getRevisionNumber() == 10 ? DelegationUtils.getPermissionConfig(null, privName, true) : DelegationUtils.getPrivilegeConfig(null, privName, true);
            Map attrs = perm.getAttributes();
            if (attrs == null || attrs.isEmpty()) {
                throw new DelegationException("amDelegation", "get_privilege_attrs_failed", null, null);
            }
            HashSet<String> subjects = null;
            Set configSubjects = (Set)attrs.get(SUBJECTS_IN_LEGACY_MODE);
            if (configSubjects != null && !configSubjects.isEmpty()) {
                Iterator sIter = configSubjects.iterator();
                subjects = new HashSet<String>();
                while (sIter.hasNext()) {
                    String sv = (String)sIter.next();
                    subjects.add(DelegationUtils.swapRealmTag(realmId, sv));
                }
            }
            DelegationPrivilege priv = new DelegationPrivilege(privName, subjects, realmName);
            dm.addPrivilege(priv);
            if (!debug.messageEnabled()) continue;
            debug.message("added " + privName + " privilege in realm " + realmName);
        }
    }

    public static void copyRealmPrivilegesFromParent(SSOToken token, OrganizationConfigManager parent, OrganizationConfigManager child) throws SSOException, DelegationException {
        if (debug.messageEnabled()) {
            debug.message("DelegationUtils.copyRealmPrivilegesFromParent Parent org: " + parent.getOrganizationName() + " Child org: " + child.getOrganizationName());
        }
        DelegationManager pdm = new DelegationManager(token, parent.getOrganizationName());
        DelegationManager cdm = new DelegationManager(token, child.getOrganizationName());
        String childOrgName = DNMapper.orgNameToDN(child.getOrganizationName());
        Set pdps = pdm.getPrivileges();
        if (pdps == null || pdps.isEmpty()) {
            if (debug.messageEnabled()) {
                debug.message("DelegationUtils.copyRealmPrivilegesFromParent: No privilege subjects in parent");
            }
            return;
        }
        for (DelegationPrivilege dp : pdps) {
            Set subjects = dp.getSubjects();
            if (subjects == null || subjects.isEmpty()) {
                if (!debug.messageEnabled()) continue;
                debug.message("DelegationUtils.copyRealmPrivilegesFromParent: No subjects in privilege: " + dp);
                continue;
            }
            HashSet<String> newSubjects = new HashSet<String>();
            for (String sName : subjects) {
                try {
                    AMIdentity id = IdUtils.getIdentity(token, sName);
                    AMIdentity newId = new AMIdentity(token, id.getName(), id.getType(), childOrgName, id.getDN());
                    newSubjects.add(IdUtils.getUniversalId(newId));
                }
                catch (IdRepoException ide) {
                    if (!debug.messageEnabled()) continue;
                    debug.message("DelegationUtils.copyRealmPrivilegesFromParent: IdRepoException for: " + dp, (Throwable)ide);
                }
            }
            dp.setSubjects(newSubjects);
            Set permissions = dp.getPermissions();
            if (permissions != null && !permissions.isEmpty()) {
                for (DelegationPermission perm : permissions) {
                    perm.setOrganizationName("*" + childOrgName);
                }
            }
            cdm.addPrivilege(dp);
            if (!debug.messageEnabled()) continue;
            debug.message("DelegationUtils.copyRealmPrivilegesFromParent: Privilege copied from parent: " + dp);
        }
    }

    public static void deleteRealmPrivileges(SSOToken token, String realmName) throws SSOException, DelegationException {
        DelegationManager dm = new DelegationManager(token, realmName);
        Set privs = dm.getPrivileges();
        if (privs == null || privs.isEmpty()) {
            return;
        }
        for (DelegationPrivilege dp : privs) {
            String privName = dp.getName();
            dm.removePrivilege(privName);
            if (!debug.messageEnabled()) continue;
            debug.message("removed " + privName + " privilege from realm " + realmName);
        }
    }

    static ServiceConfig getPrivilegeConfig(String orgName, String name, boolean global) throws SSOException, DelegationException {
        ServiceConfig orgConfig = null;
        ServiceConfig privsConfig = null;
        ServiceConfig priv = null;
        try {
            ServiceConfigManager scm = new ServiceConfigManager("sunAMDelegationService", DelegationManager.getAdminToken());
            orgConfig = global ? scm.getGlobalConfig(null) : scm.getOrganizationConfig(orgName, null);
        }
        catch (SMSException se) {
            throw new DelegationException("amDelegation", "get_org_config_failed", null, se);
        }
        if (orgConfig == null) {
            throw new DelegationException("amDelegation", "get_privs_config_failed", null, null);
        }
        try {
            privsConfig = orgConfig.getSubConfig("Privileges");
        }
        catch (SMSException se) {
            throw new DelegationException("amDelegation", "get_privs_config_failed", null, se);
        }
        try {
            priv = privsConfig.getSubConfig(name);
        }
        catch (SMSException se) {
            throw new DelegationException("amDelegation", "get_privilege_config_failed", null, se);
        }
        return priv;
    }

    static ServiceConfig getPermissionConfig(String orgName, String name, boolean global) throws SSOException, DelegationException {
        ServiceConfig orgConfig = null;
        ServiceConfig permsConfig = null;
        ServiceConfig perm = null;
        try {
            ServiceConfigManager scm = new ServiceConfigManager("sunAMDelegationService", DelegationManager.getAdminToken());
            orgConfig = global ? scm.getGlobalConfig(null) : scm.getOrganizationConfig(orgName, null);
        }
        catch (SMSException se) {
            throw new DelegationException("amDelegation", "get_org_config_failed", null, se);
        }
        if (orgConfig == null) {
            throw new DelegationException("amDelegation", "get_perms_config_failed", null, null);
        }
        try {
            permsConfig = orgConfig.getSubConfig("Permissions");
        }
        catch (SMSException se) {
            throw new DelegationException("amDelegation", "get_perms_config_failed", null, se);
        }
        try {
            perm = permsConfig.getSubConfig(name);
        }
        catch (SMSException se) {
            throw new DelegationException("amDelegation", "get_permission_config_failed", null, se);
        }
        return perm;
    }

    static String swapRealmTag(String realm, String value) {
        int tagLen = REALM_NAME_TAG.length();
        int idx = value.indexOf(REALM_NAME_TAG);
        while (idx >= 0) {
            String prefix = value.substring(0, idx);
            String suffix = value.substring(idx + tagLen);
            value = prefix + realm + suffix;
            idx = value.indexOf(REALM_NAME_TAG);
        }
        return value;
    }

    static int getRevisionNumber() {
        if (revisionNum == 0) {
            try {
                ServiceSchemaManager ssm = new ServiceSchemaManager("sunAMDelegationService", DelegationManager.getAdminToken());
                revisionNum = ssm.getRevisionNumber();
                if (debug.messageEnabled()) {
                    debug.message("DelegationUtils.getRevisionNumber(): Delegation Service revision number is " + revisionNum);
                }
            }
            catch (SMSException sme) {
                debug.error("DelegationUtils.getRevisionNumber(): Unable to get Delegation revision number", (Throwable)sme);
            }
            catch (SSOException ssoe) {
                debug.error("DelegationUtils.getRevisionNumber(): Unable to get Delegation revision number", (Throwable)((Object)ssoe));
            }
        }
        return revisionNum;
    }
}

