/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement;

import com.sun.identity.entitlement.ConditionDecision;
import com.sun.identity.entitlement.EntitlementCondition;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.PrivilegeManager;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotCondition
implements EntitlementCondition {
    private EntitlementCondition eCondition;
    private String pConditionName;

    public NotCondition() {
    }

    public NotCondition(EntitlementCondition eCondition) {
        this.eCondition = eCondition;
    }

    public NotCondition(EntitlementCondition eConditions, String pConditionName) {
        this.eCondition = eConditions;
        this.pConditionName = pConditionName;
    }

    @Override
    public void setState(String state) {
        try {
            JSONObject jo = new JSONObject(state);
            this.pConditionName = jo.has("pConditionName") ? jo.optString("pConditionName") : null;
            JSONObject memberCondition = jo.optJSONObject("memberECondition");
            if (memberCondition != null) {
                String className = memberCondition.getString("className");
                Class<?> cl = Class.forName(className);
                this.eCondition = (EntitlementCondition)cl.newInstance();
                this.eCondition.setState(memberCondition.getString("state"));
            }
        }
        catch (InstantiationException ex) {
            PrivilegeManager.debug.error("NotCondition.setState", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            PrivilegeManager.debug.error("NotCondition.setState", (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            PrivilegeManager.debug.error("NotCondition.setState", (Throwable)ex);
        }
        catch (JSONException ex) {
            PrivilegeManager.debug.error("NotCondition.setState", (Throwable)ex);
        }
    }

    @Override
    public String getState() {
        return this.toString();
    }

    @Override
    public ConditionDecision evaluate(String realm, Subject subject, String resourceName, Map<String, Set<String>> environment) throws EntitlementException {
        ConditionDecision d = this.eCondition.evaluate(realm, subject, resourceName, environment);
        return new ConditionDecision(!d.isSatisfied(), Collections.EMPTY_MAP);
    }

    public void setECondition(EntitlementCondition eCondition) {
        this.eCondition = eCondition;
    }

    public EntitlementCondition getECondition() {
        return this.eCondition;
    }

    public void setPConditionName(String pConditionName) {
        this.pConditionName = pConditionName;
    }

    public String getPConditionName() {
        return this.pConditionName;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jo = new JSONObject();
        jo.put("pConditionName", (Object)this.pConditionName);
        JSONObject subjo = new JSONObject();
        subjo.put("className", (Object)this.eCondition.getClass().getName());
        subjo.put("state", (Object)this.eCondition.getState());
        jo.put("memberECondition", (Object)subjo);
        return jo;
    }

    public String toString() {
        String s = null;
        try {
            JSONObject jo = this.toJSONObject();
            s = jo == null ? super.toString() : jo.toString(2);
        }
        catch (JSONException e) {
            PrivilegeManager.debug.error("NotCondition.toString()", (Throwable)e);
        }
        return s;
    }

    public boolean equals(Object obj) {
        boolean equalled = true;
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        NotCondition object = (NotCondition)obj;
        if (this.eCondition == null ? object.eCondition != null : !this.eCondition.equals(object.eCondition)) {
            return false;
        }
        if (this.pConditionName == null ? object.pConditionName != null : !this.pConditionName.equals(object.pConditionName)) {
            return false;
        }
        return equalled;
    }

    public int hashCode() {
        int code = 0;
        if (this.eCondition != null) {
            code += this.eCondition.hashCode();
        }
        if (this.pConditionName != null) {
            code += this.pConditionName.hashCode();
        }
        return code;
    }
}

