/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.classloader;

import com.sun.identity.classloader.MaskingClassLoader;
import com.sun.identity.common.SystemConfigurationUtil;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.ServletContext;

public class FAMClassLoader {
    public static ClassLoader cl;
    public static final String FAM_CLASSLOADER_DIR_PATH = "com.sun.identity.classloader.client.jarsPath";
    public static String[] jars;
    public static String[] maskedPackages;
    public static String[] maskedPackages16;
    public static String[] maskedResouces;

    public static ClassLoader getFAMClassLoader(ServletContext context, String[] reqJars) {
        ClassLoader oldcc = Thread.currentThread().getContextClassLoader();
        URL res = oldcc.getResource("com/sun/xml/ws/security/trust/impl/ic/ICContractImpl.class");
        if (res != null && !res.toString().contains("/WEB-INF/lib/webservices-rt.jar")) {
            System.out.println("FAMClassLoader : found new Metro class in global classpath");
            cl = oldcc;
            return cl;
        }
        FAMClassLoader.setSystemProperties();
        if (cl == null) {
            try {
                URL[] urls = null;
                urls = context != null ? FAMClassLoader.jarFinder(context, reqJars) : FAMClassLoader.getJarsFromConfigFile(reqJars);
                ClassLoader localcc = FAMClassLoader.class.getClassLoader();
                String[] mPackages = maskedPackages;
                String version = System.getProperty("java.version");
                if (version != null && version.startsWith("1.6")) {
                    mPackages = maskedPackages16;
                }
                ArrayList<String> mask = new ArrayList<String>(Arrays.asList(mPackages));
                ArrayList<String> maskRes = new ArrayList<String>(Arrays.asList(maskedResouces));
                localcc = new MaskingClassLoader(localcc, mask, maskRes, urls);
                cl = new URLClassLoader(urls, localcc);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (cl != null) {
            Thread.currentThread().setContextClassLoader(cl);
        }
        return cl;
    }

    private static URL[] jarFinder(ServletContext context, String[] reqJars) {
        if (reqJars != null) {
            jars = reqJars;
        }
        URL[] urls = new URL[jars.length];
        try {
            for (int i = 0; i < jars.length; ++i) {
                urls[i] = context.getResource("/WEB-INF/lib/" + jars[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return urls;
    }

    private static URL[] getJarsFromConfigFile(String[] reqJars) {
        if (reqJars != null) {
            jars = reqJars;
        }
        URL[] urls = new URL[jars.length + 1];
        String FILE_BEGIN = "file:";
        String osName = System.getProperty("os.name");
        if (osName != null && osName.toLowerCase().startsWith("windows")) {
            FILE_BEGIN = "file:/";
        }
        String FILE_SEPARATOR = "/";
        String installRoot = System.getProperty("com.sun.aas.installRoot");
        String defaultJarsPath = installRoot + FILE_SEPARATOR + "addons" + FILE_SEPARATOR + "opensso";
        String jarsPath = FILE_BEGIN + SystemConfigurationUtil.getProperty((String)FAM_CLASSLOADER_DIR_PATH, (String)defaultJarsPath) + FILE_SEPARATOR;
        try {
            for (int i = 0; i < jars.length; ++i) {
                urls[i] = new URL(jarsPath + jars[i]);
            }
            urls[FAMClassLoader.jars.length] = new URL(jarsPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return urls;
    }

    private static void setSystemProperties() {
        System.setProperty("javax.xml.soap.MetaFactory", "com.sun.xml.messaging.saaj.soap.SAAJMetaFactoryImpl");
        System.setProperty("javax.xml.soap.MessageFactory", "com.sun.xml.messaging.saaj.soap.ver1_1.SOAPMessageFactory1_1Impl");
        System.setProperty("javax.xml.soap.SOAPConnectionFactory", "com.sun.xml.messaging.saaj.client.p2p.HttpSOAPConnectionFactory");
        System.setProperty("javax.xml.soap.SOAPFactory", "com.sun.xml.messaging.saaj.soap.ver1_1.SOAPFactory1_1Impl");
    }

    static {
        jars = new String[]{"webservices-api.jar", "webservices-rt.jar", "webservices-tools.jar", "webservices-extra-api.jar", "webservices-extra.jar", "opensso.jar", "openssowssproviders.jar", "xalan.jar", "xercesImpl.jar", "openfedlib.jar"};
        maskedPackages = new String[]{"com.sun.istack.tools.", "com.sun.tools.jxc.", "com.sun.tools.xjc.", "com.sun.tools.ws.", "com.sun.codemodel.", "com.sun.relaxng.", "com.sun.xml.xsom.", "com.sun.xml.bind.", "com.sun.xml.bind.v2.", "com.sun.xml.messaging.", "com.sun.xml.ws.", "com.sun.xml.ws.addressing.", "com.sun.xml.ws.api.", "com.sun.xml.ws.api.addressing.", "com.sun.xml.ws.server.", "com.sun.xml.ws.transport.", "com.sun.xml.wss.", "com.sun.xml.security.", "com.sun.xml.xwss.", "javax.xml.bind.", "javax.xml.ws.", "javax.jws.", "javax.jws.soap.", "javax.xml.soap.", "com.sun.istack.", "com.sun.identity.wss.", "com.sun.identity.wssagents.", "com.sun.org.apache.xml.internal.", "com/sun/org/apache/xml/internal/", "com.sun.org.apache.xpath.internal.", "com.sun.org.apache.xalan.internal.", "com.sun.org.apache.xerces.internal.", "com.sun.identity.saml.xmlsig.", "com.sun.identity.saml.", "com.sun.identity.liberty.ws.", "com.sun.identity.xmlenc.", "com.sun.xml.stream."};
        maskedPackages16 = new String[]{"com.sun.istack.tools.", "com.sun.tools.jxc.", "com.sun.tools.xjc.", "com.sun.tools.ws.", "com.sun.codemodel.", "com.sun.relaxng.", "com.sun.xml.xsom.", "com.sun.xml.bind.", "com.sun.xml.bind.v2.", "com.sun.xml.messaging.", "com.sun.xml.ws.", "com.sun.xml.ws.addressing.", "com.sun.xml.ws.api.", "com.sun.xml.ws.api.addressing.", "com.sun.xml.ws.server.", "com.sun.xml.ws.transport.", "com.sun.xml.wss.", "com.sun.xml.security.", "com.sun.xml.xwss.", "javax.xml.bind.", "javax.xml.ws.", "javax.jws.", "javax.jws.soap.", "javax.xml.soap.", "com.sun.istack.", "com.sun.identity.wss.", "com.sun.identity.wssagents.", "com.sun.org.apache.xpath.internal.", "com.sun.org.apache.xalan.internal.", "com.sun.org.apache.xerces.internal.", "com.sun.identity.saml.xmlsig.", "com.sun.identity.xmlenc.", "com.sun.identity.saml.", "com.sun.identity.liberty.ws.", "com.sun.xml.stream.", "javax.xml.crypto.", "org.jcp.xml.dsig."};
        maskedResouces = new String[]{"META-INF/services/javax.xml.bind.JAXBContext", "META-INF/services", "/META-INF/services", "javax/xml/bind/", "com/sun/xml/ws/", "com/sun/xml/wss/", "com/sun/xml/bind/", "com/sun/xml/messaging/", "com/sun/org/apache/xml/internal/"};
    }
}

