/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.workflow;

import com.sun.identity.cot.COTException;
import com.sun.identity.saml2.jaxb.entityconfig.AttributeElement;
import com.sun.identity.saml2.jaxb.entityconfig.EntityConfigElement;
import com.sun.identity.saml2.jaxb.entityconfig.IDPSSOConfigElement;
import com.sun.identity.saml2.jaxb.metadata.EntityDescriptorElement;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.workflow.AddProviderToCOT;
import com.sun.identity.workflow.CreateSAML2HostedProviderTemplate;
import com.sun.identity.workflow.ImportSAML2MetaData;
import com.sun.identity.workflow.Task;
import com.sun.identity.workflow.WorkflowException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBException;

public class ConfigureGoogleApps
extends Task {
    private static String nameidMapping = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified=uid";

    public String execute(Locale locale, Map params) throws WorkflowException {
        String domainIds = this.getString(params, "domainId");
        String entityId = this.getString(params, "idp");
        String realm = this.getString(params, "realm");
        String cot = this.getString(params, "cot");
        if (domainIds.length() <= 0 || domainIds == null) {
            Object[] param = new Object[]{domainIds};
            throw new WorkflowException("domain.is.empty", param);
        }
        this.updateIDPMeta(realm, entityId);
        StringTokenizer st = new StringTokenizer(domainIds, ",");
        while (st.hasMoreTokens()) {
            this.updateSPMeta(realm, cot, st.nextToken().trim());
        }
        Object[] param = new Object[]{entityId};
        return MessageFormat.format(ConfigureGoogleApps.getMessage("google.apps.configured.success", locale), param);
    }

    private void updateIDPMeta(String realm, String entityId) throws WorkflowException {
        try {
            SAML2MetaManager samlManager = new SAML2MetaManager();
            EntityConfigElement entityConfig = samlManager.getEntityConfig(realm, entityId);
            IDPSSOConfigElement idpssoConfig = samlManager.getIDPSSOConfig(realm, entityId);
            List attrList = idpssoConfig.getAttribute();
            if (idpssoConfig != null) {
                for (AttributeElement avpnew : attrList) {
                    String name = avpnew.getName();
                    if (!name.equals("nameIDFormatMap")) continue;
                    ListIterator itt = avpnew.getValue().listIterator();
                    while (itt.hasNext()) {
                        String temp = (String)itt.next();
                        if (!temp.contains("unspecified")) continue;
                        itt.remove();
                    }
                    avpnew.getValue().add(0, nameidMapping);
                }
            }
            samlManager.setEntityConfig(realm, entityConfig);
        }
        catch (SAML2MetaException e) {
            throw new WorkflowException(e.getMessage());
        }
    }

    private void updateSPMeta(String realm, String cot, String domainId) throws WorkflowException {
        String metadata = "<EntityDescriptor entityID=\"google.com/a/" + domainId + "\"" + " xmlns=\"urn" + ":oasis:names:tc:SAML:2.0:metadata\">" + "<SPSSODescriptor protocolSupportEnumeration=\"urn:oasis:nam" + "es:tc:SAML:2.0:protocol\"> <NameIDFormat>urn:oasis:names:t" + "c:SAML:1.1:nameid-format:unspecified</NameIDFormat>" + "<AssertionConsumerService index=\"1\" Binding=\"urn:oasis:na" + "mes:tc:SAML:2.0:bindings:HTTP-POST\"" + " Location=\"https://www.google.com/a/" + domainId + "/acs\" />" + "</SPSSODescriptor></EntityDescriptor>";
        String extendedMeta = null;
        try {
            EntityDescriptorElement e = ImportSAML2MetaData.getEntityDescriptorElement(metadata);
            String eId = e.getEntityID();
            String metaAlias = ConfigureGoogleApps.generateMetaAliasForSP(realm);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("sp", metaAlias);
            extendedMeta = CreateSAML2HostedProviderTemplate.createExtendedDataTemplate(eId, map, null, false);
        }
        catch (SAML2MetaException ex) {
            throw new WorkflowException(ex.getMessage());
        }
        catch (JAXBException ex) {
            throw new WorkflowException(ex.getMessage());
        }
        String[] results = ImportSAML2MetaData.importData(realm, metadata, extendedMeta);
        String entityId = results[1];
        if (cot != null && cot.length() > 0) {
            try {
                AddProviderToCOT.addToCOT(realm, cot, entityId);
            }
            catch (COTException e) {
                throw new WorkflowException(e.getMessage());
            }
        }
    }
}

