/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.provider.plugins;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wss.provider.ProviderException;
import com.sun.identity.wss.provider.ProviderUtils;
import com.sun.identity.wss.provider.STSConfig;
import com.sun.identity.wss.security.PasswordCredential;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class STSAgent
extends STSConfig {
    private static Set attrNames = new HashSet();
    private static final String AGENT_PASSWORD_ATTR = "userpassword";
    private static final String AGENT_DEVICE_STATUS_ATTR = "sunIdentityServerDeviceStatus";
    private static final String AGENT_TYPE_ATTR = "AgentType";
    private static final String ENDPOINT = "STSEndpoint";
    private static final String MEX_ENDPOINT = "STSMexEndpoint";
    private static final String SEC_MECH = "SecurityMech";
    private static final String RESPONSE_SIGN = "isResponseSign";
    private static final String RESPONSE_ENCRYPT = "isResponseEncrypt";
    private static final String REQUEST_SIGN = "isRequestSign";
    private static final String REQUEST_ENCRYPT = "isRequestEncrypt";
    private static final String REQUEST_HEADER_ENCRYPT = "isRequestHeaderEncrypt";
    private static final String USER_NAME = "UserName";
    private static final String USER_PASSWORD = "UserPassword";
    private static final String USER_CREDENTIAL = "UserCredential";
    private static final String STS_CONFIG = "STS";
    private static final String PRIVATE_KEY_ALIAS = "privateKeyAlias";
    private static final String PUBLIC_KEY_ALIAS = "publicKeyAlias";
    private static final String KDC_SERVER = "KerberosDomainServer";
    private static final String KDC_DOMAIN = "KerberosDomain";
    private static final String KRB_SERVICE_PRINCIPAL = "KerberosServicePrincipal";
    private static final String KRB_TICKET_CACHE_DIR = "KerberosTicketCacheDir";
    private static final String ENCRYPTION_ALG = "EncryptionAlgorithm";
    private static final String ENCRYPTION_STRENGTH = "EncryptionStrength";
    private static final String SIGNING_REF_TYPE = "SigningRefType";
    private static final String PROTOCOL_VERSION = "WSTrustVersion";
    private static final String SAML_ATTRIBUTE_MAPPING = "SAMLAttributeMapping";
    private static final String INCLUDE_MEMBERSHIPS = "includeMemberships";
    private static final String SAML_ATTRIBUTE_NS = "AttributeNamespace";
    private static final String NAMEID_MAPPER = "NameIDMapper";
    private static Debug debug = ProviderUtils.debug;
    private AMIdentityRepository idRepo;
    private boolean profilePresent = false;
    private SSOToken token = null;

    public STSAgent() {
    }

    public STSAgent(AMIdentity amIdentity) throws ProviderException {
        try {
            this.name = amIdentity.getName();
            this.type = amIdentity.getType().getName();
            if (debug.messageEnabled()) {
                debug.message("STSAgent: name = " + this.name + "type = " + this.type);
            }
            Map attributes = amIdentity.getAttributes(attrNames);
            this.parseAgentKeyValues(attributes);
        }
        catch (IdRepoException ire) {
            debug.error("STSAgent.constructor: Idrepo exception", (Throwable)ire);
            throw new ProviderException(ire.getMessage());
        }
        catch (SSOException se) {
            debug.error("STSAgent.constructor: SSO exception", (Throwable)se);
            throw new ProviderException(se.getMessage());
        }
    }

    public void init(String name, String type, SSOToken token) throws ProviderException {
        this.name = name;
        this.type = type;
        this.token = token;
        if (debug.messageEnabled()) {
            debug.message("STSAgent: name = " + name + "type = " + type);
        }
        try {
            AMIdentity provider = new AMIdentity(token, name, IdType.AGENT, "/", null);
            if (!provider.isExists()) {
                if (debug.messageEnabled()) {
                    debug.message("STSAgent.init: provider " + name + "does not exist");
                }
                return;
            }
            Map attributes = provider.getAttributes(attrNames);
            this.profilePresent = true;
            this.parseAgentKeyValues(attributes);
        }
        catch (IdRepoException ire) {
            if (ire.getErrorCode().equals("402")) {
                this.profilePresent = false;
                return;
            }
            debug.error("STSAgent.init: Unable to get idRepo", (Throwable)ire);
            throw new ProviderException("idRepo exception: " + ire.getMessage());
        }
        catch (Exception e) {
            debug.error("STSAgent.init: Unable to get idRepo", (Throwable)e);
            throw new ProviderException("idRepo exception: " + e.getMessage());
        }
    }

    private void parseAgentKeyValues(Map attributes) throws ProviderException {
        if (attributes == null || attributes.isEmpty()) {
            return;
        }
        if (debug.messageEnabled()) {
            debug.message("STSAgent.parseAgentKeyValues::" + attributes);
        }
        for (String key : attributes.keySet()) {
            Set valSet = (Set)attributes.get(key);
            String value = null;
            if (valSet != null && valSet.size() > 0) {
                Iterator iter = valSet.iterator();
                StringBuffer sb = new StringBuffer(100);
                while (iter.hasNext()) {
                    sb.append((String)iter.next()).append(",");
                }
                sb = sb.deleteCharAt(sb.length() - 1);
                value = sb.toString();
            }
            this.setConfig(key, value);
        }
    }

    private void setConfig(String attr, String value) {
        if (attr.equals(ENDPOINT)) {
            this.endpoint = value;
        } else if (attr.equals(MEX_ENDPOINT)) {
            this.mexEndpoint = value;
        } else if (attr.equals(SEC_MECH)) {
            if (this.secMech == null) {
                this.secMech = new ArrayList();
            }
            StringTokenizer st = new StringTokenizer(value, ",");
            while (st.hasMoreTokens()) {
                this.secMech.add(st.nextToken());
            }
        } else if (attr.equals(RESPONSE_SIGN)) {
            this.isResponseSigned = Boolean.valueOf(value);
        } else if (attr.equals(RESPONSE_ENCRYPT)) {
            this.isResponseEncrypted = Boolean.valueOf(value);
        } else if (attr.equals(REQUEST_SIGN)) {
            this.isRequestSigned = Boolean.valueOf(value);
        } else if (attr.equals(REQUEST_ENCRYPT)) {
            this.isRequestEncrypted = Boolean.valueOf(value);
        } else if (attr.equals(REQUEST_HEADER_ENCRYPT)) {
            this.isRequestHeaderEncrypted = Boolean.valueOf(value);
        } else if (attr.equals(PRIVATE_KEY_ALIAS)) {
            this.privateKeyAlias = value;
        } else if (attr.equals(STS_CONFIG)) {
            this.stsConfigName = value;
        } else if (attr.equals(PUBLIC_KEY_ALIAS)) {
            this.publicKeyAlias = value;
        } else if (attr.equals(USER_CREDENTIAL)) {
            if (value != null && value.length() != 0) {
                if (this.usercredentials == null) {
                    this.usercredentials = new ArrayList();
                }
                StringTokenizer stVal = new StringTokenizer(value, ",");
                while (stVal.hasMoreTokens()) {
                    StringTokenizer st1;
                    String tmpVal = stVal.nextToken();
                    int index = tmpVal.indexOf("|");
                    if (index == -1) {
                        return;
                    }
                    String usertmp = tmpVal.substring(0, index);
                    String passwordtmp = tmpVal.substring(index + 1, tmpVal.length());
                    String user = null;
                    String password = null;
                    StringTokenizer st = new StringTokenizer(usertmp, ":");
                    if (USER_NAME.equals(st.nextToken()) && st.hasMoreTokens()) {
                        user = st.nextToken();
                    }
                    if (USER_PASSWORD.equals((st1 = new StringTokenizer(passwordtmp, ":")).nextToken()) && st1.hasMoreTokens()) {
                        password = st1.nextToken();
                    }
                    if (user == null || password == null) continue;
                    PasswordCredential credential = new PasswordCredential(user, password);
                    this.usercredentials.add(credential);
                }
            }
        } else if (attr.equals(KDC_DOMAIN)) {
            this.kdcDomain = value;
        } else if (attr.equals(KRB_SERVICE_PRINCIPAL)) {
            this.servicePrincipal = value;
        } else if (attr.equals(KRB_TICKET_CACHE_DIR)) {
            this.ticketCacheDir = value;
        } else if (attr.equals(KDC_SERVER)) {
            this.kdcServer = value;
        } else if (attr.equals(SIGNING_REF_TYPE)) {
            if (value != null && value.length() != 0) {
                this.signingRefType = value;
            }
        } else if (attr.equals(ENCRYPTION_ALG)) {
            if (value != null && value.length() != 0) {
                this.encryptionAlgorithm = value;
            }
        } else if (attr.equals(ENCRYPTION_STRENGTH)) {
            if (value != null && value.length() != 0) {
                this.encryptionStrength = Integer.parseInt(value);
            }
        } else if (attr.equals(PROTOCOL_VERSION)) {
            if (value != null && value.length() != 0) {
                this.protocolVersion = value;
            }
        } else if (attr.equals(SAML_ATTRIBUTE_MAPPING)) {
            if (this.samlAttributes == null) {
                this.samlAttributes = new HashSet();
            }
            if (value == null) {
                return;
            }
            StringTokenizer st = new StringTokenizer(value, ",");
            while (st.hasMoreTokens()) {
                this.samlAttributes.add(st.nextToken());
            }
        } else if (attr.equals(INCLUDE_MEMBERSHIPS)) {
            if (value != null && value.length() != 0) {
                this.includeMemberships = Boolean.valueOf(value);
            }
        } else if (attr.equals(SAML_ATTRIBUTE_NS)) {
            this.attributeNS = value;
        } else if (attr.equals(NAMEID_MAPPER)) {
            this.nameIDMapper = value;
        }
    }

    public void delete() throws ProviderException {
        if (!this.profilePresent) {
            return;
        }
        try {
            if (this.idRepo == null) {
                this.idRepo = new AMIdentityRepository(this.token, "/");
            }
            AMIdentity id = new AMIdentity(this.token, this.name, IdType.AGENT, "/", null);
            HashSet<AMIdentity> identities = new HashSet<AMIdentity>();
            identities.add(id);
            this.idRepo.deleteIdentities(identities);
        }
        catch (Exception e) {
            debug.error("STSAgent.delete: Unable to get idRepo", (Throwable)e);
            throw new ProviderException("idRepo exception: " + e.getMessage());
        }
    }

    public void store() throws ProviderException {
        Iterator iter;
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(AGENT_TYPE_ATTR, this.type);
        config.put(AGENT_PASSWORD_ATTR, this.name);
        config.put(AGENT_DEVICE_STATUS_ATTR, "Active");
        if (this.endpoint != null) {
            config.put(ENDPOINT, this.endpoint);
        }
        if (this.mexEndpoint != null) {
            config.put(MEX_ENDPOINT, this.mexEndpoint);
        }
        if (this.privateKeyAlias != null) {
            config.put(PRIVATE_KEY_ALIAS, this.privateKeyAlias);
        }
        if (this.publicKeyAlias != null) {
            config.put(PUBLIC_KEY_ALIAS, this.publicKeyAlias);
        }
        if (this.stsConfigName != null) {
            config.put(STS_CONFIG, this.stsConfigName);
        }
        if (this.kdcServer != null) {
            config.put(KDC_SERVER, this.kdcServer);
        }
        if (this.kdcDomain != null) {
            config.put(KDC_DOMAIN, this.kdcDomain);
        }
        if (this.servicePrincipal != null) {
            config.put(KRB_SERVICE_PRINCIPAL, this.servicePrincipal);
        }
        if (this.ticketCacheDir != null) {
            config.put(KRB_TICKET_CACHE_DIR, this.ticketCacheDir);
        }
        HashSet<String> secMechSet = new HashSet<String>();
        if (this.secMech != null) {
            iter = this.secMech.iterator();
            while (iter.hasNext()) {
                secMechSet.add((String)iter.next());
            }
        }
        config.put(RESPONSE_SIGN, Boolean.toString(this.isResponseSigned));
        config.put(RESPONSE_ENCRYPT, Boolean.toString(this.isResponseEncrypted));
        config.put(REQUEST_SIGN, Boolean.toString(this.isRequestSigned));
        config.put(REQUEST_ENCRYPT, Boolean.toString(this.isRequestEncrypted));
        config.put(REQUEST_HEADER_ENCRYPT, Boolean.toString(this.isRequestHeaderEncrypted));
        if (this.usercredentials != null) {
            iter = this.usercredentials.iterator();
            StringBuffer sb = new StringBuffer(100);
            while (iter.hasNext()) {
                PasswordCredential cred = (PasswordCredential)iter.next();
                String user = cred.getUserName();
                String password = cred.getPassword();
                if (user == null || password == null) continue;
                sb.append(USER_NAME).append(":").append(user).append("|").append(USER_PASSWORD).append(":").append(password).append(",");
            }
            sb = sb.deleteCharAt(sb.length() - 1);
            config.put(USER_CREDENTIAL, sb.toString());
        }
        if (this.signingRefType != null) {
            config.put(SIGNING_REF_TYPE, this.signingRefType);
        }
        if (this.encryptionAlgorithm != null) {
            config.put(ENCRYPTION_ALG, this.encryptionAlgorithm);
        }
        config.put(ENCRYPTION_STRENGTH, new Integer(this.encryptionStrength).toString());
        if (this.protocolVersion != null) {
            config.put(PROTOCOL_VERSION, this.protocolVersion);
        }
        if (this.attributeNS != null) {
            config.put(SAML_ATTRIBUTE_NS, this.attributeNS);
        }
        if (this.nameIDMapper != null) {
            config.put(NAMEID_MAPPER, this.nameIDMapper);
        }
        if (this.includeMemberships) {
            config.put(INCLUDE_MEMBERSHIPS, Boolean.toString(this.includeMemberships));
        }
        try {
            HashMap<String, Set> attributes = new HashMap<String, Set>();
            HashSet<String> values = null;
            for (String key : config.keySet()) {
                String value = (String)config.get(key);
                values = new HashSet<String>();
                values.add(value);
                attributes.put(key, values);
            }
            if (secMechSet != null) {
                attributes.put(SEC_MECH, secMechSet);
            }
            if (this.samlAttributes != null && !this.samlAttributes.isEmpty()) {
                attributes.put(SAML_ATTRIBUTE_MAPPING, this.samlAttributes);
            }
            if (this.profilePresent) {
                attributes.remove(AGENT_TYPE_ATTR);
                AMIdentity id = new AMIdentity(this.token, this.name, IdType.AGENT, "/", null);
                if (debug.messageEnabled()) {
                    debug.message("Attributes to be stored: " + attributes);
                }
                id.setAttributes(attributes);
                id.store();
            } else {
                if (this.idRepo == null) {
                    this.idRepo = new AMIdentityRepository(this.token, "/");
                }
                this.idRepo.createIdentity(IdType.AGENT, this.name, attributes);
            }
        }
        catch (Exception e) {
            debug.error("STSAgent.store: Unable to get idRepo", (Throwable)e);
            throw new ProviderException("idRepo exception: " + e.getMessage());
        }
    }

    private String getKeyValue(String key, String value) {
        return key + "=" + value;
    }

    static {
        attrNames.add(ENDPOINT);
        attrNames.add(MEX_ENDPOINT);
        attrNames.add(SEC_MECH);
        attrNames.add(RESPONSE_SIGN);
        attrNames.add(RESPONSE_ENCRYPT);
        attrNames.add(REQUEST_SIGN);
        attrNames.add(REQUEST_ENCRYPT);
        attrNames.add(REQUEST_HEADER_ENCRYPT);
        attrNames.add(USER_CREDENTIAL);
        attrNames.add(STS_CONFIG);
        attrNames.add(PRIVATE_KEY_ALIAS);
        attrNames.add(PUBLIC_KEY_ALIAS);
        attrNames.add(KDC_SERVER);
        attrNames.add(KDC_DOMAIN);
        attrNames.add(KRB_SERVICE_PRINCIPAL);
        attrNames.add(KRB_TICKET_CACHE_DIR);
        attrNames.add(ENCRYPTION_ALG);
        attrNames.add(ENCRYPTION_STRENGTH);
        attrNames.add(SIGNING_REF_TYPE);
        attrNames.add(PROTOCOL_VERSION);
        attrNames.add(INCLUDE_MEMBERSHIPS);
        attrNames.add(SAML_ATTRIBUTE_MAPPING);
        attrNames.add(SAML_ATTRIBUTE_NS);
        attrNames.add(NAMEID_MAPPER);
    }
}

