/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.unix;

import com.sun.identity.authentication.spi.AuthenticationException;
import com.sun.identity.shared.debug.Debug;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ResourceBundle;

public class UnixHelper {
    protected static final int DAEMON_TIMEOUT_mS = 7500;
    private final int MAXLOOP = 200;
    private Socket sock = null;
    private BufferedReader reader = null;
    private PrintWriter writer = null;
    private static final String charSet = "ISO8859_1";
    public static Debug debug;

    public UnixHelper(int port, String bundleName) throws AuthenticationException {
        debug = Debug.getInstance((String)"amUnixHelper");
        debug.message("unix helper...init");
        try {
            this.sock = new Socket("127.0.0.1", port);
            this.sock.setSoTimeout(7500);
            this.reader = new BufferedReader(new InputStreamReader(this.sock.getInputStream(), charSet));
            this.writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.sock.getOutputStream(), charSet)));
        }
        catch (UnknownHostException e) {
            throw new AuthenticationException(bundleName, "UnixHelperLocalhost", null);
        }
        catch (IOException ex) {
            throw new AuthenticationException(bundleName, "UnixHelperIOEx", null);
        }
    }

    protected synchronized int do_write(String cmd) {
        this.writer.println(cmd);
        this.writer.flush();
        return cmd.length();
    }

    public String do_read(int readsize, ResourceBundle bundle) throws IOException {
        char[] buf = new char[254];
        debug.message("in do_read...");
        int i = this.reader.read(buf, 0, readsize);
        String readstring = new String(buf);
        try {
            if (!readstring.equals(new String(readstring.getBytes("ASCII"), "ASCII"))) {
                throw new IOException(bundle.getString("UnixHelperInputNotASCII"));
            }
        }
        catch (UnsupportedEncodingException ueex) {
            debug.message("Unsupported coding ...");
            throw new IOException(bundle.getString("UnixHelperInputEncodingException"));
        }
        debug.message("returng... readString... " + readstring);
        return readstring;
    }

    public int configHelper(String helper_port, String helper_timeout, String helper_threads, Debug debug, ResourceBundle bundle) {
        String instring;
        try {
            instring = this.do_read(254, bundle);
        }
        catch (IOException ex) {
            return -1;
        }
        if (!instring.startsWith("Enter Unix Helper Listen Port")) {
            return -2;
        }
        int i = this.do_write(helper_port);
        try {
            instring = this.do_read(254, bundle);
        }
        catch (IOException ex) {
            return -3;
        }
        if (!instring.startsWith("Enter Unix Helper Session Timeout")) {
            return -4;
        }
        i = this.do_write(helper_timeout);
        try {
            instring = this.do_read(254, bundle);
        }
        catch (IOException ex) {
            return -5;
        }
        if (!instring.startsWith("Enter Unix Helper Max Sessions")) {
            return -6;
        }
        i = this.do_write(helper_threads);
        try {
            instring = this.do_read(254, bundle);
        }
        catch (IOException ex) {
            return -7;
        }
        if (!instring.startsWith("get_config_info: amunixd configured successfully")) {
            return -8;
        }
        return 0;
    }

    public int authenticate(String userlogin, String userpass, String serviceModule, String clientIPAddr, ResourceBundle bundle) {
        int MAXSCREEN = 1000;
        int maxloop = 200;
        int k = 1000;
        if (debug.messageEnabled()) {
            debug.message("authenticate.....userlogin" + userlogin);
            debug.message("authenticate.....serviceModule" + serviceModule);
        }
        do {
            int i;
            String instring = "";
            try {
                debug.message("calling do_read");
                instring = this.do_read(254, bundle);
                debug.message("after do_read");
            }
            catch (IOException ex) {
                return -1;
            }
            if (instring.length() == 0) {
                return -1;
            }
            debug.message("Instring is.. : " + instring);
            if (instring.startsWith("Enter Unix login:")) {
                i = this.do_write(userlogin);
                k = 1000;
            } else if (instring.startsWith("Enter password:")) {
                i = this.do_write(userpass);
                k = 1000;
            } else if (instring.startsWith("Enter Service Name :")) {
                debug.message("writing service name");
                i = this.do_write(serviceModule);
                debug.message("after writing service name" + i);
                k = 1000;
            } else if (instring.startsWith("Enter Client IP Address:")) {
                i = clientIPAddr != null ? this.do_write(clientIPAddr) : this.do_write("0.0.0.0");
                k = 1000;
            } else if (instring.startsWith("Authentication passed")) {
                k = 0;
            } else if (instring.startsWith("Access denied")) {
                k = -1;
            } else if (instring.startsWith("unknown return code ")) {
                k = -1;
            } else if (instring.startsWith("Processing timed-")) {
                k = -1;
            } else if (instring.startsWith("Processing erro")) {
                k = -1;
            } else if (instring.startsWith("Authentication Failed")) {
                k = -1;
                if (instring.indexOf("Password Expired") != -1) {
                    debug.message("password expired for " + userlogin);
                    k = 2;
                }
            } else {
                k = 1000;
            }
            if (--maxloop != 0) continue;
            k = -1;
        } while (k == 1000);
        debug.message("returning... k from authenticate" + k);
        return k;
    }

    protected synchronized void destroy(ResourceBundle bundle) {
        try {
            if (this.writer != null) {
                this.writer.flush();
                this.writer.close();
                this.writer = null;
            }
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
            if (this.sock != null) {
                this.sock.close();
                this.sock = null;
            }
        }
        catch (IOException e) {
            System.err.println(bundle.getString("UnixDestroyIOEx"));
            System.exit(1);
        }
        catch (Exception ee) {
            System.err.println(bundle.getString("UnixDestroyEx") + ee.getMessage());
        }
    }
}

