/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.util;

import java.io.ByteArrayInputStream;

public class DerValue {
    private byte tag = 0;
    private int length = 0;
    private byte[] data = null;

    public DerValue(byte[] data) {
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        this.init(stream);
    }

    public DerValue(ByteArrayInputStream input) {
        this.init(input);
    }

    public byte getTag() {
        return this.tag;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getData() {
        return this.data;
    }

    private void init(ByteArrayInputStream input) {
        this.tag = (byte)input.read();
        this.length = this.getLength(input);
        this.data = new byte[this.length];
        input.read(this.data, 0, this.length);
    }

    private int getLength(ByteArrayInputStream input) {
        int value = 0;
        int tmp = input.read();
        if ((tmp & 0x80) == 0) {
            value = tmp;
        } else {
            tmp &= 0x7F;
            value = 0;
            while (tmp > 0) {
                byte tmpbyte = (byte)input.read();
                value = value * 256 + (tmpbyte & 0xFF);
                --tmp;
            }
        }
        return value;
    }

    public static String printByte(byte code) {
        return Integer.toHexString((code & 0xF0) >> 4 & 0xF) + Integer.toHexString(code & 0xF & 0xF);
    }

    public static String printByteArray(byte[] token, int from, int len) {
        int j;
        StringBuffer buf = new StringBuffer();
        int bytePerLine = 16;
        int line = 1;
        while (line * bytePerLine < len) {
            for (j = 0; j < bytePerLine; ++j) {
                buf.append(DerValue.printByte(token[(line - 1) * bytePerLine + j + from]) + " ");
            }
            buf.append("\n");
            ++line;
        }
        if (--line * bytePerLine < len) {
            for (j = line * bytePerLine; j < len; ++j) {
                buf.append(DerValue.printByte(token[j + from]) + " ");
            }
        }
        return buf.toString();
    }
}

