/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.schema;

import com.iplanet.sso.SSOException;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.schema.SchemaCommand;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class RemoveSubSchema
extends SchemaCommand {
    static final String ARGUMENT_SCHEMA_NAMES = "subschemanames";

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        String serviceName = this.getStringOptionValue("servicename");
        String schemaType = this.getStringOptionValue("schematype");
        String subSchemaName = this.getStringOptionValue("subschemaname");
        List schemaNames = rc.getOption(ARGUMENT_SCHEMA_NAMES);
        IOutput outputWriter = this.getOutputWriter();
        if (subSchemaName == null) {
            subSchemaName = "/";
        }
        String[] params = new String[4];
        params[0] = serviceName;
        params[1] = schemaType;
        params[2] = subSchemaName;
        ServiceSchema ss = this.getServiceSchema();
        String schemaName = "";
        try {
            Iterator iter = schemaNames.iterator();
            while (iter.hasNext()) {
                params[3] = schemaName = (String)iter.next();
                this.writeLog(0, Level.INFO, "ATTEMPT_REMOVE_SUB_SCHEMA", params);
                ss.removeSubSchema(schemaName);
                this.writeLog(0, Level.INFO, "SUCCEED_REMOVE_SUB_SCHEMA", params);
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("remove-subschema-succeed"), params));
            }
        }
        catch (SSOException e) {
            String[] args = new String[]{serviceName, schemaType, subSchemaName, schemaName, e.getMessage()};
            this.debugError("RemoveSubSchema.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_REMOVE_SUB_SCHEMA", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{serviceName, schemaType, subSchemaName, schemaName, e.getMessage()};
            this.debugError("RemoveSubSchema.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_REMOVE_SUB_SCHEMA", args);
            throw new CLIException(e, 127);
        }
    }
}

