/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.serverconfig;

import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.RequestContext;
import java.net.MalformedURLException;
import java.net.URL;

public class ServerConfigBase
extends AuthenticatedCommand {
    protected static final String DEFAULT_SVR_CONFIG = "default";

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        String serverName = this.getStringOptionValue("servername");
        if (serverName != null && serverName.trim().length() > 0 && !serverName.equals(DEFAULT_SVR_CONFIG)) {
            try {
                URL url = new URL(serverName);
                if (url.getPort() == -1) {
                    throw new CLIException(this.getResourceString("server-config-port-missing"), 127);
                }
                if (url.getPath().length() == 0) {
                    throw new CLIException(this.getResourceString("server-config-uri-missing"), 127);
                }
            }
            catch (MalformedURLException e) {
                throw new CLIException(e, 127);
            }
        }
    }
}

