/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.util;

import java.util.ArrayList;

public class LogRecordSorter {
    public ArrayList unSortedRecords;
    public String[][] sortedArray;
    String sortingField;
    int sortingFieldPos = -1;

    public LogRecordSorter(String fieldName, ArrayList allRecs) throws NoSuchFieldException {
        this.sortingField = fieldName;
        this.unSortedRecords = allRecs;
        String[] fields = (String[])this.unSortedRecords.get(0);
        int len = fields.length;
        this.sortedArray = new String[this.unSortedRecords.size()][];
        boolean fieldPresent = false;
        this.sortedArray[0] = (String[])this.unSortedRecords.get(0);
        for (int i = 0; i < len; ++i) {
            if (fieldName.compareToIgnoreCase(fields[i]) != 0) continue;
            fieldPresent = true;
            this.sortingFieldPos = i;
            break;
        }
        if (!fieldPresent) {
            String errorMsg = "no such field named " + fieldName + " ";
            throw new NoSuchFieldException(errorMsg);
        }
    }

    public String[][] getSortedRecords() throws IllegalArgumentException, RuntimeException {
        if (this.sortingFieldPos < 0) {
            throw new IllegalArgumentException("wrong sort by fieldname");
        }
        int recordSize = this.unSortedRecords.size();
        for (int i = 1; i < recordSize; ++i) {
            String[] debug = (String[])this.unSortedRecords.get(i);
            try {
                this.insert(i, (String[])this.unSortedRecords.get(i));
                continue;
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Problem while sorting");
            }
        }
        return this.sortedArray;
    }

    private void insert(int length, String[] record) {
        if (length == 1) {
            this.sortedArray[1] = record;
        } else if (length == 2) {
            String[] strArr = this.sortedArray[1];
            String str = strArr[this.sortingFieldPos];
            if (str.compareTo(record[this.sortingFieldPos]) > 0) {
                this.sortedArray[2] = this.sortedArray[1];
                this.sortedArray[1] = record;
            } else {
                this.sortedArray[2] = record;
            }
        } else if (length == 3) {
            String[] strArr = this.sortedArray[1];
            String[] str1Arr = this.sortedArray[2];
            String str = strArr[this.sortingFieldPos];
            String str1 = str1Arr[this.sortingFieldPos];
            if (str.compareTo(record[this.sortingFieldPos]) > 0) {
                this.push(1);
                this.sortedArray[1] = record;
            } else if (str1.compareTo(record[this.sortingFieldPos]) > 0) {
                this.push(2);
                this.sortedArray[2] = record;
            } else {
                this.push(3);
                this.sortedArray[3] = record;
            }
        } else {
            String grp = null;
            int start = 1;
            int end = length - 1;
            int diff = end - start;
            int mid = 0;
            mid = diff % 2 == 0 ? diff / 2 : (diff - 1) / 2;
            String[] strArr = this.sortedArray[mid];
            String str = strArr[this.sortingFieldPos];
            while (true) {
                if (str.compareTo(record[this.sortingFieldPos]) > 0) {
                    grp = "Left";
                    end = mid;
                    diff = end - start;
                    if (diff == 0) break;
                    mid = diff % 2 == 0 ? start + diff / 2 : start + (diff - 1) / 2;
                    strArr = this.sortedArray[mid];
                    str = strArr[this.sortingFieldPos];
                    continue;
                }
                grp = "Right";
                start = mid + 1;
                diff = end - start;
                if (diff == 0) break;
                mid = diff % 2 == 0 ? start + diff / 2 : start + (diff - 1) / 2;
                strArr = this.sortedArray[mid];
                str = strArr[this.sortingFieldPos];
            }
            if (grp.equalsIgnoreCase("Right") && diff == 0) {
                int index = end;
                String[] str1Arr = this.sortedArray[index - 1];
                String[] str2Arr = this.sortedArray[index];
                String str1 = str1Arr[this.sortingFieldPos];
                String str2 = str2Arr[this.sortingFieldPos];
                if (str1.compareTo(record[this.sortingFieldPos]) > 0) {
                    this.push(index - 1);
                    this.sortedArray[index - 1] = record;
                } else if (str2.compareTo(record[this.sortingFieldPos]) > 0) {
                    this.push(index);
                    this.sortedArray[index] = record;
                } else {
                    this.push(index + 1);
                    this.sortedArray[index + 1] = record;
                }
            } else if (grp.equalsIgnoreCase("Left") && diff == 0) {
                int index = start;
                String[] str1Arr = this.sortedArray[index];
                String[] str2Arr = this.sortedArray[index + 1];
                String str1 = str1Arr[this.sortingFieldPos];
                String str2 = str2Arr[this.sortingFieldPos];
                if (str1.compareTo(record[this.sortingFieldPos]) > 0) {
                    this.push(index);
                    this.sortedArray[index] = record;
                } else if (str2.compareTo(record[this.sortingFieldPos]) > 0) {
                    this.push(index + 1);
                    this.sortedArray[index + 1] = record;
                } else {
                    this.push(index + 2);
                    this.sortedArray[index + 2] = record;
                }
            }
        }
    }

    void push(int from) {
        int len = this.sortedArray.length;
        if (--len == 0) {
            return;
        }
        while (from < len) {
            this.sortedArray[len] = this.sortedArray[len - 1];
            --len;
        }
    }
}

