/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.password.plugins;

import com.iplanet.am.util.AMSendMail;
import com.iplanet.am.util.Locale;
import com.iplanet.services.cdm.G11NSettings;
import com.iplanet.sso.SSOException;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.password.plugins.NotifyPassword;
import com.sun.identity.password.ui.model.PWResetException;
import com.sun.identity.password.ui.model.PWResetModel;
import com.sun.identity.password.ui.model.PWResetModelImpl;
import com.sun.identity.password.ui.model.PWResetResBundleCacher;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Set;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;

public class EmailPassword
implements NotifyPassword {
    private PWResetModel model = new PWResetModelImpl();
    private static G11NSettings g11nSettings = G11NSettings.getInstance();
    private static String bundleName = "amPasswordResetModuleMsgs";
    private java.util.Locale userLocale = null;

    public void notifyPassword(AMIdentity user, String password, java.util.Locale locale) throws PWResetException {
        ResourceBundle rb = null;
        try {
            Set set = user.getAttribute("mail");
            Set localeSet = user.getAttribute("preferredlocale");
            if (localeSet == null || localeSet.isEmpty()) {
                this.userLocale = locale;
            } else {
                String localeStr = localeSet.iterator().next().toString();
                this.userLocale = Locale.getLocale(localeStr);
            }
            rb = PWResetResBundleCacher.getBundle(bundleName, this.userLocale);
            if (set == null || set.isEmpty()) {
                this.model.debugWarning("There is no email address for this user.");
                throw new PWResetException(rb.getString("noEmail.message"));
            }
            String emailAddress = (String)set.iterator().next();
            this.sendEmailToUser(emailAddress, password);
        }
        catch (SSOException e) {
            this.model.debugWarning("EmailPassword.notifyPassword", (Exception)((Object)e));
            throw new PWResetException((Throwable)((Object)e));
        }
        catch (IdRepoException e) {
            this.model.debugWarning("EmailPassword.notifyPassword", e);
            throw new PWResetException(e);
        }
        catch (SendFailedException e) {
            this.model.debugWarning("EmailPassword.notifyPassword", (Exception)((Object)e));
            throw new PWResetException(rb.getString("sendEmailFailed.message"));
        }
        catch (MessagingException e) {
            this.model.debugWarning("EmailPassword.notifyPassword", (Exception)((Object)e));
            throw new PWResetException(e);
        }
    }

    private void sendEmailToUser(String emailAddress, String password) throws MessagingException {
        Object[] obj = new String[]{password};
        ResourceBundle rb = PWResetResBundleCacher.getBundle(bundleName, this.userLocale);
        String msg = MessageFormat.format(rb.getString("resetPassMail.message"), obj);
        String subject = rb.getString("resetSubject.message");
        String[] to = new String[]{emailAddress};
        String from = rb.getString("fromAddress.label");
        String charset = g11nSettings.getDefaultCharsetForLocale(this.userLocale);
        AMSendMail sendMail = new AMSendMail();
        sendMail.postMail(to, subject, msg, from, charset);
    }
}

