/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.InvalidFormatException;
import com.sun.identity.policy.NameAlreadyExistsException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.ResponseProviderTypeManager;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.policy.interfaces.ResponseProvider;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResponseProviders {
    private String name;
    private String description;
    private Map providers = new HashMap();
    private static String RESPONSE_PROVIDERS_ELEMENT_BEGIN = "<ResponseProviders name=\"";
    private static String RESPONSE_PROVIDERS_DESCRIPTION = "\" description=\"";
    private static String RESPONSE_PROVIDERS_ELEMENT_END = "</ResponseProviders>";
    private static String RESPONSE_PROVIDER_ELEMENT = "<ResponseProvider name=\"";
    private static String RESPONSE_PROVIDER_TYPE = "\" type=\"";
    private static String RESPONSE_PROVIDER_ELEMENT_END = "</ResponseProvider>";

    ResponseProviders() {
    }

    protected ResponseProviders(ResponseProviderTypeManager rpm, Node responseProvidersNode) throws InvalidFormatException, NameNotFoundException, PolicyException {
        if (!responseProvidersNode.getNodeName().equalsIgnoreCase("ResponseProviders")) {
            if (PolicyManager.debug.warningEnabled()) {
                PolicyManager.debug.warning("invalid response providers xml blob given to construct response providers");
            }
            throw new InvalidFormatException("amPolicy", "invalid_xml_resp_providers_root_node", null, "", 7);
        }
        this.name = XMLUtils.getNodeAttributeValue((Node)responseProvidersNode, (String)"name");
        if (this.name == null) {
            this.name = "ResponseProviders:" + ServiceTypeManager.generateRandomName();
        }
        if ((this.description = XMLUtils.getNodeAttributeValue((Node)responseProvidersNode, (String)"description")) == null) {
            this.description = "";
        }
        for (Node providerNode : XMLUtils.getChildNodes((Node)responseProvidersNode, (String)"ResponseProvider")) {
            String providerType = XMLUtils.getNodeAttributeValue((Node)providerNode, (String)"type");
            if (providerType == null) {
                if (PolicyManager.debug.warningEnabled()) {
                    PolicyManager.debug.warning("provider type is null");
                }
                throw new InvalidFormatException("amPolicy", "invalid_xml_resp_provider_root_node", null, "", 7);
            }
            String providerName = XMLUtils.getNodeAttributeValue((Node)providerNode, (String)"name");
            ResponseProvider respProvider = rpm.getResponseProvider(providerType);
            HashMap<String, Set> properties = new HashMap<String, Set>();
            NodeList attrValuePairNodes = providerNode.getChildNodes();
            int numAttrValuePairNodes = attrValuePairNodes.getLength();
            for (int j = 0; j < numAttrValuePairNodes; ++j) {
                Node attrValuePairNode = attrValuePairNodes.item(j);
                Node attributeNode = XMLUtils.getChildNode((Node)attrValuePairNode, (String)"Attribute");
                if (attributeNode == null) continue;
                String name = XMLUtils.getNodeAttributeValue((Node)attributeNode, (String)"name");
                Set values = XMLUtils.getAttributeValuePair((Node)attrValuePairNode);
                if (name == null || values == null) continue;
                properties.put(name, values);
            }
            respProvider.setProperties(properties);
            this.addResponseProvider(providerName, respProvider);
        }
    }

    public ResponseProviders(String name, String description) {
        this.name = name == null ? "ResponseProviders:" + ServiceTypeManager.generateRandomName() : name;
        this.description = description == null ? "" : description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setName(String name) {
        this.name = name == null ? "ResponseProviders:" + ServiceTypeManager.generateRandomName() : name;
    }

    public void setDescription(String description) {
        this.description = description == null ? "" : description;
    }

    public Set getResponseProviderNames() {
        return this.providers.keySet();
    }

    public ResponseProvider getResponseProvider(String responseProviderName) throws NameNotFoundException {
        ResponseProvider answer = (ResponseProvider)this.providers.get(responseProviderName);
        if (answer == null) {
            Object[] objs = new String[]{responseProviderName};
            throw new NameNotFoundException("amPolicy", "name_not_present", objs, responseProviderName, 7);
        }
        return answer;
    }

    public void addResponseProvider(ResponseProvider responseProvider) throws NameAlreadyExistsException {
        this.addResponseProvider(null, responseProvider);
    }

    public void addResponseProvider(String responseProviderName, ResponseProvider responseProvider) throws NameAlreadyExistsException {
        if (responseProviderName == null) {
            responseProviderName = "ResponseProvider:" + ServiceTypeManager.generateRandomName();
        }
        if (this.providers.containsKey(responseProviderName)) {
            Object[] objs = new String[]{responseProviderName};
            throw new NameAlreadyExistsException("amPolicy", "name_already_present", objs, responseProviderName, 7);
        }
        this.providers.put(responseProviderName, responseProvider);
    }

    public void replaceResponseProvider(String responseProviderName, ResponseProvider responseProvider) throws NameNotFoundException {
        if (!this.providers.containsKey(responseProviderName)) {
            Object[] objs = new String[]{responseProviderName};
            throw new NameNotFoundException("amPolicy", "name_not_present", objs, responseProviderName, 7);
        }
        this.providers.put(responseProviderName, responseProvider);
    }

    public ResponseProvider removeResponseProvider(String responseProviderName) {
        return (ResponseProvider)this.providers.remove(responseProviderName);
    }

    public ResponseProvider removeResponseProvider(ResponseProvider responseProvider) {
        String responseProviderName = this.getResponseProviderName(responseProvider);
        if (responseProviderName != null) {
            return this.removeResponseProvider(responseProviderName);
        }
        return null;
    }

    public String getResponseProviderName(ResponseProvider responseProvider) {
        String responseProviderName = null;
        Iterator items = this.providers.keySet().iterator();
        while (items.hasNext() && !responseProvider.equals(this.providers.get(responseProviderName = (String)items.next()))) {
        }
        return responseProviderName;
    }

    public boolean equals(Object o) {
        if (o instanceof ResponseProviders) {
            ResponseProviders i = (ResponseProviders)o;
            Iterator iter = this.providers.entrySet().iterator();
            while (iter.hasNext()) {
                Object ss = iter.next().getValue();
                if (i.providers.containsValue(ss)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Object clone() {
        ResponseProviders answer = null;
        try {
            answer = (ResponseProviders)super.clone();
        }
        catch (CloneNotSupportedException se) {
            answer = new ResponseProviders();
        }
        answer.name = this.name;
        answer.description = this.description;
        answer.providers = new HashMap();
        for (Object item : this.providers.keySet()) {
            ResponseProvider responseProvider = (ResponseProvider)this.providers.get(item);
            answer.providers.put(item, responseProvider.clone());
        }
        return answer;
    }

    Map getResponseProviderDecision(SSOToken token, Map env) throws PolicyException, SSOException {
        HashMap attrsMap = new HashMap();
        Iterator items = this.providers.entrySet().iterator();
        while (items.hasNext()) {
            ResponseProvider responseProvider = (ResponseProvider)items.next().getValue();
            Map respProviderMap = responseProvider.getResponseDecision(token, env);
            PolicyUtils.appendMapToMap(respProviderMap, attrsMap);
        }
        return attrsMap;
    }

    public String toString() {
        return this.toXML();
    }

    protected String toXML() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("\n").append(RESPONSE_PROVIDERS_ELEMENT_BEGIN).append(XMLUtils.escapeSpecialCharacters((String)this.name)).append(RESPONSE_PROVIDERS_DESCRIPTION).append(XMLUtils.escapeSpecialCharacters((String)this.description)).append("\">");
        for (String responseProviderName : this.providers.keySet()) {
            ResponseProvider responseProvider = (ResponseProvider)this.providers.get(responseProviderName);
            sb.append("\n").append(RESPONSE_PROVIDER_ELEMENT).append(XMLUtils.escapeSpecialCharacters((String)responseProviderName)).append(RESPONSE_PROVIDER_TYPE).append(XMLUtils.escapeSpecialCharacters((String)ResponseProviderTypeManager.responseProviderTypeName(responseProvider))).append("\">\n");
            Map properties = responseProvider.getProperties();
            if (properties != null) {
                sb.append(PolicyUtils.mapToXMLString(properties));
            }
            sb.append(RESPONSE_PROVIDER_ELEMENT_END);
        }
        sb.append("\n").append(RESPONSE_PROVIDERS_ELEMENT_END);
        return sb.toString();
    }

    int size() {
        return this.providers.size();
    }
}

