/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.setup;

import com.sun.identity.setup.AMSetupServlet;
import com.sun.identity.shared.debug.Debug;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Set;
import javax.servlet.ServletContext;

public class ServiceXMLTemplates {
    private ServiceXMLTemplates() {
    }

    public static void copy(String dir, ServletContext servletCtx) {
        if (servletCtx == null) {
            return;
        }
        File d = new File(dir);
        d.mkdirs();
        String classesDir = "/WEB-INF/classes";
        Set res = servletCtx.getResourcePaths(classesDir);
        for (String templ : res) {
            if (!templ.endsWith(".xml")) continue;
            String content = ServiceXMLTemplates.getContent(templ, servletCtx);
            String fileName = templ.substring(classesDir.length() + 1);
            try {
                AMSetupServlet.writeToFile(dir + "/" + fileName, content);
            }
            catch (IOException e) {
                Debug.getInstance((String)"amSetupServlet").error("ServiceXMLTemplates.copy", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getContent(String templateName, ServletContext servletCtx) {
        InputStreamReader fin = null;
        StringBuffer sbuf = new StringBuffer();
        try {
            int len;
            fin = new InputStreamReader(AMSetupServlet.getResourceAsStream(servletCtx, templateName));
            char[] cbuf = new char[1024];
            while ((len = fin.read(cbuf)) > 0) {
                sbuf.append(cbuf, 0, len);
            }
        }
        catch (IOException e) {
            Debug.getInstance((String)"amSetupServlet").error("ServiceXMLTemplates.getContent", (Throwable)e);
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException e) {}
            }
        }
        return sbuf.toString();
    }
}

