/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.config.AMAuthenticationManager;
import com.sun.identity.authentication.config.AMConfigurationException;
import com.sun.identity.authentication.util.AMAuthUtils;
import com.sun.identity.policy.ConditionDecision;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.ResBundleUtils;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.interfaces.Condition;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class ResourceEnvIPCondition
implements Condition {
    private static final Debug DEBUG = Debug.getInstance((String)"amPolicy");
    public static final String ENV_CONDITION_VALUE = "resourceEnvIPConditionValue";
    public static final String IP = "IP";
    public static final String THEN = "THEN";
    private ArrayList envList = new ArrayList();
    private ArrayList adviceList = new ArrayList();
    private List propertyNames = new ArrayList();
    private Map properties;

    public ResourceEnvIPCondition() {
        this.propertyNames.add(ENV_CONDITION_VALUE);
    }

    public List getPropertyNames() {
        return this.propertyNames;
    }

    public Syntax getPropertySyntax(String property) {
        return Syntax.LIST;
    }

    public String getDisplayName(String property, Locale locale) throws PolicyException {
        return ResBundleUtils.getString(property);
    }

    public Set getValidValues(String property) throws PolicyException {
        return Collections.EMPTY_SET;
    }

    public void setProperties(Map properties) throws PolicyException {
        this.properties = properties;
        this.envList.clear();
        this.adviceList.clear();
        if (properties == null || properties.keySet() == null) {
            throw new PolicyException("amPolicy", "null_properties", null, null);
        }
        Set envCondVal = (Set)properties.get(ENV_CONDITION_VALUE);
        if (envCondVal == null || envCondVal.isEmpty() || envCondVal.size() == 0) {
            throw new PolicyException("amPolicy", "null_env_cond_value", null, null);
        }
        if (DEBUG.messageEnabled()) {
            DEBUG.message("ResourceEnvIPCondition:setProperties envCondVal : " + envCondVal);
        }
        Iterator envCondValIter = envCondVal.iterator();
        int i = 0;
        while (envCondValIter.hasNext()) {
            int adviceIndex;
            String envKey = (String)envCondValIter.next();
            if (envKey == null) continue;
            int ifIndex = envKey.indexOf("IF");
            if (ifIndex == -1) {
                ifIndex = envKey.indexOf("if");
            }
            if ((adviceIndex = envKey.indexOf(THEN)) == -1) {
                adviceIndex = envKey.indexOf("then");
            }
            String envVal = envKey.substring(ifIndex + 2, adviceIndex - 1);
            String adviceVal = envKey.substring(adviceIndex + 5);
            this.envList.add(i, envVal);
            this.adviceList.add(i, adviceVal);
            ++i;
        }
        if (DEBUG.messageEnabled()) {
            DEBUG.message("ResourceEnvIPCondition:setProperties envList : " + this.envList);
            DEBUG.message("ResourceEnvIPCondition:setProperties adviceList : " + this.adviceList);
        }
    }

    public Map getProperties() {
        return this.properties;
    }

    public ConditionDecision getConditionDecision(SSOToken token, Map env) throws PolicyException, SSOException {
        if (DEBUG.messageEnabled()) {
            DEBUG.message("ResourceEnvIPCondition:getConditionDecision - client environment map : " + env);
        }
        boolean allowed = false;
        HashMap<String, Set> advices = new HashMap<String, Set>();
        String adviceStr = this.getAdviceStrForEnv(env, token);
        String adviceName = null;
        String adviceValue = null;
        if (adviceStr != null && adviceStr.contains("=")) {
            int index = adviceStr.indexOf("=");
            adviceName = adviceStr.substring(0, index);
            adviceValue = adviceStr.substring(index + 1);
            if (DEBUG.messageEnabled()) {
                DEBUG.message("ResourceEnvIPCondition:getConditionDecision - adviceName : " + adviceName + " and adviceValue : " + adviceValue);
            }
            if (adviceName != null && adviceName.length() != 0 && adviceValue != null && adviceValue.length() != 0) {
                if (adviceName.equalsIgnoreCase("module")) {
                    Set adviceMessages = this.getAdviceMessagesforAuthScheme(adviceValue, token, env);
                    if (adviceMessages.isEmpty()) {
                        allowed = true;
                    } else {
                        advices.put("AuthSchemeConditionAdvice", adviceMessages);
                    }
                } else if (adviceName.equalsIgnoreCase("service")) {
                    Set adviceMessages = this.getAdviceMessagesforAuthService(adviceValue, token, env);
                    if (adviceMessages.isEmpty()) {
                        allowed = true;
                    } else {
                        advices.put("AuthenticateToServiceConditionAdvice", adviceMessages);
                    }
                } else if (adviceName.equalsIgnoreCase("authlevel")) {
                    Set adviceMessages = this.getAdviceMessagesforAuthLevel(adviceValue, token, env);
                    if (adviceMessages.isEmpty()) {
                        allowed = true;
                    } else {
                        advices.put("AuthLevelConditionAdvice", adviceMessages);
                    }
                } else if (adviceName.equalsIgnoreCase("role")) {
                    Set adviceMessages = this.getAdviceMessagesforRole(adviceValue, token, env);
                    if (adviceMessages.isEmpty()) {
                        allowed = true;
                    } else {
                        advices.put("AuthRoleConditionAdvice", adviceMessages);
                    }
                } else if (adviceName.equalsIgnoreCase("user")) {
                    Set adviceMessages = this.getAdviceMessagesforUser(adviceValue, token, env);
                    if (adviceMessages.isEmpty()) {
                        allowed = true;
                    } else {
                        advices.put("AuthUserConditionAdvice", adviceMessages);
                    }
                } else if (adviceName.equalsIgnoreCase("redirectURL")) {
                    Set adviceMessages = this.getAdviceMessagesforRedirectURL(adviceValue, token, env);
                    if (adviceMessages.isEmpty()) {
                        allowed = true;
                    } else {
                        advices.put("AuthRedirectionConditionAdvice", adviceMessages);
                    }
                } else if (adviceName.equalsIgnoreCase("realm") || adviceName.equalsIgnoreCase("org")) {
                    Set adviceMessages = this.getAdviceMessagesforRealm(adviceValue, token, env);
                    if (adviceMessages.isEmpty()) {
                        allowed = true;
                    } else {
                        advices.put("AuthenticateToRealmConditionAdvice", adviceMessages);
                    }
                } else if (DEBUG.messageEnabled()) {
                    DEBUG.message("At ResourceEnvIPCondition.getConditionDecision(): adviceName is invalid");
                }
            }
        } else {
            if (adviceStr != null) {
                Object[] args = new String[]{adviceStr};
                throw new PolicyException("amPolicy", "invalid_property_value", args, null);
            }
            if (DEBUG.messageEnabled()) {
                DEBUG.message("At ResourceEnvIPCondition.getConditionDecision(): Advice is NULL since there is no matching condition found.");
            }
        }
        return new ConditionDecision(allowed, advices);
    }

    /*
     * Unable to fully structure code
     */
    private Set getAdviceMessagesforAuthScheme(String adviceValue, SSOToken token, Map env) throws PolicyException, SSOException {
        adviceMessages = new HashSet<String>();
        requestAuthSchemes = null;
        requestAuthSchemesIgnoreRealm = null;
        if (env != null && env.get("requestAuthSchemes") != null) {
            try {
                requestAuthSchemes = (Set)env.get("requestAuthSchemes");
                if (!ResourceEnvIPCondition.DEBUG.messageEnabled()) ** GOTO lbl19
                ResourceEnvIPCondition.DEBUG.message("At ResourceEnvIPCondition.getAdviceMessagesforAuthScheme(): requestAuthSchemes from env= " + requestAuthSchemes);
            }
            catch (ClassCastException e) {
                args = new String[]{"requestAuthSchemes"};
                throw new PolicyException("amPolicy", "property_is_not_a_Set", args, e);
            }
        } else if (token != null) {
            requestAuthSchemes = AMAuthUtils.getRealmQualifiedAuthenticatedSchemes(token);
            requestAuthSchemesIgnoreRealm = AMAuthUtils.getAuthenticatedSchemes(token);
            if (ResourceEnvIPCondition.DEBUG.messageEnabled()) {
                ResourceEnvIPCondition.DEBUG.message("At ResourceEnvIPCondition.getAdviceMessagesforAuthScheme(): requestAuthSchemes from ssoToken= " + requestAuthSchemes);
                ResourceEnvIPCondition.DEBUG.message("At ResourceEnvIPCondition.getAdviceMessagesforAuthScheme(): requestAuthSchemesIgnoreRealm from ssoToken= " + requestAuthSchemesIgnoreRealm);
            }
        }
lbl19:
        // 7 sources

        if (requestAuthSchemes == null) {
            requestAuthSchemes = Collections.EMPTY_SET;
        }
        if (requestAuthSchemesIgnoreRealm == null) {
            requestAuthSchemesIgnoreRealm = Collections.EMPTY_SET;
        }
        if (!requestAuthSchemes.contains(authScheme = adviceValue)) {
            realm = AMAuthUtils.getRealmFromRealmQualifiedData(authScheme);
            if (realm != null && realm.length() != 0) {
                adviceMessages.add(authScheme);
                if (ResourceEnvIPCondition.DEBUG.messageEnabled()) {
                    ResourceEnvIPCondition.DEBUG.message("At ResourceEnvIPCondition.getAdviceMessagesforAuthScheme():authScheme not satisfied = " + authScheme);
                }
            } else if (!(realm != null && realm.length() != 0 || requestAuthSchemesIgnoreRealm.contains(authScheme))) {
                adviceMessages.add(authScheme);
                if (ResourceEnvIPCondition.DEBUG.messageEnabled()) {
                    ResourceEnvIPCondition.DEBUG.message("At ResourceEnvIPCondition.getAdviceMessagesforAuthScheme():authScheme not satisfied = " + authScheme);
                }
            }
        }
        if (ResourceEnvIPCondition.DEBUG.messageEnabled()) {
            ResourceEnvIPCondition.DEBUG.message("At ResourceEnvIPCondition.getAdviceMessagesforAuthScheme():authScheme = " + authScheme + "," + " requestAuthSchemes = " + requestAuthSchemes + ", " + " adviceMessages = " + adviceMessages);
        }
        return adviceMessages;
    }

    /*
     * Unable to fully structure code
     */
    private Set getAdviceMessagesforAuthService(String adviceValue, SSOToken token, Map env) throws PolicyException, SSOException {
        block11: {
            block12: {
                adviceMessages = new HashSet<String>();
                requestAuthnServices = new HashSet<E>();
                allow = false;
                if (env != null && env.get("requestAuthenticatedToServices") != null) {
                    try {
                        requestAuthnServices = (Set)env.get("requestAuthenticatedToServices");
                        if (!ResourceEnvIPCondition.DEBUG.messageEnabled()) ** GOTO lbl20
                        ResourceEnvIPCondition.DEBUG.message("At ResourceEnvIPCondition.getAdviceMessagesforAuthService(): requestAuthnServices from request = " + requestAuthnServices);
                    }
                    catch (ClassCastException e) {
                        args = new String[]{"requestAuthenticatedToServices"};
                        throw new PolicyException("amPolicy", "property_is_not_a_Set", args, e);
                    }
                } else if (token != null) {
                    authenticatedServices = AMAuthUtils.getRealmQualifiedAuthenticatedServices(token);
                    if (authenticatedServices != null) {
                        requestAuthnServices.addAll(authenticatedServices);
                    }
                    if (ResourceEnvIPCondition.DEBUG.messageEnabled()) {
                        ResourceEnvIPCondition.DEBUG.message("At ResourceEnvIPCondition.getAdviceMessagesforAuthService(): requestAuthnServices from ssoToken = " + requestAuthnServices);
                    }
                }
lbl20:
                // 7 sources

                if (requestAuthnServices.contains(adviceValue)) break block11;
                realm = AMAuthUtils.getRealmFromRealmQualifiedData(adviceValue);
                if (realm == null || realm.length() == 0) break block12;
                adviceMessages.add(adviceValue);
                if (!ResourceEnvIPCondition.DEBUG.messageEnabled()) break block11;
                ResourceEnvIPCondition.DEBUG.message("At ResourceEnvIPCondition.getAdviceMessagesforAuthService():authService not satisfied = " + adviceValue);
                break block11;
            }
            if (realm == null || realm.length() == 0) {
                for (String requestAuthnService : requestAuthnServices) {
                    service = AMAuthUtils.getDataFromRealmQualifiedData(requestAuthnService);
                    if (!adviceValue.equals(service)) continue;
                    allow = true;
                    break;
                }
            }
        }
        if (!allow) {
            adviceMessages.add(adviceValue);
        }
        if (ResourceEnvIPCondition.DEBUG.messageEnabled()) {
            ResourceEnvIPCondition.DEBUG.message("At ResourceEnvIPCondition.getAdviceMessagesforAuthService():authenticateToService = " + adviceValue + "," + " requestAuthnServices = " + requestAuthnServices + ", " + " adviceMessages = " + adviceMessages);
        }
        return adviceMessages;
    }

    private Set getAdviceMessagesforAuthLevel(String adviceValue, SSOToken token, Map env) throws PolicyException, SSOException {
        HashSet<String> adviceMessages = new HashSet<String>();
        int maxRequestAuthLevel = Integer.MIN_VALUE;
        String authLevel = adviceValue;
        String authRealm = null;
        int authLevelInt = Integer.MIN_VALUE;
        try {
            authRealm = AMAuthUtils.getRealmFromRealmQualifiedData(authLevel);
            String authLevelIntString = AMAuthUtils.getDataFromRealmQualifiedData(authLevel);
            authLevelInt = Integer.parseInt(authLevelIntString);
        }
        catch (NumberFormatException e) {
            Object[] args = new String[]{"AuthLevel"};
            throw new PolicyException("amPolicy", "property_is_not_an_Integer", args, null);
        }
        maxRequestAuthLevel = this.getMaxRequestAuthLevel(env, authRealm, authLevel);
        if (maxRequestAuthLevel == Integer.MIN_VALUE && token != null) {
            maxRequestAuthLevel = this.getMaxRequestAuthLevel(token, authRealm, authLevel);
        }
        if (maxRequestAuthLevel < authLevelInt) {
            adviceMessages.add(authLevel);
        }
        if (DEBUG.messageEnabled()) {
            DEBUG.message("At ResourceEnvIPCondition.getAdviceMessagesforAuthLevel():authLevel=" + authLevel + "authRealm=" + authRealm + ",maxRequestAuthLevel=" + maxRequestAuthLevel + ",adviceMessages=" + adviceMessages);
        }
        return adviceMessages;
    }

    private Set getAdviceMessagesforRole(String adviceValue, SSOToken token, Map env) throws PolicyException, SSOException {
        HashSet<String> adviceMessages = new HashSet<String>();
        boolean allow = false;
        if (token != null) {
            String userAuthRoleNames = token.getProperty("Role");
            if (DEBUG.messageEnabled()) {
                DEBUG.message("At ResourceEnvIPCondition.getAdviceMessagesforRole(): userAuthRoleNames from token =" + userAuthRoleNames);
            }
            if (userAuthRoleNames != null) {
                String userAuthRoleName = null;
                StringTokenizer st = new StringTokenizer(userAuthRoleNames, "|");
                while (st.hasMoreElements()) {
                    userAuthRoleName = (String)st.nextElement();
                    if (userAuthRoleName == null || !userAuthRoleName.equals(adviceValue)) continue;
                    allow = true;
                }
            }
        }
        if (!allow) {
            adviceMessages.add(adviceValue);
        }
        if (DEBUG.messageEnabled()) {
            DEBUG.message("At ResourceEnvIPCondition.getAdviceMessagesforRole():auth role =" + adviceValue + ",adviceMessages=" + adviceMessages);
        }
        return adviceMessages;
    }

    private Set getAdviceMessagesforUser(String adviceValue, SSOToken token, Map env) throws PolicyException, SSOException {
        HashSet<String> adviceMessages = new HashSet<String>();
        boolean allow = false;
        if (token != null) {
            String authUserNames = token.getProperty("UserToken");
            if (DEBUG.messageEnabled()) {
                DEBUG.message("At ResourceEnvIPCondition.getAdviceMessagesforUser(): userAuthRoleNames from token =" + authUserNames);
            }
            if (authUserNames != null) {
                String authUserName = null;
                StringTokenizer st = new StringTokenizer(authUserNames, "|");
                while (st.hasMoreElements()) {
                    authUserName = (String)st.nextElement();
                    if (authUserName == null || !authUserName.equals(adviceValue)) continue;
                    allow = true;
                }
            }
        }
        if (!allow) {
            adviceMessages.add(adviceValue);
        }
        if (DEBUG.messageEnabled()) {
            DEBUG.message("At ResourceEnvIPCondition.getAdviceMessagesforUser():auth user =" + adviceValue + ",adviceMessages=" + adviceMessages);
        }
        return adviceMessages;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Set getAdviceMessagesforRealm(String adviceValue, SSOToken token, Map env) throws PolicyException, SSOException {
        adviceMessages = new HashSet<String>();
        requestAuthnRealms /* !! */  = new HashSet<E>();
        if (env != null && env.get("requestAuthenticatedToRealms") != null) {
            try {
                requestAuthnRealms /* !! */  = (Set)env.get("requestAuthenticatedToRealms");
                if (!ResourceEnvIPCondition.DEBUG.messageEnabled()) ** GOTO lbl19
                ResourceEnvIPCondition.DEBUG.message("At ResourceEnvIPCondition.getAdviceMessagesforRealm(): requestAuthnRealms, from request / env = " + requestAuthnRealms /* !! */ );
            }
            catch (ClassCastException e) {
                args = new String[]{"requestAuthenticatedToRealms"};
                throw new PolicyException("amPolicy", "property_is_not_a_Set", args, e);
            }
        } else if (token != null) {
            authenticatedRealms = AMAuthUtils.getAuthenticatedRealms(token);
            if (authenticatedRealms != null) {
                requestAuthnRealms /* !! */ .addAll(authenticatedRealms);
            }
            if (ResourceEnvIPCondition.DEBUG.messageEnabled()) {
                ResourceEnvIPCondition.DEBUG.message("At ResourceEnvIPCondition.getAdviceMessagesforRealm(): requestAuthnRealms, from ssoToken = " + requestAuthnRealms /* !! */ );
            }
        }
lbl19:
        // 7 sources

        authRealm = adviceValue;
        if (!requestAuthnRealms /* !! */ .contains(authRealm)) {
            adviceMessages.add(authRealm);
            if (ResourceEnvIPCondition.DEBUG.messageEnabled()) {
                ResourceEnvIPCondition.DEBUG.message("At ResourceEnvIPCondition.getAdviceMessagesforRealm():authenticateToRealm not satisfied = " + authRealm);
            }
        }
        if (ResourceEnvIPCondition.DEBUG.messageEnabled()) {
            ResourceEnvIPCondition.DEBUG.message("At ResourceEnvIPCondition.getAdviceMessagesforRealm():authRealm = " + authRealm + "," + " requestAuthnRealms = " + requestAuthnRealms /* !! */  + ", " + " adviceMessages = " + adviceMessages);
        }
        return adviceMessages;
    }

    /*
     * Unable to fully structure code
     */
    private Set getAdviceMessagesforRedirectURL(String adviceValue, SSOToken token, Map env) throws PolicyException, SSOException {
        block17: {
            adviceMessages = new HashSet<String>();
            requestAuthSchemes = null;
            requestAuthSchemesIgnoreRealm = null;
            nullRealm = false;
            allow = false;
            orgName = "/";
            if (env != null && env.get("requestAuthSchemes") != null) {
                try {
                    policyConfigMap = (Map)env.get("sun.am.policyConfig");
                    if (policyConfigMap != null && (orgSet = (Set)policyConfigMap.get("OrganizationName")) != null) {
                        names = orgSet.iterator();
                        orgName = (String)names.next();
                    }
                    requestAuthSchemes = (Set)env.get("requestAuthSchemes");
                    if (!ResourceEnvIPCondition.DEBUG.messageEnabled()) ** GOTO lbl28
                    ResourceEnvIPCondition.DEBUG.message("At ResourceEnvIPCondition.getAdviceMessagesforRedirectURL(): requestAuthSchemes from env= " + requestAuthSchemes + " AND orgName from env= " + orgName);
                }
                catch (ClassCastException e) {
                    args = new String[]{"requestAuthSchemes"};
                    throw new PolicyException("amPolicy", "property_is_not_a_Set", args, e);
                }
            } else if (token != null) {
                orgName = token.getProperty("Organization");
                requestAuthSchemes = AMAuthUtils.getRealmQualifiedAuthenticatedSchemes(token);
                requestAuthSchemesIgnoreRealm = AMAuthUtils.getAuthenticatedSchemes(token);
                if (ResourceEnvIPCondition.DEBUG.messageEnabled()) {
                    ResourceEnvIPCondition.DEBUG.message("At ResourceEnvIPCondition.getAdviceMessagesforRedirectURL(): orgName from ssoToken= " + orgName);
                    ResourceEnvIPCondition.DEBUG.message("At ResourceEnvIPCondition.getAdviceMessagesforRedirectURL(): requestAuthSchemes from ssoToken= " + requestAuthSchemes);
                    ResourceEnvIPCondition.DEBUG.message("At ResourceEnvIPCondition.getAdviceMessagesforRedirectURL(): requestAuthSchemesIgnoreRealm from ssoToken= " + requestAuthSchemesIgnoreRealm);
                }
            }
lbl28:
            // 7 sources

            if (requestAuthSchemes == null) {
                requestAuthSchemes = Collections.EMPTY_SET;
            }
            if (requestAuthSchemesIgnoreRealm == null) {
                requestAuthSchemesIgnoreRealm = Collections.EMPTY_SET;
            }
            schemeInstance = null;
            authSchemeType = null;
            try {
                adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                for (String requestAuthnScheme : requestAuthSchemes) {
                    schemeInstance = AMAuthUtils.getDataFromRealmQualifiedData(requestAuthnScheme);
                    realm = AMAuthUtils.getRealmFromRealmQualifiedData(requestAuthnScheme);
                    if (realm == null || realm.length() == 0) {
                        nullRealm = true;
                        break;
                    }
                    authManager = new AMAuthenticationManager(adminToken, orgName);
                    authInstance = authManager.getAuthenticationInstance(schemeInstance);
                    authSchemeType = authInstance.getType();
                    if (!"Federation".equals(authSchemeType)) continue;
                    allow = true;
                    break;
                }
                if (!nullRealm) break block17;
                iter = requestAuthSchemesIgnoreRealm.iterator();
                while (iter.hasNext()) {
                    authManager = new AMAuthenticationManager(adminToken, orgName);
                    schemeInstance = (String)iter.next();
                    authInstance = authManager.getAuthenticationInstance(schemeInstance);
                    authSchemeType = authInstance.getType();
                    if (!"Federation".equals(authSchemeType)) continue;
                    allow = true;
                    break;
                }
            }
            catch (AMConfigurationException ace) {
                if (ResourceEnvIPCondition.DEBUG.warningEnabled()) {
                    ResourceEnvIPCondition.DEBUG.warning("ResourceEnvIPCondition.getAdviceMessagesforRedirectURL():got AMConfigurationException:schemeInstance=" + schemeInstance + ", authSchemeType = " + authSchemeType);
                }
                args = new Object[]{schemeInstance};
                throw new PolicyException("amPolicy", "auth_scheme_not_found", args, (Throwable)ace);
            }
        }
        if (!allow) {
            adviceMessages.add(adviceValue);
        }
        if (ResourceEnvIPCondition.DEBUG.messageEnabled()) {
            ResourceEnvIPCondition.DEBUG.message("At ResourceEnvIPCondition.getAdviceMessagesforRedirectURL():redirectURL=" + adviceValue + "schemeInstance=" + schemeInstance + ",authSchemeType=" + authSchemeType + ",adviceMessages=" + adviceMessages);
        }
        return adviceMessages;
    }

    private int getMaxRequestAuthLevel(Map env, String authRealm, String authLevel) throws PolicyException {
        Object envAuthLevelObject;
        int maxAuthLevel = Integer.MIN_VALUE;
        int currentAuthLevel = Integer.MIN_VALUE;
        if (DEBUG.messageEnabled()) {
            DEBUG.message("ResourceEnvIPCondition.getMaxRequestAuthLevel(envMap,authRealm,authLevel): entering: envMap= " + env + ", authRealm= " + authRealm + ", conditionAuthLevel= " + authLevel);
        }
        if ((envAuthLevelObject = env.get("requestAuthLevel")) != null) {
            if (envAuthLevelObject instanceof Integer) {
                if (authRealm == null || authRealm.length() == 0) {
                    maxAuthLevel = (Integer)envAuthLevelObject;
                    if (DEBUG.messageEnabled()) {
                        DEBUG.message("ResourceEnvIPCondition.getMaxRequestAuthLevel():Integer level in env= " + maxAuthLevel);
                    }
                }
            } else if (envAuthLevelObject instanceof Set) {
                Set envAuthLevelSet = (Set)envAuthLevelObject;
                if (!envAuthLevelSet.isEmpty()) {
                    for (Object envAuthLevelElement : envAuthLevelSet) {
                        if (!(envAuthLevelElement instanceof String)) {
                            if (DEBUG.warningEnabled()) {
                                DEBUG.warning("ResourceEnvIPCondition.getMaxRequestAuthLevel():requestAuthLevel Set element not String");
                            }
                            throw new PolicyException("amPolicy", "request_authlevel_in_env_set_element_not_string", null, null);
                        }
                        String qualifiedLevel = (String)envAuthLevelElement;
                        currentAuthLevel = this.getAuthLevel(qualifiedLevel);
                        if (authRealm == null || authRealm.length() == 0) {
                            if (currentAuthLevel <= maxAuthLevel) continue;
                            maxAuthLevel = currentAuthLevel;
                            continue;
                        }
                        String realmString = AMAuthUtils.getRealmFromRealmQualifiedData(qualifiedLevel);
                        if (!authRealm.equals(realmString) || currentAuthLevel <= maxAuthLevel) continue;
                        maxAuthLevel = currentAuthLevel;
                    }
                }
            } else {
                if (DEBUG.warningEnabled()) {
                    DEBUG.warning("ResourceEnvIPCondition.getMaxRequestAuthLevel():requestAuthLevel in env neither Integer nor Set");
                }
                throw new PolicyException("amPolicy", "request_authlevel_in_env_not_Integer_or_set", null, null);
            }
        }
        if (DEBUG.messageEnabled()) {
            DEBUG.message("ResourceEnvIPCondition.getMaxRequestAuthLevel(): returning: maxAuthLevel=" + maxAuthLevel);
        }
        return maxAuthLevel;
    }

    private int getMaxRequestAuthLevel(SSOToken token, String authRealm, String authLevel) throws PolicyException, SSOException {
        int maxAuthLevel = Integer.MIN_VALUE;
        if (DEBUG.messageEnabled()) {
            DEBUG.message("ResourceEnvIPCondition.getMaxRequestAuthLevel(token,authRealm,authLevel): entering: authRealm = " + authRealm + ", conditionAuthLevel= " + authLevel);
        }
        if (authRealm == null || authRealm.length() == 0) {
            Set levels = AMAuthUtils.getAuthenticatedLevels(token);
            if (DEBUG.messageEnabled()) {
                DEBUG.message("ResourceEnvIPCondition.getMaxRequestAuthLevel(): levels from token= " + levels);
            }
            if (levels != null && !levels.isEmpty()) {
                for (String levelString : levels) {
                    int level = this.getAuthLevel(levelString);
                    maxAuthLevel = level > maxAuthLevel ? level : maxAuthLevel;
                }
            }
        } else {
            Set qualifiedLevels = AMAuthUtils.getRealmQualifiedAuthenticatedLevels(token);
            if (DEBUG.messageEnabled()) {
                DEBUG.message("ResourceEnvIPCondition.getMaxRequestAuthLevel(): qualifiedLeves from token= " + qualifiedLevels);
            }
            if (qualifiedLevels != null && !qualifiedLevels.isEmpty()) {
                for (String qualifiedLevel : qualifiedLevels) {
                    String realm = AMAuthUtils.getRealmFromRealmQualifiedData(qualifiedLevel);
                    if (!authRealm.equals(realm)) continue;
                    int level = this.getAuthLevel(qualifiedLevel);
                    maxAuthLevel = level > maxAuthLevel ? level : maxAuthLevel;
                }
            }
        }
        if (DEBUG.messageEnabled()) {
            DEBUG.message("ResourceEnvIPCondition.getMaxRequestAuthLevel(): returning: maxAuthLevel= " + maxAuthLevel);
        }
        return maxAuthLevel;
    }

    private int getAuthLevel(String qualifiedLevel) throws PolicyException {
        int levelInt = 0;
        String levelString = AMAuthUtils.getDataFromRealmQualifiedData(qualifiedLevel);
        try {
            levelInt = Integer.parseInt(levelString);
        }
        catch (NumberFormatException nfe) {
            if (DEBUG.warningEnabled()) {
                DEBUG.warning("AuthLevelCondition.getAuthLevel(qualifiedLevel):got NumberFormatException:qualifiedLevel=" + qualifiedLevel + ", levelString = " + levelString);
            }
            Object[] args = new Object[]{levelString};
            throw new PolicyException("amPolicy", "auth_level_not_integer", args, nfe);
        }
        return levelInt;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String getAdviceStrForEnv(Map env, SSOToken token) throws PolicyException, SSOException {
        String adviceStr = null;
        int i = 0;
        while (i < this.envList.size()) {
            String key = (String)this.envList.get(i);
            if (key != null) {
                String envParamName;
                if (!key.contains("=")) {
                    Object[] args = new String[]{key};
                    throw new PolicyException("amPolicy", "resource_env_not_known", args, null);
                }
                StringTokenizer st = new StringTokenizer(key, "=");
                int tokenCount = st.countTokens();
                if (tokenCount != 2) {
                    Object[] args = new String[]{key};
                    throw new PolicyException("amPolicy", "invalid_property_value", args, null);
                }
                String envParamValue = envParamName = st.nextToken().trim();
                if (tokenCount == 2) {
                    envParamValue = st.nextToken().trim();
                }
                Set envSet = (Set)env.get(envParamName);
                String strEnv2 = null;
                if (envSet != null && !envSet.isEmpty()) {
                    for (String strEnv2 : envSet) {
                        if (strEnv2 == null || !strEnv2.equalsIgnoreCase(envParamValue)) continue;
                        adviceStr = (String)this.adviceList.get(i);
                        break;
                    }
                } else {
                    String strIP = null;
                    Object object = env.get("requestIp");
                    if (object instanceof Set) {
                        Set ipSet = (Set)object;
                        if (ipSet == null || ipSet.isEmpty()) {
                            if (token == null) throw new PolicyException("amPolicy", "client_ip_null", null, null);
                            strIP = token.getIPAddress().getHostAddress();
                        } else {
                            Iterator names = ipSet.iterator();
                            strIP = (String)names.next();
                        }
                    } else if (object instanceof String && (strIP = (String)object) == null) {
                        if (token == null) throw new PolicyException("amPolicy", "client_ip_null", null, null);
                        strIP = token.getIPAddress().getHostAddress();
                    }
                    long requestIp = this.stringToIp(strIP);
                    int bIndex = envParamValue.indexOf("[");
                    int lIndex = envParamValue.indexOf("]");
                    String ipVal = envParamValue.substring(bIndex + 1, lIndex);
                    if (ipVal.contains("-")) {
                        String startIp;
                        StringTokenizer stIP = new StringTokenizer(ipVal, "-");
                        int tokenCnt = stIP.countTokens();
                        if (tokenCnt > 2) {
                            Object[] args = new String[]{ipVal};
                            throw new PolicyException("amPolicy", "invalid_property_value", args, null);
                        }
                        String endIp = startIp = stIP.nextToken();
                        if (tokenCnt == 2) {
                            endIp = stIP.nextToken();
                        }
                        long lStartIP = this.stringToIp(startIp);
                        long lEndIP = this.stringToIp(endIp);
                        if (requestIp >= lStartIP && requestIp <= lEndIP) {
                            return (String)this.adviceList.get(i);
                        }
                    } else if (ipVal.contains(".")) {
                        long longIp = this.stringToIp(ipVal);
                        if (requestIp == longIp) {
                            return (String)this.adviceList.get(i);
                        }
                    } else {
                        if (ipVal.contains("*")) {
                            return (String)this.adviceList.get(i);
                        }
                        Object[] args = new String[]{ipVal};
                        throw new PolicyException("amPolicy", "resource_env_not_known", args, null);
                    }
                }
            }
            ++i;
        }
        return adviceStr;
    }

    private long stringToIp(String ip) throws PolicyException {
        StringTokenizer st = new StringTokenizer(ip, ".");
        int tokenCount = st.countTokens();
        if (tokenCount != 4) {
            Object[] args = new String[]{"ip", ip};
            throw new PolicyException("amPolicy", "invalid_property_value", args, null);
        }
        long ipValue = 0L;
        while (st.hasMoreElements()) {
            String s = st.nextToken();
            short ipElement = 0;
            try {
                ipElement = Short.parseShort(s);
            }
            catch (Exception e) {
                Object[] args = new String[]{"ip", ip};
                throw new PolicyException("amPolicy", "invalid_property_value", args, null);
            }
            if (ipElement < 0 || ipElement > 255) {
                Object[] args = new String[]{"ipElement", s};
                throw new PolicyException("amPolicy", "invalid_property_value", args, null);
            }
            ipValue = ipValue * 256L + (long)ipElement;
        }
        return ipValue;
    }

    public Object clone() {
        ResourceEnvIPCondition theClone = null;
        try {
            theClone = (ResourceEnvIPCondition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        if (this.properties != null) {
            theClone.properties = new HashMap();
            for (Object o : this.properties.keySet()) {
                HashSet values = new HashSet();
                values.addAll((Set)this.properties.get(o));
                theClone.properties.put(o, values);
            }
        }
        return theClone;
    }
}

