/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.windowsdesktopsso;

import com.iplanet.am.util.SystemProperties;
import java.util.HashMap;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public class WindowsDesktopSSOConfig
extends Configuration {
    public static final String defaultAppName = "com.sun.identity.authentication.windowsdesktopsso";
    private static final String kerberosModuleName = SystemProperties.get("com.sun.identity.authentication.module.WindowsDesktopSSO.Krb5LoginModule", "com.sun.security.auth.module.Krb5LoginModule");
    private static final String credsType = SystemProperties.get("com.sun.identity.authentication.module.WindowsDesktopSSO.credsType", "acceptor");
    private Configuration config = null;
    private String servicePrincipal = null;
    private String keytab = null;
    private String refreshConf = "false";

    public WindowsDesktopSSOConfig(Configuration config) {
        this.config = config;
    }

    public void setPrincipalName(String principalName) {
        this.servicePrincipal = principalName;
    }

    public void setKeyTab(String keytabFile) {
        this.keytab = keytabFile;
    }

    public void setRefreshConfig(String refresh) {
        this.refreshConf = refresh;
    }

    public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
        if (appName.equals(defaultAppName)) {
            HashMap<String, String> hashmap = new HashMap<String, String>();
            hashmap.put("principal", this.servicePrincipal);
            if (kerberosModuleName.equalsIgnoreCase("com.ibm.security.auth.module.Krb5LoginModule")) {
                hashmap.put("useKeytab", this.keytab);
                hashmap.put("credsType", credsType);
                hashmap.put("refreshKrb5Config", "false");
            } else {
                hashmap.put("storeKey", "true");
                hashmap.put("useKeyTab", "true");
                hashmap.put("keyTab", this.keytab);
                hashmap.put("doNotPrompt", "true");
                hashmap.put("refreshKrb5Config", this.refreshConf);
            }
            AppConfigurationEntry appConfigurationEntry = new AppConfigurationEntry(kerberosModuleName, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, hashmap);
            return new AppConfigurationEntry[]{appConfigurationEntry};
        }
        return this.config.getAppConfigurationEntry(appName);
    }

    public void refresh() {
        this.config.refresh();
    }
}

