/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli;

import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.BufferOutputWriter;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.CLIRequest;
import com.sun.identity.cli.CommandManager;
import com.sun.identity.cli.SubCommand;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;

public class WebCLIHelper {
    private BufferOutputWriter outputWriter = new BufferOutputWriter();
    private String jspName;
    private CommandManager cmdMgr;

    public WebCLIHelper(HttpServletRequest request, String definitionClass, String commandName, String jspName) throws CLIException {
        this.jspName = jspName;
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("outputWriter", this.outputWriter);
        env.put("locale", request.getLocale());
        env.put("definitionFiles", definitionClass);
        env.put("commandName", commandName);
        env.put("webEnabledURL", jspName);
        this.cmdMgr = new CommandManager(env);
    }

    public String getHTML(HttpServletRequest request, SSOToken ssoToken) throws CLIException {
        String html;
        String cmdName = request.getParameter("cmd");
        if (cmdName != null) {
            StringBuffer buff = new StringBuffer();
            buff.append(this.getNavBackLinkHTML());
            String submit = request.getParameter("submit");
            if (submit == null) {
                buff.append(this.autogenUI(cmdName));
            } else {
                buff.append(this.processRequest(cmdName, request, ssoToken));
            }
            html = buff.toString();
        } else {
            html = this.getUsageHTML();
        }
        this.outputWriter.clearBuffer();
        return html;
    }

    private String processRequest(String cmdName, HttpServletRequest request, SSOToken ssoToken) throws CLIException {
        SubCommand cmd = this.cmdMgr.getSubCommand(cmdName);
        if (!cmd.webEnabled()) {
            return "";
        }
        ArrayList<String> list = new ArrayList<String>();
        Map map = request.getParameterMap();
        for (String key : map.keySet()) {
            if (key.equals("submit") || key.equals("cmd") || key.endsWith("lblb")) continue;
            String[] values = (String[])map.get(key);
            if (cmd.isUnaryOption(key)) {
                list.add("--" + key);
                continue;
            }
            ArrayList<String> temp = new ArrayList<String>();
            for (int j = 0; j < values.length; ++j) {
                String str = values[j];
                if ((str = str.trim()).length() <= 0) continue;
                temp.add(str);
            }
            if (temp.isEmpty()) continue;
            list.add("--" + key);
            list.addAll(temp);
        }
        int sz = list.size();
        String[] args = new String[sz + 1];
        args[0] = cmdName;
        for (int i = 0; i < sz; ++i) {
            args[i + 1] = (String)list.get(i);
        }
        CLIRequest req = new CLIRequest(null, args, ssoToken);
        this.cmdMgr.addToRequestQueue(req);
        this.cmdMgr.serviceRequestQueue();
        return WebCLIHelper.escapeTags(this.outputWriter.getBuffer());
    }

    private String getNavBackLinkHTML() {
        return "<a href=\"" + this.jspName + "\">" + this.cmdMgr.getResourceBundle().getString("web-interface-goto-main-page") + "</a><br /><br />";
    }

    private String getUsageHTML() throws CLIException {
        String[] arg = new String[]{"--help"};
        CLIRequest req = new CLIRequest(null, arg);
        this.cmdMgr.addToRequestQueue(req);
        this.cmdMgr.serviceRequestQueue();
        String strHelp = this.outputWriter.getBuffer();
        int idx = strHelp.indexOf("  <a ");
        if (idx != -1) {
            strHelp = strHelp.substring(idx);
        }
        return strHelp;
    }

    public String autogenUI(String cmdName) throws CLIException {
        ResourceBundle rb = this.cmdMgr.getResourceBundle();
        StringBuffer buff = new StringBuffer();
        String[] paramCmdName = new String[]{cmdName};
        buff.append(MessageFormat.format(rb.getString("web-interface-cmd-name"), paramCmdName)).append("<br />");
        SubCommand cmd = this.cmdMgr.getSubCommand(cmdName);
        if (cmd == null || !cmd.webEnabled()) {
            throw new CLIException(rb.getString("web-interface-cmd-name-not-found"), 12);
        }
        buff.append(cmd.getDescription()).append("<br /><br />");
        buff.append("<form action=\"").append(this.jspName).append("?cmd=").append(cmdName).append("&submit=\" method=\"post\" ").append("onSubmit=\"selectListBoxes(this)\">");
        buff.append("<table border=0>");
        Iterator i = cmd.getMandatoryOptions().iterator();
        while (i.hasNext()) {
            this.genUI(cmd, (String)i.next(), true, buff);
        }
        i = cmd.getOptionalOptions().iterator();
        while (i.hasNext()) {
            this.genUI(cmd, (String)i.next(), false, buff);
        }
        buff.append("<tr><td colspan=2 align=\"center\">").append("<input type=\"submit\" value=\"").append(rb.getString("web-interface-button-submit")).append("\"/>&nbsp;").append("<input type=\"reset\" value=\"").append(rb.getString("web-interface-button-reset")).append("\"/></td></tr>");
        buff.append("</table></form>");
        return buff.toString();
    }

    public void genUI(SubCommand cmd, String opt, boolean mandatory, StringBuffer buff) {
        ResourceBundle rb = this.cmdMgr.getResourceBundle();
        if (!(cmd.isOptionAlias(opt) || this.isAuthField(opt) || this.isIgnored(cmd, opt))) {
            String desc = cmd.getOptionDescription(opt, true);
            if (desc.endsWith(".")) {
                desc = desc.substring(0, desc.length() - 1);
            }
            buff.append("<tr><td valign=\"top\">").append(desc);
            if (mandatory) {
                buff.append("<font color=\"red\">*</font>");
            }
            buff.append(":</td>");
            if (cmd.textareaUI(opt)) {
                buff.append("<td><textarea cols=75 rows=30 name=\"").append(opt).append("\"></textarea>");
            } else if (cmd.checkboxUI(opt)) {
                buff.append("<td><input type=\"checkbox\" name=\"").append(opt).append("\" value=\"true\" />");
            } else if (cmd.isBinaryOption(opt)) {
                if (opt.indexOf("password") == -1) {
                    buff.append("<td><input type=\"text\" name=\"").append(opt).append("\" />");
                } else {
                    buff.append("<td><input type=\"password\" name=\"").append(opt).append("\" />");
                }
            } else {
                buff.append("<td><table border=0><tr><td>").append("<select name=\"").append(opt).append("\" size=\"10\" style=\"width:200\" ").append("width=\"200\" multiple=\"true\">").append("<td><input type=\"button\" value=\"").append(rb.getString("web-interface-button-remove")).append("\"").append(" onClick=\"removeSelFromList('").append(opt).append("'); return false;\" />").append("</td></tr><tr><td colspan=2>").append("<input type=\"text\" name=\"").append(opt).append("lblb").append("\" size=\"30\"/>&nbsp;").append("<input type=\"button\" value=\"").append(rb.getString("web-interface-button-add")).append("\"").append(" onClick=\"addOption('").append(opt).append("'); return false;\" />").append("</td></tr></table>");
                buff.append("\n<script language=\"javascript\">").append("listboxes[listboxes.length] ='").append(opt).append("';").append("</script>");
            }
            buff.append("<br /><br />").append("</td></tr>");
        }
    }

    private boolean isAuthField(String opt) {
        return opt.equals("adminid") || opt.equals("password-file");
    }

    private boolean isIgnored(SubCommand cmd, String opt) {
        return opt.equals("continue") || opt.equals("outfile") || opt.equals("datafile") && cmd.isSupportedOption("attributevalues") || opt.equals("datafile") && cmd.isSupportedOption("entries") || opt.equals("datafile") && cmd.isSupportedOption("choicevalues");
    }

    public static String escapeTags(String html) {
        html = html.replaceAll("&", "&amp;");
        return html.replaceAll("<", "&lt;");
    }
}

