/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.datastore;

import com.iplanet.am.util.SSLSocketFactoryManager;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.util.Crypt;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.CLIUtil;
import com.sun.identity.cli.CommandManager;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.common.DNUtils;
import com.sun.identity.common.LDAPUtils;
import com.sun.identity.common.configuration.ServerConfigXML;
import com.sun.identity.common.configuration.ServerConfiguration;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.shared.ldap.LDAPConnection;
import com.sun.identity.shared.ldap.LDAPDN;
import com.sun.identity.shared.ldap.LDAPException;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSSchema;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

public class AddAMSDKIdRepoPlugin
extends AuthenticatedCommand {
    private static final String[] params = new String[]{"add-amsdk-idrepo-plugin"};
    private List directoryServers;
    private String bindDN;
    private String bindPwd;
    private String basedn;
    private String dUserPwd;
    private String pUserPwd;
    private String namingAttr = "uid";
    private String orgAttr = "o";

    private void init(RequestContext rc) throws Exception {
        this.directoryServers = rc.getOption("directory-servers");
        this.basedn = this.getStringOptionValue("basedn").trim();
        this.bindDN = this.getStringOptionValue("binddn").trim();
        this.bindPwd = CLIUtil.getFileContent(this.getCommandManager(), this.getStringOptionValue("bind-password-file"), true);
        this.dUserPwd = CLIUtil.getFileContent(this.getCommandManager(), this.getStringOptionValue("dsame-password-file"), true);
        this.pUserPwd = CLIUtil.getFileContent(this.getCommandManager(), this.getStringOptionValue("puser-password-file"), true);
        String attr = this.getStringOptionValue("user");
        if (attr != null && attr.trim().length() > 0) {
            this.namingAttr = attr.trim();
        }
        if ((attr = this.getStringOptionValue("org")) != null && attr.trim().length() > 0) {
            this.orgAttr = attr.trim();
        }
    }

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        IOutput outputWriter = this.getOutputWriter();
        try {
            this.init(rc);
            this.writeLog(0, Level.INFO, "ATTEMPT_ADD_AMSDK_PLUGIN", params);
            this.loadLDIFs();
            String xmlData = this.loadDAIService();
            this.addAMSDKSubSchema(xmlData);
            this.loadDelegrationPolicies(xmlData);
            this.updateServerConfigXML();
            outputWriter.printlnMessage(params[0] + ": " + this.getResourceString("datastore-add-amsdk-idrepo-plugin-succeeded"));
            this.writeLog(0, Level.INFO, "SUCCEED_ADD_AMSDK_PLUGIN", params);
        }
        catch (Exception e) {
            String[] p = new String[]{"Adding AMSDK plugin", e.getMessage()};
            this.writeLog(1, Level.INFO, "FAILED_ADD_AMSDK_PLUGIN", p);
            outputWriter.printlnMessage(params[0] + ": " + this.getResourceString("datastore-add-amsdk-idrepo-plugin-failed") + ": " + e.getMessage());
        }
    }

    private String loadDAIService() throws SMSException, SSOException, CLIException, IOException {
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String xmlData = null;
        ServiceManager sm = new ServiceManager(adminSSOToken);
        if (!sm.getServiceNames().contains("DAI")) {
            xmlData = this.getResourceContent("ums.xml");
            xmlData = xmlData.replaceAll("@USER_NAMING_ATTR@", this.namingAttr);
            xmlData = xmlData.replaceAll("@ORG_NAMING_ATTR@", this.orgAttr);
            this.registerService(xmlData, adminSSOToken);
        }
        return xmlData;
    }

    private void addAMSDKSubSchema(String xmlData) throws SMSException, SSOException, CLIException {
        SSOToken adminSSOToken = this.getAdminSSOToken();
        ServiceSchemaManager ssm = new ServiceSchemaManager(adminSSOToken, "sunIdentityRepositoryService", "1.0");
        ServiceSchema ss = ssm.getOrganizationSchema();
        if (!ss.getSubSchemaNames().contains("amSDK")) {
            xmlData = this.getResourceContent("idRepoAmSDK.xml");
            xmlData = xmlData.replaceAll("@NORMALIZED_ORGBASE@", DNUtils.normalizeDN(this.basedn));
            ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlData.getBytes());
            ss.addSubSchema(xmlInputStream);
        }
    }

    private void loadDelegrationPolicies(String xmlData) {
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        try {
            xmlData = this.getResourceContent("defaultDelegationPoliciesForAmSDK.xml");
            String smsRootSuffix = ServiceManager.getBaseDN();
            xmlData = xmlData.replaceAll("@SM_CONFIG_ROOT_SUFFIX@", smsRootSuffix);
            String smsRootHat = smsRootSuffix.replaceAll(",", "^");
            xmlData = xmlData.replaceAll("@SM_ROOT_SUFFIX_HAT@", smsRootHat);
            xmlData = xmlData.replaceAll("@ROOT_SUFFIX@", DNUtils.normalizeDN(this.basedn));
            ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlData.getBytes());
            PolicyManager pm = new PolicyManager(adminSSOToken, "/sunamhiddenrealmdelegationservicepermissions");
            PolicyUtils.createPolicies(pm, xmlInputStream);
        }
        catch (Exception e) {
            outputWriter.printlnMessage(params[0] + ": " + this.getResourceString("datastore-add-amsdk-idrepo-plugin-policies-failed") + ": " + e.getMessage());
        }
    }

    private void updateServerConfigXML() throws Exception {
        SSOToken adminSSOToken = this.getAdminSSOToken();
        Set servers = ServerConfiguration.getServers(adminSSOToken);
        HashMap<String, String> newValues = new HashMap<String, String>();
        newValues.put("com.sun.am.event.connection.disable.list", "");
        for (String instance : servers) {
            String serverconfig = ServerConfiguration.getServerConfigXML(adminSSOToken, instance);
            ServerConfigXML cxml = new ServerConfigXML(serverconfig);
            ServerConfigXML.ServerGroup defaultGroup = cxml.getDefaultServerGroup();
            if (this.directoryServers != null && !this.directoryServers.isEmpty()) {
                defaultGroup.hosts.clear();
                int i = 1;
                for (String dshost : this.directoryServers) {
                    String name = "SERVER" + i;
                    DSEntry dsEntry = new DSEntry(dshost);
                    String type = dsEntry.ssl ? "SSL" : "SIMPLE";
                    String host = dsEntry.host;
                    String port = Integer.toString(dsEntry.port);
                    defaultGroup.addHost(name, host, port, type);
                    ++i;
                }
            }
            defaultGroup.dsBaseDN = this.basedn;
            for (ServerConfigXML.DirUserObject user : defaultGroup.dsUsers) {
                if (user.type.equals("proxy")) {
                    user.dn = "cn=puser,ou=DSAME Users," + this.basedn;
                    user.password = Crypt.encode((String)this.pUserPwd);
                    continue;
                }
                if (!user.type.equals("admin")) continue;
                user.dn = "cn=dsameuser,ou=DSAME Users," + this.basedn;
                user.password = Crypt.encode((String)this.dUserPwd);
            }
            ServerConfiguration.setServerConfigXML(adminSSOToken, instance, cxml.toXML());
            ServerConfiguration.setServerInstance(adminSSOToken, instance, newValues);
        }
    }

    private String getResourceContent(String resName) throws CLIException {
        String configDir = SystemProperties.get("com.iplanet.services.configpath");
        return CLIUtil.getFileContent(this.getCommandManager(), configDir + "/template/xml/" + resName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerService(String xml, SSOToken adminSSOToken) throws SSOException, SMSException, IOException {
        ServiceManager serviceManager = new ServiceManager(adminSSOToken);
        ByteArrayInputStream serviceStream = null;
        try {
            serviceStream = new ByteArrayInputStream(xml.getBytes());
            serviceManager.registerServices(serviceStream);
        }
        finally {
            if (serviceStream != null) {
                ((InputStream)serviceStream).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLDIFs() throws Exception {
        CommandManager mgr = this.getCommandManager();
        List ldifs = this.getLDIFs();
        for (String dshost : this.directoryServers) {
            LDAPConnection ld = null;
            try {
                ld = this.getLDAPConnection(new DSEntry(dshost));
                String dbName = LDAPUtils.getDBName(this.basedn, ld);
                for (String file : ldifs) {
                    String content = CLIUtil.getFileContent(mgr, file);
                    String swapped = this.tagswap(content, dbName);
                    this.loadLDIF(ld, swapped);
                }
            }
            finally {
                try {
                    if (ld == null) continue;
                    ld.disconnect();
                }
                catch (LDAPException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLDIF(LDAPConnection ld, String ldif) throws Exception {
        ByteArrayInputStream reader = null;
        try {
            reader = new ByteArrayInputStream(ldif.getBytes());
            LDAPUtils.createSchemaFromLDIF(new DataInputStream(reader), ld);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private List getLDIFs() {
        ArrayList<String> ldifs = new ArrayList<String>();
        String configDir = SystemProperties.get("com.iplanet.services.configpath");
        String templateDir = configDir + "/ldif";
        ldifs.add(templateDir + "/sunds/amsdk_plugin/amsdk_sunone_schema2.ldif");
        ldifs.add(templateDir + "/sunds/sunds_user_schema.ldif");
        ldifs.add(templateDir + "/sunds/amsdk_plugin/amsdk_init_template.ldif");
        ldifs.add(templateDir + "/sunds/sunds_user_index.ldif");
        ldifs.add(templateDir + "/sunds/sunds_plugin.ldif");
        return ldifs;
    }

    private String tagswap(String orig, String dbName) throws Exception {
        String normalizedDN = LDAPDN.normalize((String)this.basedn);
        String escapedDN = SMSSchema.escapeSpecialCharacters(normalizedDN);
        String[] doms = LDAPDN.explodeDN((String)normalizedDN, (boolean)true);
        String rdn = doms[0];
        String peopleContainer = "People_" + this.basedn.replace(',', '_');
        orig = orig.replaceAll("@DB_NAME@", dbName);
        orig = orig.replaceAll("@NORMALIZED_RS@", escapedDN);
        orig = orig.replaceAll("@RS_RDN@", LDAPDN.escapeRDN((String)rdn));
        orig = orig.replaceAll("@ADMIN_PWD@", this.dUserPwd);
        orig = orig.replaceAll("@SERVER_HOST@", SystemProperties.get("com.iplanet.am.server.host"));
        orig = orig.replaceAll("@ORG_NAMING_ATTR@", this.orgAttr);
        orig = orig.replaceAll("@ORG_OBJECT_CLASS@", "sunmanagedisorganization");
        orig = orig.replaceAll("@People_NM_ORG_ROOT_SUFFIX@", peopleContainer);
        orig = orig.replaceAll("@AMLDAPUSERPASSWD@", this.pUserPwd);
        return orig;
    }

    private LDAPConnection getLDAPConnection(DSEntry ds) throws Exception {
        LDAPConnection ld = ds.ssl ? new LDAPConnection(SSLSocketFactoryManager.getSSLSocketFactory()) : new LDAPConnection();
        ld.setConnectTimeout(300);
        ld.connect(3, ds.host, ds.port, this.bindDN, this.bindPwd);
        return ld;
    }

    class DSEntry {
        boolean ssl;
        String host;
        int port;

        DSEntry(String ds) {
            String dslc = ds.toLowerCase();
            this.ssl = dslc.startsWith("ldaps://");
            String dshost = this.ssl ? ds.substring(8) : (dslc.startsWith("ldap://") ? ds.substring(7) : ds);
            int portIndex = dshost.indexOf(58);
            this.host = dshost;
            this.port = 389;
            if (portIndex != -1) {
                this.host = dshost.substring(0, portIndex);
                this.port = Integer.parseInt(dshost.substring(portIndex + 1));
            }
        }
    }
}

